/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.dialogs;

import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.dialogs.Messages;
import com.perforce.team.ui.dialogs.P4StatusDialog;
import java.text.MessageFormat;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public abstract class P4FormDialog
extends P4StatusDialog {
    protected boolean modified = false;
    private Type type = Type.CREATE;

    public P4FormDialog(Shell parent) {
        super(parent);
    }

    public P4FormDialog(Shell parent, String title) {
        super(parent);
    }

    public void setType(Type type) {
        if (type != null) {
            this.type = type;
        }
    }

    public Type getType() {
        return this.type;
    }

    public abstract boolean save();

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.type == Type.CREATE) {
            this.okStatusButton = this.createButton(parent, 0, Messages.P4FormDialog_Create, true);
        } else if (this.type == Type.EDIT) {
            this.okStatusButton = this.createButton(parent, 0, Messages.P4FormDialog_Save, true);
        }
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public boolean cancel() {
        if (this.isModified()) {
            String title = "";
            String message = "";
            switch (this.type) {
                case CREATE: {
                    title = MessageFormat.format(Messages.P4FormDialog_CancelCreationTitle, this.getModelLabel());
                    message = MessageFormat.format(Messages.P4FormDialog_CancelCreationMessage, this.getModelLabel());
                    break;
                }
                case EDIT: {
                    title = MessageFormat.format(Messages.P4FormDialog_CancelChangesTitle, this.getModelLabel());
                    message = MessageFormat.format(Messages.P4FormDialog_CancelChangesMessage, this.getModelLabel());
                }
            }
            return P4ConnectionManager.getManager().openQuestion(this.getShell(), title, message);
        }
        return true;
    }

    protected void cancelPressed() {
        if (this.cancel()) {
            super.cancelPressed();
        }
    }

    protected void okPressed() {
        if (this.save()) {
            super.okPressed();
        }
    }

    protected void handleShellCloseEvent() {
        if (this.cancel()) {
            super.handleShellCloseEvent();
        }
    }

    protected abstract String getModelLabel();

    protected boolean isModified() {
        return this.modified;
    }

    public static enum Type {
        CREATE,
        EDIT;

    }
}

