/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.dialogs;

import com.perforce.team.ui.dialogs.Messages;
import com.perforce.team.ui.dialogs.PerforceEditorInput;
import com.perforce.team.ui.dialogs.ResizableDialog;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class CompareDialog
extends ResizableDialog
implements IPropertyChangeListener {
    private CompareEditorInput fCompareEditorInput;
    private Button fCommitButton;

    CompareDialog(Shell shell, CompareEditorInput input) {
        super(shell, null);
        this.fCompareEditorInput = input;
        this.fCompareEditorInput.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public static int openCompareDialog(Shell shell, CompareEditorInput input) {
        CompareDialog dialog = CompareDialog.createCompareDialog(shell, input);
        int rc = 1;
        if (dialog != null) {
            rc = dialog.open();
        }
        return rc;
    }

    public static CompareDialog createCompareDialog(Shell shell, CompareEditorInput input) {
        CompareDialog dialog = null;
        if (CompareDialog.compareResultOK(shell, input)) {
            dialog = new CompareDialog(shell, input);
        }
        return dialog;
    }

    private static boolean compareResultOK(Shell shell, CompareEditorInput input) {
        block5: {
            new ProgressMonitorDialog(shell).run(true, true, (IRunnableWithProgress)input);
            String message = input.getMessage();
            if (message == null) break block5;
            MessageDialog.openError((Shell)shell, (String)"Compare Failed", (String)message);
            return false;
        }
        try {
            if (input.getCompareResult() == null) {
                MessageDialog.openInformation((Shell)shell, (String)"Compare", (String)"There are no differences between the selected inputs.");
                return false;
            }
            return true;
        }
        catch (InterruptedException message) {
        }
        catch (InvocationTargetException x) {
            MessageDialog.openError((Shell)shell, (String)"Compare Failed", (String)x.getTargetException().getMessage());
        }
        return false;
    }

    @Override
    public boolean close() {
        if (super.close()) {
            if (this.fCompareEditorInput != null) {
                this.fCompareEditorInput.addPropertyChangeListener((IPropertyChangeListener)this);
            }
            return true;
        }
        return false;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.fCompareEditorInput instanceof PerforceEditorInput && ((PerforceEditorInput)this.fCompareEditorInput).allowMerge()) {
            this.fCommitButton = this.createButton(parent, 0, "Commit", true);
            this.fCommitButton.setEnabled(false);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        } else {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.fCommitButton != null && this.fCompareEditorInput != null) {
            this.fCommitButton.setEnabled(this.fCompareEditorInput.isSaveNeeded());
        }
    }

    protected Control createDialogArea(Composite parent2) {
        Composite parent = (Composite)super.createDialogArea(parent2);
        Control c = this.fCompareEditorInput.createContents(parent);
        c.setLayoutData((Object)new GridData(1808));
        Shell shell = c.getShell();
        shell.setText(this.fCompareEditorInput.getTitle());
        shell.setImage(this.fCompareEditorInput.getTitleImage());
        CompareDialog.applyDialogFont((Control)parent);
        return parent;
    }

    protected void okPressed() {
        if (this.fCompareEditorInput.isSaveNeeded()) {
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                public void execute(IProgressMonitor pm) throws CoreException {
                    CompareDialog.this.fCompareEditorInput.saveChanges(pm);
                }
            };
            Shell shell = this.getParentShell();
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(shell);
            try {
                pmd.run(false, false, (IRunnableWithProgress)operation);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (OperationCanceledException operationCanceledException) {
            }
            catch (InvocationTargetException x) {
                String title = Messages.CompareDialog_SaveErrorTitle;
                String msg = Messages.CompareDialog_SaveErrorMessage;
                MessageDialog.openError((Shell)shell, (String)title, (String)(String.valueOf(msg) + x.getTargetException().getMessage()));
            }
        }
        super.okPressed();
    }
}

