/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.connection.mfa;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.connection.mfa.AuthResult;
import com.perforce.team.ui.connection.mfa.MFARunStatus;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;

public class MFAuthenticator {
    public String DEFAULT_APP_LOC = "/Users/tpethiyagoda/Downloads/HelixMFA.app/Contents/MacOS/HelixMFA";
    public String DEFAULT_APP_NAME = "HelixMFA";
    public static final int ERR_APP_NOT_FOUND_CODE = 404;
    private String port;
    private String user;
    private String mfaAppName;
    private String mfaAppLocation;
    private IP4Connection conn;
    private boolean forTesting;
    private IPreferenceStore prefStore = PerforceUIPlugin.getPlugin().getPreferenceStore();

    public MFAuthenticator() {
        this.DEFAULT_APP_LOC = this.prefStore.getString("com.perforce.team.ui.preferences.P4MFA_APP_PATH");
    }

    public MFAuthenticator withPort(String port) {
        this.port = port;
        return this;
    }

    public MFAuthenticator withUser(String user) {
        this.user = user;
        return this;
    }

    public MFAuthenticator with2FAApp(String mfaAppName) {
        this.mfaAppName = mfaAppName;
        if (this.mfaAppName == null || this.mfaAppName.isEmpty()) {
            this.mfaAppName = this.DEFAULT_APP_NAME;
        }
        return this;
    }

    public MFAuthenticator with2FAAppLocatedAt(String mfaAppLocation) {
        this.mfaAppLocation = mfaAppLocation;
        if (this.mfaAppLocation == null || this.mfaAppLocation.isEmpty()) {
            this.mfaAppLocation = this.DEFAULT_APP_LOC;
        }
        return this;
    }

    public MFAuthenticator withConnection(IP4Connection conn) {
        this.conn = conn;
        return this;
    }

    private boolean isAppExistsAtLocation() {
        if (this.mfaAppLocation == null || this.mfaAppLocation.trim().isEmpty()) {
            return false;
        }
        return Files.exists(Paths.get(this.mfaAppLocation, new String[0]), new LinkOption[0]);
    }

    private AuthResult<Integer> validate() {
        AuthResult<Integer> result = new AuthResult<Integer>(true, Integer.valueOf(0));
        boolean mfaRequired = this.isMFARequired();
        boolean appFound = this.isAppExistsAtLocation();
        if (!mfaRequired) {
            return result.withSuccess("MFA not required", MFARunStatus.MFANOTREQUIRED.getStatus());
        }
        if (!appFound) {
            return result.withFailure("Helix MFA Authenticator could not be found.", MFARunStatus.APPNOTFOUND.getStatus());
        }
        return result;
    }

    MFAuthenticator forTesting() {
        this.forTesting = true;
        return this;
    }

    private boolean isMFARequired() {
        String isRequired;
        block4: {
            try {
                isRequired = this.conn.getServer().getLogin2Status();
                if (!isRequired.contains("required")) break block4;
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }
        if (isRequired.contains("validated")) {
            return false;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    private boolean getMFARequired() {
        List resultMaps = null;
        try {
            Map code;
            HashMap<String, String> pwdMap = new HashMap<String, String>();
            pwdMap.put("password", String.valueOf(this.conn.getParameters().getPassword()) + "\n");
            resultMaps = this.conn.getServer().execMapCmdList("login2", new String[]{"-s"}, pwdMap);
            if (pwdMap == null) return false;
            Iterator values = resultMaps.iterator();
            do {
                if (!values.hasNext()) {
                    return false;
                }
                code = (Map)values.next();
                if (!code.values().contains("required")) continue;
                return true;
            } while (!code.values().contains("validated"));
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public AuthResult<Integer> authenticate() {
        int val = 0;
        AuthResult<Integer> result = new AuthResult<Integer>(true, Integer.valueOf(val));
        AuthResult<Integer> validatedResult = this.validate();
        result = result.getClone(validatedResult);
        if (!this.forTesting && result.isSuccessful() && result.getResultData().intValue() != MFARunStatus.MFANOTREQUIRED.getStatus()) {
            Process p = null;
            try {
                ProcessBuilder pb = new ProcessBuilder(this.mfaAppLocation, this.port, this.user);
                pb.inheritIO();
                p = pb.start();
                p.waitFor();
                if (p != null) {
                    p.destroy();
                }
                result = (val = p.exitValue()) == 0 ? result.withSuccess("Authentication successful", val) : result.withFailure("Authentication failed", val);
            }
            catch (Exception ex) {
                return result.withFailure(ex.getMessage(), 1);
            }
        }
        return result;
    }
}

