/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.connection;

import com.perforce.p4java.exception.P4JavaException;
import com.perforce.team.core.ConnectionParameters;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.ErrorHandler;
import com.perforce.team.core.p4java.IErrorHandler;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.P4Connection;
import com.perforce.team.core.p4java.builder.ClientBuilder;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.connection.AbstractConnectionWizard;
import com.perforce.team.ui.connection.ClientWizardPage;
import com.perforce.team.ui.connection.IConnectionWizard;
import com.perforce.team.ui.connection.Messages;
import com.perforce.team.ui.connection.ServerWizardPage;
import com.perforce.team.ui.project.ImportProjectsWizard;
import com.perforce.team.ui.swarmreview.PendingReviewManager;
import com.perforce.team.ui.swarmreview.ReviewManager;
import com.perforce.team.ui.swarmreview.apimodel.SwarmAPIVersions;
import com.perforce.team.ui.swarmreview.restapi.Result;
import com.perforce.team.ui.swarmreview.util.SwarmReviewUtil;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class ConnectionWizard
extends AbstractConnectionWizard
implements IConnectionWizard,
INewWizard {
    public ConnectionWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public ConnectionWizard(IP4Connection initial) {
        super(initial);
    }

    public ConnectionWizard(String initialPort, String initialUser, String initialClient, String initialCharset) {
        super(initialPort, initialUser, initialClient, initialCharset);
    }

    public void addPages() {
        this.serverPage = new ServerWizardPage("serverPage");
        this.addPage((IWizardPage)this.serverPage);
        this.clientPage = new ClientWizardPage("clientPage", true);
        this.addPage((IWizardPage)this.clientPage);
    }

    @Override
    public String getPort() {
        return this.serverPage.getPort();
    }

    @Override
    public String getUser() {
        return this.serverPage.getUser();
    }

    @Override
    public String getClient() {
        return this.clientPage.getClient();
    }

    private ConnectionParameters createParameters() {
        ConnectionParameters params = new ConnectionParameters();
        params.setPort(this.getPort());
        params.setClient(this.getClient());
        params.setUser(this.getUser());
        params.setCharset(this.getCharset());
        params.setPassword(this.getPassword());
        params.setSavePassword(this.serverPage.savePassword());
        params.setIgnoreSSLValidation(this.isIgnoreSSLValidation());
        params.setAuthTicket(this.getAuthTicket());
        return params;
    }

    @Override
    public boolean performFinish() {
        final ConnectionParameters params = this.createParameters();
        PerforceUIPlugin.storePasswordInUI(params);
        final boolean newClient = this.isNewClient();
        final boolean[] finished = new boolean[]{true};
        final String stream = this.clientPage.getStream();
        try {
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    monitor.beginTask(MessageFormat.format(Messages.ConnectionWizard_AddingConnection, params.getPort()), 4);
                    if (newClient) {
                        finished[0] = ConnectionWizard.this.createClient(params, stream, monitor);
                        if (!finished[0]) {
                            monitor.done();
                            return;
                        }
                    } else {
                        monitor.worked(1);
                    }
                    ConnectionWizard.this.saveConnection(params, monitor);
                    ConnectionWizard.this.saveServerHistory(monitor);
                    monitor.done();
                }
            });
        }
        catch (Throwable t) {
            PerforceProviderPlugin.logError((Throwable)t);
        }
        if (finished[0] && this.clientPage.isLaunchImportWizard()) {
            final Rectangle bound = this.getContainer().getShell().getBounds();
            UIJob job = new UIJob(Messages.ConnectionWizard_PrepareForImportingProjects){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    IP4Connection connection = P4ConnectionManager.getManager().getConnection(params);
                    ImportProjectsWizard wizard = new ImportProjectsWizard(connection);
                    WizardDialog dialog = new WizardDialog(P4UIUtils.getShell(), wizard){

                        protected void configureShell(Shell newShell) {
                            super.configureShell(newShell);
                            newShell.setBounds(bound);
                        }
                    };
                    dialog.setBlockOnOpen(false);
                    dialog.create();
                    PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "com.perforce.team.ui.p4_import_project");
                    dialog.open();
                    ConnectionWizard.this.checkSwarm(dialog.getShell());
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        return finished[0];
    }

    private void checkSwarm(Shell shell) {
        ReviewManager<IP4PendingChangelist> swarmReviewManager = PendingReviewManager.getInstance(super.getConnection());
        Result<SwarmAPIVersions> result = swarmReviewManager.checkVersion(null);
        SwarmReviewUtil.setStatus("", false);
        if (!result.isSuccessful()) {
            SwarmReviewUtil.setStatus(result.getMessage(), result.isSuccessful());
            if (!result.isReportInSilence()) {
                MessageDialog.openInformation((Shell)shell, (String)"P4 Code Review Connection", (String)result.getMessage());
            }
        }
    }

    private boolean createClient(ConnectionParameters params, String stream, IProgressMonitor monitor) {
        monitor.subTask(NLS.bind((String)Messages.ConnectionWizard_CreatingClient, (Object)params.getClient()));
        ClientBuilder builder = new ClientBuilder(params, this.clientPage.getLocation(), stream);
        ErrorHandler handler = new ErrorHandler(){

            public boolean shouldRetry(IP4Connection connection, P4JavaException exception) {
                boolean retry = false;
                if (P4ConnectionManager.isLoginError(exception.getMessage())) {
                    retry = P4ConnectionManager.getManager().displayException(connection, exception, true, false);
                } else {
                    P4ConnectionManager.getManager().displayException(connection, exception, false, false);
                }
                return retry;
            }
        };
        if (!builder.build((IErrorHandler)handler)) {
            PerforceUIPlugin.syncExec(new Runnable(){

                @Override
                public void run() {
                    ConnectionWizard.this.getContainer().showPage((IWizardPage)ConnectionWizard.this.clientPage);
                    P4ConnectionManager.getManager().openError(ConnectionWizard.this.getShell(), Messages.ConnectionWizard_ClientExistsTitle, NLS.bind((String)Messages.ConnectionWizard_ClientExistsMessage, (Object)ConnectionWizard.this.getClient()));
                }
            });
            return false;
        }
        monitor.worked(1);
        return true;
    }

    private void saveConnection(ConnectionParameters params, IProgressMonitor monitor) {
        monitor.subTask(Messages.ConnectionWizard_SavingConnection);
        P4ConnectionManager.getManager().add(params);
        monitor.worked(1);
    }

    private void saveServerHistory(IProgressMonitor monitor) {
        monitor.subTask(Messages.ConnectionWizard_SavingServerHistory);
        PerforceUIPlugin.syncExec(new Runnable(){

            @Override
            public void run() {
                ConnectionWizard.this.serverPage.saveServerHistory();
            }
        });
        monitor.worked(1);
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    @Override
    public String getCharset() {
        return this.serverPage.getCharset();
    }

    @Override
    public String getPassword() {
        return this.serverPage.getPassword();
    }

    @Override
    public String getAuthTicket() {
        return this.authTicket;
    }

    @Override
    public void setAuthTicket(String authTicket) {
        this.authTicket = authTicket;
    }

    @Override
    public String getStream() {
        if (this.isNewClient()) {
            return this.clientPage.getStream();
        }
        P4Connection conn = new P4Connection(this.createParameters());
        return conn.getClient().getStream();
    }

    @Override
    public boolean isNewClient() {
        boolean newClient = this.clientPage.isNewClientSelected();
        return newClient;
    }

    @Override
    public boolean isIgnoreSSLValidation() {
        return this.serverPage.isIgnoreSSLValidation();
    }
}

