/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.connection;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.client.IClientSummary;
import com.perforce.p4java.core.IStreamSummary;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.ErrorHandler;
import com.perforce.team.core.p4java.IErrorHandler;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.P4BrowsableConnection;
import com.perforce.team.core.p4java.P4Workspace;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.connection.BaseConnectionWizardPage;
import com.perforce.team.ui.connection.Messages;
import com.perforce.team.ui.streams.StreamsSuggestProvider;
import com.perforce.team.ui.streams.SuggestBox;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;

public class ClientWizardPage
extends BaseConnectionWizardPage {
    private Composite displayArea;
    private Button existingWorkspaceButton;
    private Button hostOnlyButton;
    private Table workspaceTable;
    private Label workspaceLabel;
    private ToolBar workspaceBar;
    private ToolItem refreshItem;
    private Image refreshImage;
    private Text workspaceText;
    private TextContentAdapter contentAdapter;
    private SimpleContentProposalProvider provider;
    private ContentAssistCommandAdapter contentAssist;
    private Button newWorkspaceButton;
    private Label nameLabel;
    private Text nameText;
    private Label nameInstructionsLabel;
    private Label locationLabel;
    private Text locationText;
    private Button locationButton;
    private boolean create = false;
    private String client = null;
    private String location = null;
    private boolean errorShown = false;
    private boolean updateName = false;
    private boolean needMatch = true;
    private IErrorHandler handler = new ErrorHandler(){

        public boolean shouldRetry(IP4Connection connection, P4JavaException exception) {
            boolean retry = false;
            if (!ClientWizardPage.this.errorShown) {
                if (P4ConnectionManager.isClientNonExistentError(exception.getMessage())) {
                    ClientWizardPage.this.showClientError(connection);
                } else {
                    retry = P4ConnectionManager.getManager().displayException(connection, exception, true, false);
                }
                ClientWizardPage.this.errorShown = !retry;
            }
            return retry;
        }
    };
    private ModifyListener modify = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (e.getSource() == ClientWizardPage.this.nameText) {
                ClientWizardPage.this.updateName = true;
                if (ClientWizardPage.this.needMatch) {
                    ClientWizardPage.this.locationText.setText(String.valueOf(ClientWizardPage.this.getDefaultLocation()) + File.separatorChar + ClientWizardPage.this.nameText.getText());
                }
                ClientWizardPage.this.updateName = false;
            } else if (e.getSource() == ClientWizardPage.this.locationText && !ClientWizardPage.this.updateName) {
                ClientWizardPage.this.needMatch = false;
            }
            ClientWizardPage.this.validatePage();
        }
    };
    private SuggestBox streamCombo;
    private Button launchImportButton;
    private boolean showLaunchImportOption = false;

    public ClientWizardPage(String pageName) {
        super(pageName);
        this.setImageDescriptor(PerforceUIPlugin.getPlugin().getImageDescriptor("perforce/wizard.png"));
        this.setTitle(Messages.ClientWizardPage_ChooseClientTitle);
        this.setDescription(Messages.ClientWizardPage_ChooseClientMessage);
    }

    public ClientWizardPage(String pageName, boolean launchImport) {
        this(pageName);
        this.showLaunchImportOption = launchImport;
    }

    private void createWorkspaceTable(Composite parent) {
        Composite workspaceArea = new Composite(parent, 0);
        GridLayout waLayout = new GridLayout(3, false);
        waLayout.marginLeft = 15;
        waLayout.marginHeight = 0;
        waLayout.marginWidth = 0;
        workspaceArea.setLayout((Layout)waLayout);
        workspaceArea.setLayoutData((Object)new GridData(4, 4, true, false));
        this.hostOnlyButton = new Button(workspaceArea, 32);
        this.hostOnlyButton.setText(String.valueOf(Messages.ClientWizardPage_HostOnly) + " (" + this.getHostname() + ")");
        this.hostOnlyButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 3, 1));
        this.hostOnlyButton.setSelection(true);
        this.hostOnlyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClientWizardPage.this.loadClients();
                ClientWizardPage.this.validatePage();
            }
        });
        this.workspaceLabel = new Label(workspaceArea, 16384);
        this.workspaceLabel.setText(Messages.ClientWizardPage_ExistingWorkspaceName);
        this.workspaceText = new Text(workspaceArea, 2052);
        this.workspaceText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.workspaceText.addModifyListener(this.modify);
        this.contentAdapter = new TextContentAdapter();
        this.provider = new SimpleContentProposalProvider(new String[0]){

            public IContentProposal[] getProposals(String contents, int position) {
                ArrayList<IContentProposal> matching = new ArrayList<IContentProposal>();
                IContentProposal[] iContentProposalArray = super.getProposals(contents, position);
                int n = iContentProposalArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IContentProposal proposal = iContentProposalArray[n2];
                    String propContent = proposal.getContent();
                    if (propContent != null && propContent.length() >= contents.length() && propContent.substring(0, contents.length()).equalsIgnoreCase(contents)) {
                        matching.add(proposal);
                    }
                    ++n2;
                }
                return matching.toArray(new IContentProposal[0]);
            }
        };
        this.contentAssist = new ContentAssistCommandAdapter((Control)this.workspaceText, (IControlContentAdapter)this.contentAdapter, (IContentProposalProvider)this.provider, null, null);
        try {
            this.contentAssist.setAutoActivationCharacters(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.contentAssist.setProposalAcceptanceStyle(2);
        this.workspaceBar = new ToolBar(workspaceArea, 0x800000);
        this.refreshItem = new ToolItem(this.workspaceBar, 8);
        this.refreshItem.setToolTipText(Messages.ClientWizardPage_RefreshWorkspaces);
        this.refreshImage = PerforceUIPlugin.getPlugin().getImageDescriptor("normal/refresh.png").createImage();
        this.refreshItem.setImage(this.refreshImage);
        this.refreshItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClientWizardPage.this.loadClients();
                ClientWizardPage.this.validatePage();
            }
        });
        this.workspaceTable = new Table(parent, 68356);
        GridData wtData = new GridData(4, 4, true, true);
        wtData.horizontalIndent = 15;
        wtData.heightHint = 100;
        this.workspaceTable.setLayoutData((Object)wtData);
        this.workspaceTable.setHeaderVisible(true);
        this.workspaceTable.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
        this.workspaceTable.setLayout((Layout)layout);
        TableColumn clientColumn = new TableColumn(this.workspaceTable, 16384);
        clientColumn.setText(Messages.ClientWizardPage_Client);
        TableColumn rootColumn = new TableColumn(this.workspaceTable, 16384);
        rootColumn.setText(Messages.ClientWizardPage_Root);
        TableColumn streamColumn = new TableColumn(this.workspaceTable, 16384);
        streamColumn.setText(Messages.ClientWizardPage_Stream);
        TableColumn hostColumn = new TableColumn(this.workspaceTable, 16384);
        hostColumn.setText(Messages.ClientWizardPage_Host);
        this.workspaceTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ClientWizardPage.this.workspaceTable.getSelectionCount() == 1) {
                    TableItem selected = ClientWizardPage.this.workspaceTable.getSelection()[0];
                    ClientWizardPage.this.workspaceText.setText(selected.getText(0));
                    ClientWizardPage.this.validatePage();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (ClientWizardPage.this.workspaceTable.getSelectionCount() == 1) {
                    TableItem selected = ClientWizardPage.this.workspaceTable.getSelection()[0];
                    ClientWizardPage.this.workspaceText.setText(selected.getText(0));
                    ClientWizardPage.this.validatePage();
                    ClientWizardPage.this.getWizard().getContainer().showPage(ClientWizardPage.this.getNextPage());
                }
            }
        });
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.loadClients();
            this.streamCombo.setSuggestProvider(new StreamsSuggestProvider(this.createConnection(true, true)));
            this.validatePage();
        }
        super.setVisible(visible);
        if (visible && this.isExistingClientSelected()) {
            this.workspaceText.setFocus();
        }
    }

    private void createNewWorkspaceArea(Composite parent) {
        Composite newArea = new Composite(parent, 0);
        newArea.setLayout((Layout)new GridLayout(3, false));
        GridData naData = new GridData(4, 4, true, true);
        naData.horizontalIndent = 15;
        newArea.setLayoutData((Object)naData);
        this.nameLabel = new Label(newArea, 16384);
        this.nameLabel.setText(Messages.ClientWizardPage_WorkspaceName);
        this.nameLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.nameText = new Text(newArea, 2052);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).indent(10, -1).applyTo((Control)this.nameText);
        this.nameText.addModifyListener(this.modify);
        this.nameText.setEnabled(false);
        new Label(newArea, 0);
        new Label(newArea, 0);
        this.nameInstructionsLabel = new Label(newArea, 16384);
        this.nameInstructionsLabel.setText(Messages.ClientWizardPage_NoSpacesAllowed);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).indent(10, -1).applyTo((Control)this.nameInstructionsLabel);
        new Label(newArea, 0);
        this.locationLabel = new Label(newArea, 16384);
        this.locationLabel.setText(Messages.ClientWizardPage_Location);
        this.locationLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.locationText = new Text(newArea, 2052);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).indent(10, -1).applyTo((Control)this.locationText);
        String defaultLocation = this.getDefaultLocation();
        this.locationText.setText(defaultLocation);
        this.locationText.addModifyListener(this.modify);
        this.locationText.setEnabled(false);
        this.locationButton = new Button(newArea, 8);
        this.locationButton.setText(Messages.ClientWizardPage_Browse);
        this.locationButton.setEnabled(false);
        this.locationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(ClientWizardPage.this.locationButton.getShell(), 0);
                String dir = dialog.open();
                if (dir != null) {
                    ClientWizardPage.this.locationText.setText(dir);
                }
            }
        });
        Label streamLabel = new Label(newArea, 16384);
        streamLabel.setText(Messages.ClientWizardPage_StreamLabel);
        GridDataFactory.swtDefaults().align(0x1000008, 0x1000000).grab(false, false).applyTo((Control)streamLabel);
        this.streamCombo = new SuggestBox(newArea, 0, new StreamsSuggestProvider(this.createConnection(true, true)));
        GridDataFactory.swtDefaults().indent(10, -1).align(4, 0x1000000).grab(true, false).applyTo((Control)this.streamCombo);
        this.streamCombo.setEnabled(false);
        this.streamCombo.getModel().addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                ClientWizardPage.this.validatePage();
            }
        });
    }

    private String getDefaultLocation() {
        IPreferenceStore store = PerforceUIPlugin.getPlugin().getPreferenceStore();
        String defaultLocation = store.getString("pref_client_root_parent_default");
        if (defaultLocation == null) {
            defaultLocation = System.getProperty("user.home");
            if (defaultLocation != null) {
                if (!defaultLocation.endsWith(Character.toString(File.separatorChar))) {
                    defaultLocation = String.valueOf(defaultLocation) + File.separatorChar;
                }
                defaultLocation = String.valueOf(defaultLocation) + "Perforce";
            } else {
                defaultLocation = "";
            }
        }
        return defaultLocation;
    }

    public void createControl(Composite parent) {
        this.displayArea = new Composite(parent, 0);
        this.displayArea.setLayout((Layout)new GridLayout(1, true));
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.existingWorkspaceButton = new Button(this.displayArea, 16);
        this.existingWorkspaceButton.setText(Messages.ClientWizardPage_SelectExistingWorkspace);
        this.existingWorkspaceButton.setSelection(true);
        this.existingWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = ClientWizardPage.this.existingWorkspaceButton.getSelection();
                ClientWizardPage.this.workspaceText.setEnabled(selected);
                ClientWizardPage.this.workspaceTable.setEnabled(selected);
                ClientWizardPage.this.refreshItem.setEnabled(selected);
                ClientWizardPage.this.validatePage();
            }
        });
        this.createWorkspaceTable(this.displayArea);
        this.newWorkspaceButton = new Button(this.displayArea, 16);
        this.newWorkspaceButton.setText(Messages.ClientWizardPage_CreateNewWorkspace);
        this.newWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = ClientWizardPage.this.newWorkspaceButton.getSelection();
                ClientWizardPage.this.nameText.setEnabled(selected);
                ClientWizardPage.this.locationText.setEnabled(selected);
                ClientWizardPage.this.locationButton.setEnabled(selected);
                ClientWizardPage.this.streamCombo.setEnabled(selected);
                ClientWizardPage.this.validatePage();
            }
        });
        this.createNewWorkspaceArea(this.displayArea);
        this.createImportOptionArea(this.displayArea);
        this.setPageComplete(false);
        this.setControl((Control)this.displayArea);
    }

    private void createImportOptionArea(Composite parent) {
        if (this.showLaunchImportOption) {
            Composite optArea = new Composite(parent, 0);
            optArea.setLayout((Layout)new GridLayout(1, false));
            GridData data = new GridData(4, 4, true, false);
            optArea.setLayoutData((Object)data);
            this.launchImportButton = new Button(optArea, 32);
            this.launchImportButton.setText(Messages.ClientWizardPage_LaunchPerforceProjectImportWizard);
            this.launchImportButton.setSelection(true);
        }
    }

    private void loadClients() {
        final String workspace = Messages.ClientWizardPage_Loading.equals(this.workspaceText.getText()) ? null : this.workspaceText.getText();
        this.errorShown = false;
        this.workspaceTable.removeAll();
        TableItem loading = new TableItem(this.workspaceTable, 0);
        loading.setText(Messages.ClientWizardPage_Loading);
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(MessageFormat.format(Messages.ClientWizardPage_FetchingClientsFor, ClientWizardPage.this.getUser()), 4);
                    IClientSummary[] loadedClients = null;
                    IP4Connection connection = ClientWizardPage.this.getWizardConnection();
                    if (connection == null) {
                        connection = ClientWizardPage.this.createConnection(true, true);
                        monitor.worked(1);
                        connection.getParameters().setSavePassword(true);
                        connection.setErrorHandler(ClientWizardPage.this.handler);
                        connection.connect();
                        ClientWizardPage.this.setWizardConnection(connection);
                    }
                    monitor.worked(1);
                    loadedClients = connection.getOwnedClients();
                    monitor.worked(1);
                    ClientWizardPage.this.updateAuthTicket(connection);
                    if (loadedClients == null) {
                        loadedClients = new IClient[]{};
                    }
                    final IClientSummary[] clients = loadedClients;
                    PerforceUIPlugin.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (ClientWizardPage.this.workspaceTable != null && !ClientWizardPage.this.workspaceTable.isDisposed()) {
                                ClientWizardPage.this.workspaceTable.removeAll();
                                Arrays.sort(clients, new Comparator<IClientSummary>(){

                                    @Override
                                    public int compare(IClientSummary o1, IClientSummary o2) {
                                        if (o1 != null && o1.getName() != null && o2 != null && o2.getName() != null) {
                                            return o1.getName().compareTo(o2.getName());
                                        }
                                        return 0;
                                    }
                                });
                                ArrayList<String> clientProposals = new ArrayList<String>();
                                String hostname = ClientWizardPage.this.getHostname();
                                IClientSummary[] iClientSummaryArray = clients;
                                int n = clients.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IClientSummary spec = iClientSummaryArray[n2];
                                    if (!ClientWizardPage.this.hostOnlyButton.getSelection() || StringUtils.isEmpty((CharSequence)spec.getHostName()) || spec.getHostName().equals(hostname)) {
                                        clientProposals.add(spec.getName());
                                        TableItem item = new TableItem(ClientWizardPage.this.workspaceTable, 0);
                                        item.setText(new String[]{spec.getName(), spec.getRoot(), spec.getStream(), spec.getHostName()});
                                        if (spec.getName().equals(workspace)) {
                                            ClientWizardPage.this.workspaceTable.setSelection(item);
                                        }
                                    }
                                    ++n2;
                                }
                                ClientWizardPage.this.workspaceText.setText("");
                                if (workspace != null) {
                                    ClientWizardPage.this.workspaceText.setText(workspace);
                                }
                                ClientWizardPage.this.provider.setProposals(clientProposals.toArray(new String[0]));
                            }
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            PerforceProviderPlugin.logError((Throwable)e);
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.ClientWizardPage_Error, (String)e.getLocalizedMessage());
        }
    }

    private String getHostname() {
        String hostName = "";
        try {
            hostName = P4Workspace.getP4HOST();
            if (StringUtils.isEmpty((CharSequence)hostName)) {
                hostName = InetAddress.getLocalHost().getHostName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hostName;
    }

    public void validatePage() {
        String message = null;
        if (this.existingWorkspaceButton.getSelection()) {
            this.create = false;
            this.location = null;
            String client = this.workspaceText.getText().trim();
            if (client.length() == 0) {
                message = Messages.ClientWizardPage_MustEnterClientName;
            } else {
                message = Messages.ClientWizardPage_ClientNameInvalid;
                IContentProposal[] matched = this.provider.getProposals(client, client.length());
                if (matched != null && matched.length > 0) {
                    IContentProposal[] iContentProposalArray = matched;
                    int n = matched.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IContentProposal prop = iContentProposalArray[n2];
                        if (client.equals(prop.getContent())) {
                            this.client = client;
                            message = null;
                            break;
                        }
                        ++n2;
                    }
                }
            }
        } else if (this.newWorkspaceButton.getSelection()) {
            this.create = true;
            String client = this.nameText.getText().trim();
            String location = this.locationText.getText().trim();
            if (client.length() == 0) {
                message = Messages.ClientWizardPage_MustEnterClientName;
            } else {
                message = P4UIUtils.validateName(client, Messages.ClientWizardPage_Workspace);
                if (message == null) {
                    this.client = client;
                }
            }
            if (message == null) {
                if (location.length() == 0) {
                    message = Messages.ClientWizardPage_MustEnterValidDirectory;
                } else {
                    this.location = location;
                }
            }
            if (message == null) {
                message = this.validateStream();
            }
        }
        this.setPageComplete(message == null);
        this.setErrorMessage(message);
    }

    private void showClientError(final IP4Connection connection) {
        if (connection != null) {
            PerforceUIPlugin.syncExec(new Runnable(){

                @Override
                public void run() {
                    String client = connection.getParameters().getClientNoNull();
                    P4ConnectionManager.getManager().openError(ClientWizardPage.this.getShell(), Messages.ClientWizardPage_ClientDoesNotExistTitle, NLS.bind((String)Messages.ClientWizardPage_ClientDoesNotExistMessage, (Object)client));
                }
            });
        }
    }

    private void showClientExistsError(final IP4Connection connection) {
        if (connection != null) {
            PerforceUIPlugin.syncExec(new Runnable(){

                @Override
                public void run() {
                    String client = connection.getParameters().getClientNoNull();
                    P4ConnectionManager.getManager().openError(ClientWizardPage.this.getShell(), Messages.ClientWizardPage_ClientExistsTitle, NLS.bind((String)Messages.ClientWizardPage_ClientExistsMessage, (Object)client));
                }
            });
        }
    }

    private boolean validateClient(String client) {
        this.errorShown = false;
        boolean validated = false;
        if (this.isExistingClientSelected()) {
            IP4Connection connection = this.createConnection();
            connection.getParameters().setSavePassword(true);
            connection.setErrorHandler(this.handler);
            validated = connection.refreshClient();
        } else {
            P4BrowsableConnection connection = this.createBrowseConnection();
            connection.getParameters().setSavePassword(true);
            connection.setErrorHandler(this.handler);
            validated = connection.refreshClient();
            if (validated && connection.clientExists()) {
                this.showClientExistsError((IP4Connection)connection);
                validated = false;
            }
        }
        return validated;
    }

    public IWizardPage getNextPage() {
        IWizardPage next = null;
        String client = this.getClient();
        if (client != null && this.validateClient(client)) {
            next = super.getNextPage();
        }
        return next;
    }

    @Override
    public boolean canFlipToNextPage() {
        return this.isPageComplete() && super.getNextPage() != null;
    }

    public void dispose() {
        super.dispose();
        if (this.refreshImage != null) {
            this.refreshImage.dispose();
        }
    }

    public String getLocation() {
        return this.location;
    }

    @Override
    public String getClient() {
        return this.client;
    }

    public void setClient(String client) {
        if (client != null) {
            this.workspaceText.setText(client);
        }
    }

    public boolean isExistingClientSelected() {
        return this.existingWorkspaceButton.getSelection();
    }

    public boolean isNewClientSelected() {
        return this.newWorkspaceButton.getSelection();
    }

    public boolean shouldCreate() {
        return this.create;
    }

    public String getStream() {
        SuggestBox.SelectionModel model = (SuggestBox.SelectionModel)this.streamCombo.getModel().getValue();
        if (model != null && model.getSelection() != null) {
            return ((IStreamSummary)model.getSelection()).getStream();
        }
        return "";
    }

    private String validateStream() {
        SuggestBox.SelectionModel model = (SuggestBox.SelectionModel)this.streamCombo.getModel().getValue();
        if (model != null && model.getSelection() == null && !this.streamCombo.getText().isEmpty()) {
            return MessageFormat.format(Messages.ClientWizardPage_StreamInvalid, this.streamCombo.getText());
        }
        return null;
    }

    public boolean isLaunchImportWizard() {
        return this.launchImportButton.getSelection();
    }
}

