/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.changelists;

import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.core.p4java.IP4Job;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.ui.changelists.ChangelistDetailsWidget;
import com.perforce.team.ui.changelists.ChangelistFileWidget;
import com.perforce.team.ui.changelists.Messages;
import com.perforce.team.ui.jobs.JobsWidget;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class ChangelistWidget {
    private TabFolder changelistFolder;
    private TabItem detailsTab;
    private ChangelistDetailsWidget details;
    private TabItem filesTab;
    private ChangelistFileWidget files;
    private TabItem jobsTab;
    private JobsWidget jobs;
    private Composite displayArea;
    private IP4Changelist input;
    protected boolean enableEdit = false;

    public ChangelistWidget(boolean enableEdit) {
        this.enableEdit = enableEdit;
    }

    public IP4Changelist getInput() {
        return this.input;
    }

    public Composite getControl() {
        return this.displayArea;
    }

    public void loadFiles(IP4Changelist list) {
        if (list != null && this.input == list) {
            this.files.setFiles(list.getFiles());
            this.files.generateCompressedFileTree();
            this.files.generateFileTree();
        }
    }

    public void refreshFiles() {
        this.files.refreshInput();
    }

    public void setInput(IP4Changelist list) {
        this.input = list;
        this.details.setChangelist(list);
        IP4Resource[] resources = new IP4Resource[]{};
        IP4Job[] jobs = new IP4Job[]{};
        String filesTitle = Messages.ChangelistWidget_Files;
        String jobsTitle = Messages.ChangelistWidget_Jobs;
        if (list != null) {
            resources = list.getFiles();
            jobs = list.getJobs();
        }
        if (list == null || list.needsRefresh()) {
            this.files.setFiles(new IP4Resource[0]);
            this.refreshFiles();
        } else {
            this.files.showLoading();
        }
        if (list != null && !list.needsRefresh()) {
            filesTitle = String.valueOf(filesTitle) + " (" + resources.length + ")";
            jobsTitle = String.valueOf(jobsTitle) + " (" + jobs.length + ")";
        }
        this.filesTab.setText(filesTitle);
        if (this.jobs != null) {
            this.jobs.setInput((IP4Resource[])jobs);
        }
        if (this.jobsTab != null) {
            this.jobsTab.setText(jobsTitle);
        }
    }

    public void createControl(Composite parent) {
        this.createControl(parent, null);
    }

    public void createControl(Composite parent, ViewerFilter filter) {
        this.displayArea = new Composite(parent, 0);
        GridLayout daLayout = new GridLayout(1, true);
        daLayout.marginHeight = 0;
        daLayout.marginBottom = 0;
        this.displayArea.setLayout((Layout)daLayout);
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.changelistFolder = new TabFolder(this.displayArea, 128);
        this.changelistFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createDetailsTab();
        this.createFilesTabs(filter);
        this.createJobsTab();
    }

    protected ChangelistFileWidget createFileWidget() {
        return new ChangelistFileWidget();
    }

    protected ChangelistDetailsWidget createDetailsWidget() {
        return new ChangelistDetailsWidget();
    }

    private void createDetailsTab() {
        this.detailsTab = new TabItem(this.changelistFolder, 0);
        this.detailsTab.setText(Messages.ChangelistWidget_Details);
        this.details = this.createDetailsWidget();
        this.details.createControl((Composite)this.changelistFolder);
        this.detailsTab.setControl((Control)this.details.getControl());
    }

    private void createFilesTabs(ViewerFilter filter) {
        this.filesTab = new TabItem(this.changelistFolder, 0);
        this.filesTab.setText(Messages.ChangelistWidget_Files);
        this.files = this.createFileWidget();
        this.files.createControl((Composite)this.changelistFolder, filter);
        this.filesTab.setControl((Control)this.files.getControl());
    }

    protected void createJobsTab() {
        this.jobsTab = new TabItem(this.changelistFolder, 0);
        this.jobsTab.setText(Messages.ChangelistWidget_Jobs);
        this.jobs = new JobsWidget(this.enableEdit);
        this.jobs.createControl((Composite)this.changelistFolder);
        this.jobsTab.setControl((Control)this.jobs.getControl());
    }

    public ChangelistDetailsWidget getDetailsWidget() {
        return this.details;
    }

    public ChangelistFileWidget getFilesWidget() {
        return this.files;
    }

    public JobsWidget getJobsWidget() {
        return this.jobs;
    }
}

