/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.branches;

import com.perforce.team.core.p4java.IP4Branch;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.ui.branches.BranchesViewer;
import com.perforce.team.ui.branches.Messages;
import com.perforce.team.ui.dialogs.PerforceDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class SelectBranchDialog
extends PerforceDialog {
    private IP4Branch selected = null;
    private IP4Connection connection;
    private BranchesViewer branchesViewer;

    public SelectBranchDialog(Shell parent, IP4Connection connection) {
        super(parent, Messages.SelectBranchDialog_DialogTitle);
        this.setModalResizeStyle();
        this.connection = connection;
    }

    public IP4Branch getSelected() {
        return this.selected;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        this.branchesViewer = new BranchesViewer();
        this.branchesViewer.createControl(c, this.connection, false, false);
        this.branchesViewer.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SelectBranchDialog.this.updateSelection();
                SelectBranchDialog.this.close();
            }
        });
        return c;
    }

    private void updateSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.branchesViewer.getViewer().getSelection();
        if (selection.getFirstElement() instanceof IP4Branch) {
            this.selected = (IP4Branch)selection.getFirstElement();
        }
    }

    protected void okPressed() {
        this.updateSelection();
        super.okPressed();
    }
}

