/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.branches;

import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.p4java.IP4Branch;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.branches.BranchSorter;
import com.perforce.team.ui.branches.BranchWidget;
import com.perforce.team.ui.branches.Messages;
import com.perforce.team.ui.dialogs.DialogUtils;
import com.perforce.team.ui.dialogs.FixedWidthScrolledComposite;
import com.perforce.team.ui.viewer.FilterViewer;
import com.perforce.team.ui.views.PerforceProjectView;
import com.perforce.team.ui.views.SessionManager;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.progress.UIJob;

public class BranchesViewer
extends FilterViewer
implements ISelectionChangedListener,
IPropertyChangeListener {
    public static final String OWNER_HISTORY = "com.perforce.team.ui.branches.OWNER_HISTORY";
    public static final String NAME_HISTORY = "com.perforce.team.ui.branches.NAME_HISTORY";
    public static final String BRANCH_COLUMN = Messages.BranchesViewer_Branch;
    public static final String DESCRIPTION_COLUMN = Messages.BranchesViewer_Description;
    public static final String ACCESS_COLUMN = Messages.BranchesViewer_AccessTime;
    public static final String UPDATE_COLUMN = Messages.BranchesViewer_UpdateTime;
    public static final String OWNER_COLUMN = Messages.BranchesViewer_Owner;
    public static final String ELLIPSIS = "...";
    private BranchSorter sorter;
    private TableViewer branchesList;
    private IP4Connection connection;
    private IP4Branch[] branches;
    private Composite viewComposite;
    private Link showMore;
    private Label ownerLabel;
    private Combo ownerCombo;
    private ToolBar ownerBar;
    private ToolItem ownerClearItem;
    private Label nameLabel;
    private Combo nameCombo;
    private ToolBar nameBar;
    private ToolItem nameClearItem;
    private SashForm sash;
    private ScrolledComposite detailPanel;
    private BranchWidget branchView;
    private int retrieveCount = 0;
    private boolean isLoading = false;
    private boolean autoSelectFirstEntry = false;
    private IP4Branch selectedBranch = null;
    private Object loading = new Object();
    private Image loadingImage;
    private Image clearImage;
    public static final String COLUMN_SIZES = "com.perforce.team.ui.branchcolumns";

    public void addBranch(IP4Branch branch) {
        if (branch != null) {
            if (this.branches != null) {
                IP4Branch[] newJobs = new IP4Branch[this.branches.length + 1];
                newJobs[0] = branch;
                System.arraycopy(this.branches, 0, newJobs, 1, this.branches.length);
                this.branches = newJobs;
            } else {
                this.branches = new IP4Branch[]{branch};
            }
            this.branchesList.insert((Object)branch, 0);
            this.branchesList.setSelection((ISelection)new StructuredSelection((Object)branch), true);
        }
    }

    public void showMore() {
        if (this.retrieveCount != -1) {
            this.retrieveCount += this.getMaxBranches();
        }
        this.loadBranches();
    }

    private void createMoreLink(Composite parent) {
        this.showMore = new Link(parent, 8);
        this.showMore.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BranchesViewer.this.showMore();
            }
        });
        this.showMore.setLayoutData((Object)new GridData(0x1000008, 4, true, false));
        this.refreshRetrieveCount();
        this.updateMoreButton(false);
        if (this.connection.getIntVersion() < 20061) {
            this.showMore.setVisible(false);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("com.perforce.team.ui.preferences.NUM_BRANCHES_RETRIEVE".equals(property)) {
            this.retrieveCount = this.getMaxBranches();
            this.updateMoreButton();
            this.loadBranches();
        }
    }

    public Composite createControl(Composite parent, IP4Connection con, boolean multiSelect, boolean displayDetails) {
        this.connection = con;
        if (this.sash != null && !this.sash.isDisposed()) {
            this.sash.dispose();
        }
        PerforceUIPlugin.getPlugin().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.sash = DialogUtils.createSash(parent);
        this.viewComposite = new Composite((Composite)this.sash, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        this.viewComposite.setLayout((Layout)gl);
        this.createFilterArea(this.viewComposite);
        this.createMoreLink(this.viewComposite);
        Table table = this.createTable(this.viewComposite, multiSelect);
        this.detailPanel = this.createDetailPanel((Composite)this.sash, table.getBackground());
        this.branchesList.addSelectionChangedListener((ISelectionChangedListener)this);
        this.updateSash(displayDetails);
        this.loadBranches();
        return this.sash;
    }

    private void updateMoreButton(boolean layout) {
        if (this.showMore != null && !this.showMore.isDisposed()) {
            int max = this.getMaxBranches();
            if (max == -1) {
                this.showMore.setText(Messages.BranchesViewer_ShowMore);
                this.showMore.setEnabled(false);
            } else {
                this.showMore.setText(NLS.bind((String)Messages.BranchesViewer_ShowMaxMore, (Object)max));
                this.showMore.setEnabled(true);
            }
            if (layout) {
                this.showMore.getParent().layout(new Control[]{this.showMore});
            }
        }
    }

    private void updateMoreButton() {
        this.updateMoreButton(true);
    }

    private void createFilterArea(Composite parent) {
        String[] names;
        String[] keywords;
        this.filterComposite = new Composite(parent, 0);
        GridLayout fcLayout = new GridLayout(6, false);
        this.filterComposite.setLayout((Layout)fcLayout);
        this.filterComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        final SelectionListener comboAdapter = P4UIUtils.createComboSelectionListener(new Runnable(){

            @Override
            public void run() {
                BranchesViewer.this.loadBranches();
            }
        });
        this.clearImage = PerforceUIPlugin.getPlugin().getImageDescriptor("normal/clear.png").createImage();
        this.ownerLabel = new Label(this.filterComposite, 16384);
        this.ownerLabel.setText(Messages.BranchesViewer_OwnerLabel);
        this.ownerLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.ownerCombo = new Combo(this.filterComposite, 4);
        String[] stringArray = keywords = PerforceProjectView.getItems(OWNER_HISTORY);
        int n = keywords.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            this.ownerCombo.add(keyword);
            ++n2;
        }
        this.ownerCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.ownerCombo.addSelectionListener(comboAdapter);
        this.ownerCombo.setText(this.connection.getParameters().getUserNoNull());
        this.ownerBar = new ToolBar(this.filterComposite, 0x800000);
        this.ownerClearItem = new ToolItem(this.ownerBar, 8);
        this.ownerClearItem.setToolTipText(Messages.BranchesViewer_ClearOwnerFilter);
        this.ownerClearItem.setImage(this.clearImage);
        this.ownerClearItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BranchesViewer.this.ownerCombo.setText("");
                comboAdapter.widgetSelected(null);
            }
        });
        this.nameLabel = new Label(this.filterComposite, 16384);
        this.nameLabel.setText(Messages.BranchesViewer_NameContains);
        this.nameLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.nameCombo = new Combo(this.filterComposite, 4);
        String[] stringArray2 = names = PerforceProjectView.getItems(NAME_HISTORY);
        int n3 = names.length;
        n = 0;
        while (n < n3) {
            String name = stringArray2[n];
            this.nameCombo.add(name);
            ++n;
        }
        this.nameCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.nameCombo.addSelectionListener(comboAdapter);
        this.nameBar = new ToolBar(this.filterComposite, 0x800000);
        this.nameClearItem = new ToolItem(this.nameBar, 8);
        this.nameClearItem.setToolTipText(Messages.BranchesViewer_ClearNameFilter);
        this.nameClearItem.setImage(this.clearImage);
        this.nameClearItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BranchesViewer.this.nameCombo.setText("");
                comboAdapter.widgetSelected(null);
            }
        });
        if (this.connection.getIntVersion() < 20081) {
            this.nameLabel.setVisible(false);
            this.nameCombo.setVisible(false);
            this.nameBar.setVisible(false);
        }
    }

    private IP4Branch getSelectedBranch(ISelection selection) {
        if (selection == null || !(selection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection ss = (IStructuredSelection)selection;
        if (ss.size() != 1) {
            return null;
        }
        if (ss.getFirstElement() instanceof IP4Branch) {
            return (IP4Branch)ss.getFirstElement();
        }
        return null;
    }

    public IP4Branch[] getSelectedBranches() {
        ISelection selected = this.branchesList.getSelection();
        ArrayList<IP4Branch> selectedBranches = new ArrayList<IP4Branch>();
        if (selected instanceof IStructuredSelection) {
            Object[] selectedItem = ((IStructuredSelection)selected).toArray();
            int i = 0;
            while (i < selectedItem.length) {
                if (selectedItem[i] instanceof IP4Branch) {
                    selectedBranches.add((IP4Branch)selectedItem[i]);
                }
                ++i;
            }
        }
        return selectedBranches.toArray(new IP4Branch[selectedBranches.size()]);
    }

    public Table getTableControl() {
        if (this.branchesList != null) {
            return this.branchesList.getTable();
        }
        return null;
    }

    public TableViewer getViewer() {
        return this.branchesList;
    }

    private Map<String, Integer> loadColumnSizes() {
        return SessionManager.loadColumnSizes(COLUMN_SIZES);
    }

    private void saveColumnSizes() {
        SessionManager.saveColumnPreferences(this.branchesList.getTable(), COLUMN_SIZES);
    }

    private Table createTable(Composite parent, boolean multiSelect) {
        int flags = 68352;
        if (multiSelect) {
            flags |= 2;
        }
        Table table = new Table(parent, flags);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                BranchesViewer.this.saveColumnSizes();
                PerforceUIPlugin.getPlugin().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)BranchesViewer.this);
            }
        });
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        table.setLayoutData((Object)gd);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        SelectionAdapter headerListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableColumn column = (TableColumn)e.widget;
                BranchesViewer.this.sorter.setSortColumn(column.getText());
                BranchesViewer.this.branchesList.refresh();
            }
        };
        this.branchesList = new TableViewer(table);
        this.branchesList.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement == BranchesViewer.this.loading) {
                    return new Object[]{BranchesViewer.this.loading};
                }
                if (BranchesViewer.this.branches != null) {
                    return BranchesViewer.this.branches;
                }
                return new Object[0];
            }
        });
        this.branchesList.setLabelProvider((IBaseLabelProvider)new BranchesLabelProvider());
        TableColumn branchColumn = this.addColumn(this.branchesList.getTable(), BRANCH_COLUMN);
        this.addColumn(this.branchesList.getTable(), OWNER_COLUMN);
        this.addColumn(this.branchesList.getTable(), ACCESS_COLUMN);
        this.addColumn(this.branchesList.getTable(), UPDATE_COLUMN);
        this.addColumn(this.branchesList.getTable(), DESCRIPTION_COLUMN);
        TableColumn[] tableColumnArray = this.branchesList.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.addSelectionListener((SelectionListener)headerListener);
            ++n2;
        }
        table.setSortColumn(branchColumn);
        table.setSortDirection(128);
        Map<String, Integer> columnSizes = this.loadColumnSizes();
        TableColumn[] tableColumnArray2 = this.branchesList.getTable().getColumns();
        int n3 = tableColumnArray2.length;
        n = 0;
        while (n < n3) {
            int size;
            TableColumn column = tableColumnArray2[n];
            int width = 100;
            if (columnSizes.containsKey(column.getText()) && (size = columnSizes.get(column.getText()).intValue()) > 0) {
                width = size;
            }
            layout.addColumnData((ColumnLayoutData)new ColumnPixelData(width, true));
            ++n;
        }
        this.sorter = new BranchSorter(this.branchesList.getTable(), branchColumn.getText());
        this.sorter.setAscending();
        this.branchesList.setSorter((ViewerSorter)this.sorter);
        return table;
    }

    private TableColumn addColumn(Table table, String title) {
        TableColumn col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(title);
        return col;
    }

    public void refresh() {
        if (this.connection != null) {
            this.refreshRetrieveCount();
            this.loadBranches();
        }
    }

    private IPreferenceStore getPreferenceStore() {
        return PerforceUIPlugin.getPlugin().getPreferenceStore();
    }

    private int getMaxBranches() {
        return this.getPreferenceStore().getInt("com.perforce.team.ui.preferences.NUM_BRANCHES_RETRIEVE");
    }

    private void updateDetailsPanel(final IP4Branch branch) {
        this.branchView.clear();
        if (branch != null && branch.needsRefresh()) {
            final String name = branch.getName();
            P4Runner.schedule((IP4Runnable)new P4Runnable(){

                public void run(IProgressMonitor monitor) {
                    branch.refresh();
                    if (!branch.needsRefresh()) {
                        UIJob job = new UIJob(NLS.bind((String)Messages.BranchesViewer_UpdatingBranch, (Object)name)){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                if (BranchesViewer.this.okToUse() && branch == BranchesViewer.this.selectedBranch) {
                                    BranchesViewer.this.updateDetailsPanel(branch);
                                }
                                return Status.OK_STATUS;
                            }
                        };
                        job.schedule();
                    }
                }

                public String getTitle() {
                    return NLS.bind((String)Messages.BranchesViewer_LoadingBranch, (Object)name);
                }
            });
        } else {
            this.branchView.update(branch);
            this.updateScrollPanel();
        }
    }

    public void refreshDetails(IP4Branch branch) {
        if (branch != null && branch.equals(this.selectedBranch)) {
            this.branchView.update(branch);
            this.updateScrollPanel();
        }
    }

    private void clearDetailsPanel() {
        this.branchView.clear();
        this.updateScrollPanel();
    }

    private void updateScrollPanel() {
        this.detailPanel.setMinSize(this.branchView.getControl().computeSize(-1, -1, true));
    }

    private ScrolledComposite createDetailPanel(Composite parent, Color background) {
        FixedWidthScrolledComposite panel = new FixedWidthScrolledComposite(parent, 2560);
        panel.setLayout((Layout)new FillLayout());
        this.branchView = new BranchWidget((Composite)panel, 10, 10, false);
        panel.setContent((Control)this.branchView.getControl());
        panel.setExpandHorizontal(true);
        panel.setExpandVertical(true);
        panel.setMinSize(this.branchView.getControl().computeSize(-1, -1));
        return panel;
    }

    public void updateSash(boolean displayDetails) {
        if (displayDetails) {
            this.sash.setMaximizedControl(null);
            IP4Branch branch = this.getSelectedBranch(this.branchesList.getSelection());
            if (branch == null) {
                this.clearDetailsPanel();
            } else {
                this.updateDetailsPanel(branch);
            }
        } else {
            this.sash.setMaximizedControl((Control)this.viewComposite);
        }
    }

    private void enableFilters(boolean enabled) {
        this.ownerCombo.setEnabled(enabled);
        this.nameCombo.setEnabled(enabled);
    }

    private boolean checkFilter(String user) {
        if (user == null) {
            user = "";
        }
        return user.equals(this.ownerCombo.getText().trim());
    }

    private void updateHistory(String owner, String name) {
        if (owner != null && owner.length() > 0) {
            SessionManager.saveComboHistory(this.ownerCombo, 10, OWNER_HISTORY);
        }
        if (name != null && name.length() > 0) {
            SessionManager.saveComboHistory(this.nameCombo, 10, NAME_HISTORY);
        }
    }

    public boolean okToUse() {
        return this.branchesList != null && this.branchesList.getTable() != null && !this.branchesList.getTable().isDisposed();
    }

    private String convertNameContains(String entered) {
        String converted = entered;
        if (converted.length() > 0 && (converted = converted.replace("*", ELLIPSIS)).indexOf(ELLIPSIS) == -1) {
            converted = ELLIPSIS + converted + ELLIPSIS;
        }
        return converted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBranches() {
        String nameContains;
        this.isLoading = true;
        if (this.viewComposite == null || this.viewComposite.isDisposed()) {
            return;
        }
        this.clearDetailsPanel();
        final Object newLoading = new Object();
        BranchesViewer branchesViewer = this;
        synchronized (branchesViewer) {
            this.loading = newLoading;
            this.branchesList.setInput(this.loading);
        }
        String owner = this.ownerCombo.getText().trim();
        if (owner.length() == 0) {
            owner = null;
        }
        if ((nameContains = this.convertNameContains(this.nameCombo.getText().trim())).length() == 0) {
            nameContains = null;
        }
        final String finalOwner = owner;
        final String finalNameContains = nameContains;
        this.enableFilters(false);
        this.updateHistory(owner, nameContains);
        P4Runner.schedule((IP4Runnable)new P4Runnable(){

            public String getTitle() {
                return Messages.BranchesViewer_LoadingBranches;
            }

            public void run(IProgressMonitor monitor) {
                IP4Connection branchConnection = BranchesViewer.this.connection;
                if (branchConnection == null) {
                    BranchesViewer.this.isLoading = false;
                    return;
                }
                final IP4Branch[] newBranches = branchConnection.getBranches(finalOwner, BranchesViewer.this.retrieveCount, finalNameContains);
                if (newLoading == BranchesViewer.this.loading) {
                    UIJob job = new UIJob(Messages.BranchesViewer_UpdatingBranchesView){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (BranchesViewer.this.okToUse() && newLoading == BranchesViewer.this.loading && BranchesViewer.this.checkFilter(finalOwner)) {
                                BranchesViewer.this.branches = newBranches;
                                BranchesViewer.this.branchesList.setInput((Object)BranchesViewer.this.branches);
                                if (BranchesViewer.this.autoSelectFirstEntry && newBranches.length > 0) {
                                    BranchesViewer.this.branchesList.setSelection((ISelection)new StructuredSelection((Object)newBranches[0]));
                                }
                                BranchesViewer.this.enableFilters(true);
                                BranchesViewer.this.isLoading = false;
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                }
            }
        });
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.branchesList == null || this.branchesList.getTable().isDisposed()) {
            return;
        }
        IP4Branch branch = this.getSelectedBranch(event.getSelection());
        if (branch != null) {
            this.selectedBranch = branch;
            this.updateDetailsPanel(branch);
        }
    }

    public boolean isLoading() {
        return this.isLoading;
    }

    public void refreshRetrieveCount() {
        this.retrieveCount = this.getMaxBranches();
    }

    public void setAutoSelectFirstEntry(boolean autoSelectFirstEntry) {
        this.autoSelectFirstEntry = autoSelectFirstEntry;
    }

    public BranchWidget getDetails() {
        return this.branchView;
    }

    private class BranchesLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private Image branchImage = null;

        private BranchesLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element == BranchesViewer.this.loading) {
                    if (BranchesViewer.this.loadingImage == null) {
                        BranchesViewer.this.loadingImage = this.getLoadingImage();
                    }
                    return BranchesViewer.this.loadingImage;
                }
                if (this.branchImage == null) {
                    this.branchImage = this.createBranchImage();
                }
                return this.branchImage;
            }
            return null;
        }

        public void dispose() {
            if (this.branchImage != null && !this.branchImage.isDisposed()) {
                this.branchImage.dispose();
                this.branchImage = null;
            }
            if (BranchesViewer.this.loadingImage != null && !BranchesViewer.this.loadingImage.isDisposed()) {
                BranchesViewer.this.loadingImage.dispose();
                BranchesViewer.this.loadingImage = null;
            }
            if (BranchesViewer.this.clearImage != null && !BranchesViewer.this.clearImage.isDisposed()) {
                BranchesViewer.this.clearImage.dispose();
                BranchesViewer.this.clearImage = null;
            }
        }

        private Image getLoadingImage() {
            PerforceUIPlugin plugin = PerforceUIPlugin.getPlugin();
            return plugin.getImageDescriptor("perforce/hourglass.png").createImage();
        }

        private Image createBranchImage() {
            PerforceUIPlugin plugin = PerforceUIPlugin.getPlugin();
            return plugin.getImageDescriptor("normal/branch.png").createImage();
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element == BranchesViewer.this.loading && columnIndex == 0) {
                return Messages.BranchesViewer_Loading;
            }
            if (element instanceof IP4Branch) {
                String value = null;
                IP4Branch branch = (IP4Branch)element;
                switch (columnIndex) {
                    case 0: {
                        value = branch.getName();
                        break;
                    }
                    case 1: {
                        value = branch.getOwner();
                        break;
                    }
                    case 2: {
                        value = P4UIUtils.formatLabelDate(branch.getAccessTime());
                        break;
                    }
                    case 3: {
                        value = P4UIUtils.formatLabelDate(branch.getUpdateTime());
                        break;
                    }
                    case 4: {
                        value = branch.getDescription();
                        break;
                    }
                }
                if (value != null) {
                    return P4CoreUtils.removeWhitespace((String)value);
                }
            }
            return "";
        }
    }
}

