/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class SWTUtils {
    public static final String KEY_DECORATOR = "Control.decoration";
    public static final FieldDecoration INFO_INDICATOR = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION");
    public static final FieldDecoration ERROR_INDICATOR = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
    public static final FieldDecoration WARNING_INDICATOR = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING");
    public static final int MARGINS_DEFAULT = -1;
    public static final int MARGINS_NONE = 0;
    public static final int MARGINS_DIALOG = 1;

    public static PreferenceLinkArea createPreferenceLink(IWorkbenchPreferenceContainer container, Composite parent, String pageId, String text) {
        PreferenceLinkArea area = new PreferenceLinkArea(parent, 0, pageId, text, container, null);
        return area;
    }

    public static GridData createGridData(int width, int height, boolean hFill, boolean vFill) {
        return SWTUtils.createGridData(width, height, hFill ? 4 : 1, vFill ? 4 : 0x1000000, hFill, vFill);
    }

    public static GridData createGridData(int width, int height, int hAlign, int vAlign, boolean hGrab, boolean vGrab) {
        GridData gd = new GridData(hAlign, vAlign, hGrab, vGrab);
        gd.widthHint = width;
        gd.heightHint = height;
        return gd;
    }

    public static GridData createHFillGridData() {
        return SWTUtils.createHFillGridData(1);
    }

    public static GridData createHFillGridData(int span) {
        GridData gd = SWTUtils.createGridData(0, -1, 4, 0x1000000, true, false);
        gd.horizontalSpan = span;
        return gd;
    }

    public static Composite createHFillComposite(Composite parent, int margins) {
        return SWTUtils.createHFillComposite(parent, margins, 1);
    }

    public static Composite createHFillComposite(Composite parent, int margins, int columns) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayoutData((Object)SWTUtils.createHFillGridData());
        composite.setLayout((Layout)SWTUtils.createGridLayout(columns, new PixelConverter((Control)parent), margins));
        return composite;
    }

    public static Composite createHVFillComposite(Composite parent, int margins) {
        return SWTUtils.createHVFillComposite(parent, margins, 1);
    }

    public static Composite createHVFillComposite(Composite parent, int margins, int columns) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayoutData((Object)SWTUtils.createHVFillGridData());
        composite.setLayout((Layout)SWTUtils.createGridLayout(columns, new PixelConverter((Control)parent), margins));
        return composite;
    }

    public static Group createHFillGroup(Composite parent, String text, int margins) {
        return SWTUtils.createHFillGroup(parent, text, margins, 1);
    }

    public static Group createHFillGroup(Composite parent, String text, int margins, int rows) {
        Group group = new Group(parent, 0);
        group.setFont(parent.getFont());
        group.setLayoutData((Object)SWTUtils.createHFillGridData());
        if (text != null) {
            group.setText(text);
        }
        group.setLayout((Layout)SWTUtils.createGridLayout(rows, new PixelConverter((Control)parent), margins));
        return group;
    }

    public static Group createHVFillGroup(Composite parent, String text, int margins) {
        return SWTUtils.createHVFillGroup(parent, text, margins, 1);
    }

    public static Group createHVFillGroup(Composite parent, String text, int margins, int rows) {
        Group group = new Group(parent, 0);
        group.setFont(parent.getFont());
        group.setLayoutData((Object)SWTUtils.createHVFillGridData());
        if (text != null) {
            group.setText(text);
        }
        group.setLayout((Layout)SWTUtils.createGridLayout(rows, new PixelConverter((Control)parent), margins));
        return group;
    }

    public static GridData createHVFillGridData() {
        return SWTUtils.createHVFillGridData(1);
    }

    public static GridData createHVFillGridData(int span) {
        GridData gd = SWTUtils.createGridData(0, 0, true, true);
        gd.horizontalSpan = span;
        return gd;
    }

    public static GridLayout createGridLayout(int numColumns, PixelConverter converter, int margins) {
        Assert.isTrue((margins == -1 || margins == 0 || margins == 1 ? 1 : 0) != 0);
        GridLayout layout = new GridLayout(numColumns, false);
        layout.horizontalSpacing = converter.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = converter.convertVerticalDLUsToPixels(4);
        switch (margins) {
            case 0: {
                layout.marginRight = 0;
                layout.marginLeft = 0;
                layout.marginBottom = 0;
                layout.marginTop = 0;
                break;
            }
            case 1: {
                layout.marginLeft = layout.marginRight = converter.convertHorizontalDLUsToPixels(7);
                layout.marginTop = layout.marginBottom = converter.convertVerticalDLUsToPixels(7);
                break;
            }
            case -1: {
                layout.marginLeft = layout.marginRight = layout.marginWidth;
                layout.marginTop = layout.marginBottom = layout.marginHeight;
            }
        }
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        return layout;
    }

    public static Label createLabel(Composite parent, String message) {
        return SWTUtils.createLabel(parent, message, 1);
    }

    public static Label createLabel(Composite parent, String message, int span) {
        Label label = new Label(parent, 64);
        if (message != null) {
            label.setText(message);
        }
        GridDataFactory.swtDefaults().align(1, 0x1000000).span(span, 1).applyTo((Control)label);
        return label;
    }

    public static Button createButton(Composite parent, String message, int style, int span) {
        Button button = new Button(parent, style);
        button.setText(message);
        GridData gd = SWTUtils.createGridData(-1, -1, 4, 128, false, false);
        gd.horizontalSpan = span;
        button.setLayoutData((Object)gd);
        return button;
    }

    public static Button createCheckBox(Composite parent, String message) {
        return SWTUtils.createCheckBox(parent, message, 1);
    }

    public static Button createCheckBox(Composite parent, String message, int span) {
        Button button = new Button(parent, 32);
        button.setText(message);
        button.setLayoutData((Object)SWTUtils.createHFillGridData(span));
        return button;
    }

    public static Button createRadioButton(Composite parent, String message) {
        return SWTUtils.createRadioButton(parent, message, 1);
    }

    public static Button createRadioButton(Composite parent, String message, int span) {
        Button button = new Button(parent, 16);
        button.setText(message);
        button.setLayoutData((Object)SWTUtils.createHFillGridData(span));
        return button;
    }

    public static Text createText(Composite parent) {
        return SWTUtils.createText(parent, 1);
    }

    public static Text createText(Composite parent, int span, int style) {
        Text text = new Text(parent, style);
        text.setLayoutData((Object)SWTUtils.createHFillGridData(span));
        return text;
    }

    public static Text createText(Composite parent, int span) {
        return SWTUtils.createText(parent, span, 2052);
    }

    public static Text createTextArea(Composite parent, int hspan, int vspan, int heightInChars) {
        return SWTUtils.createTextArea(parent, hspan, vspan, heightInChars, 2818);
    }

    public static Text createTextArea(Composite parent, int hspan, int vspan, int heightInChars, int style) {
        Text text = new Text(parent, style);
        GridData gd = SWTUtils.createGridData(0, 0, 4, 4, true, true);
        gd.horizontalSpan = hspan;
        gd.verticalSpan = vspan;
        gd.minimumHeight = new PixelConverter((Control)parent).convertHeightInCharsToPixels(heightInChars);
        text.setLayoutData((Object)gd);
        return text;
    }

    public static Control createPlaceholder(Composite parent, int heightInChars, int span) {
        Assert.isTrue((heightInChars > 0 ? 1 : 0) != 0);
        Composite placeHolder = new Composite(parent, 0);
        GridData gd = new GridData(1, 128, false, false);
        gd.heightHint = new PixelConverter((Control)parent).convertHeightInCharsToPixels(heightInChars);
        gd.horizontalSpan = span;
        placeHolder.setLayoutData((Object)gd);
        return placeHolder;
    }

    public static Control createPlaceholder(Composite parent, int heightInChars) {
        return SWTUtils.createPlaceholder(parent, heightInChars, 1);
    }

    public static PixelConverter createDialogPixelConverter(Control control) {
        Dialog.applyDialogFont((Control)control);
        return new PixelConverter(control);
    }

    public static int calculateControlSize(PixelConverter converter, Control[] controls) {
        return SWTUtils.calculateControlSize(converter, controls, 0, controls.length - 1);
    }

    public static int calculateControlSize(PixelConverter converter, Control[] controls, int start, int end) {
        int minimum = converter.convertHorizontalDLUsToPixels(61);
        int i = start;
        while (i <= end) {
            int length = controls[i].computeSize((int)-1, (int)-1).x;
            if (minimum < length) {
                minimum = length;
            }
            ++i;
        }
        return minimum;
    }

    public static void equalizeControls(PixelConverter converter, Control[] controls) {
        SWTUtils.equalizeControls(converter, controls, 0, controls.length - 1);
    }

    public static void equalizeControls(PixelConverter converter, Control[] controls, int start, int end) {
        int size = SWTUtils.calculateControlSize(converter, controls, start, end);
        int i = start;
        while (i <= end) {
            Control button = controls[i];
            if (button.getLayoutData() instanceof GridData) {
                ((GridData)button.getLayoutData()).widthHint = size;
            }
            ++i;
        }
    }

    public static int getWidthInCharsForLongest(PixelConverter converter, String[] strings) {
        int minimum = 0;
        int i = 0;
        while (i < strings.length) {
            int length = converter.convertWidthInCharsToPixels(strings[i].length());
            if (minimum < length) {
                minimum = length;
            }
            ++i;
        }
        return minimum;
    }

    public static Image getDecoratedImage(final Image image, final ImageDescriptor overlay) {
        CompositeImageDescriptor cd = new CompositeImageDescriptor(){

            protected Point getSize() {
                Rectangle bounds = image.getBounds();
                return new Point(bounds.width, bounds.height);
            }

            protected void drawCompositeImage(int width, int height) {
                this.drawImage(image.getImageData(), 0, 0);
                this.drawImage(overlay.getImageData(), 0, 0);
            }
        };
        Image decoratedImage = cd.createImage();
        return decoratedImage;
    }

    public static Control decorate(Control control, int position) {
        ControlDecoration decoration = new ControlDecoration(control, position);
        decoration.setShowHover(true);
        decoration.setMarginWidth(2);
        control.setData(KEY_DECORATOR, (Object)decoration);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Object dec = e.widget.getData(SWTUtils.KEY_DECORATOR);
                if (dec instanceof ControlDecoration) {
                    ((ControlDecoration)dec).dispose();
                }
            }
        });
        return control;
    }

    private static ControlDecoration getDecoration(Control control) {
        return (ControlDecoration)control.getData(KEY_DECORATOR);
    }

    public static boolean isDisposed(Control control) {
        if (control == null || control.isDisposed()) {
            return true;
        }
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (SWTUtils.isDisposed(child)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static boolean updateDecoration(Control control, IStatus status) {
        if (SWTUtils.isDisposed(control)) {
            return false;
        }
        ControlDecoration dec = SWTUtils.getDecoration(control);
        if (dec == null) {
            return false;
        }
        dec.setDescriptionText(status.getMessage());
        SWTUtils.adjustLayout(control, status);
        switch (status.getSeverity()) {
            case 0: {
                dec.hide();
                return true;
            }
            case 1: {
                dec.setImage(INFO_INDICATOR.getImage());
                break;
            }
            case 2: {
                dec.setImage(WARNING_INDICATOR.getImage());
                break;
            }
            case 4: {
                dec.setImage(ERROR_INDICATOR.getImage());
            }
        }
        dec.show();
        return true;
    }

    public static boolean adjustLayout(Control control, IStatus status) {
        if (control == null) {
            return false;
        }
        ControlDecoration dec = SWTUtils.getDecoration(control);
        if (dec == null) {
            return false;
        }
        Object layoutData = control.getLayoutData();
        if (layoutData instanceof GridData) {
            int indent;
            ((GridData)layoutData).horizontalIndent = indent = FieldDecorationRegistry.getDefault().getMaximumDecorationWidth() + 2;
            if (control.getParent() != null) {
                control.getParent().layout(new Control[]{control});
                return true;
            }
        }
        return false;
    }

    public static void addContentListener(Control[] controls, Runnable runnable) {
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            SWTUtils.addContentListener(control, runnable);
            ++n2;
        }
    }

    public static void addContentListener(Control control, final Runnable runnable) {
        if (control instanceof Button || control instanceof Combo || control instanceof CCombo || control instanceof Spinner) {
            control.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    runnable.run();
                }
            });
        } else if (control instanceof Text || control instanceof Spinner && !SWTUtils.isReadonlyStyle(control) || control instanceof Combo && !SWTUtils.isReadonlyStyle(control) || control instanceof CCombo && !SWTUtils.isReadonlyStyle(control)) {
            control.addListener(24, new Listener(){

                public void handleEvent(Event event) {
                    runnable.run();
                }
            });
        } else if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                SWTUtils.addContentListener(c, runnable);
                ++n2;
            }
        }
    }

    public static boolean isReadonlyStyle(Control control) {
        return SWTUtils.isReadonlyStyle(control.getStyle());
    }

    public static boolean isReadonlyStyle(int style) {
        return (style & 8) != 0;
    }

    public static Object getSingleSelectedObject(Viewer viewer) {
        ISelection selection = viewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            return ((IStructuredSelection)selection).getFirstElement();
        }
        return null;
    }

    public static <T> ComboViewer createEnumCombo(Composite parent, Class<T> enm) {
        T[] input = enm.getEnumConstants();
        ComboViewer viewer = new ComboViewer(parent);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setInput(input);
        GridDataFactory.fillDefaults().grab(false, false).applyTo(viewer.getControl());
        return viewer;
    }

    public static void select(StructuredViewer viewer, Object obj) {
        viewer.setSelection((ISelection)new StructuredSelection(obj));
    }

    public static Point getScreenLocation(Composite cmpTarget) {
        Point ptScreen = new Point(0, 0);
        try {
            Composite cTmp = cmpTarget;
            while (!(cTmp instanceof Shell)) {
                ptScreen.x += cTmp.getLocation().x;
                ptScreen.y += cTmp.getLocation().y;
                cTmp = cTmp.getParent();
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)cmpTarget.getShell(), (String)"Error", (String)e.getLocalizedMessage());
        }
        return cmpTarget.getShell().toDisplay(ptScreen);
    }

    public static void centerOnScreen(Shell shell) {
        if (Display.getCurrent().getActiveShell() == null) {
            SWTUtils.centerOnMonitor(Display.getCurrent().getPrimaryMonitor(), shell);
        } else {
            SWTUtils.centerOnMonitor(Display.getCurrent().getActiveShell().getMonitor(), shell);
        }
    }

    public static void centerOnMonitor(Monitor monitor, Shell shell) {
        Rectangle clientArea = monitor.getClientArea();
        shell.setLocation(clientArea.x + clientArea.width / 2 - shell.getSize().x / 2, clientArea.y + clientArea.height / 2 - shell.getSize().y / 2);
    }

    private static class PixelConverter {
        private final FontMetrics fFontMetrics;

        public PixelConverter(Control control) {
            GC gc = new GC((Drawable)control);
            try {
                gc.setFont(control.getFont());
                this.fFontMetrics = gc.getFontMetrics();
            }
            finally {
                gc.dispose();
            }
        }

        public int convertHeightInCharsToPixels(int chars) {
            return Dialog.convertHeightInCharsToPixels((FontMetrics)this.fFontMetrics, (int)chars);
        }

        public int convertHorizontalDLUsToPixels(int dlus) {
            return Dialog.convertHorizontalDLUsToPixels((FontMetrics)this.fFontMetrics, (int)dlus);
        }

        public int convertVerticalDLUsToPixels(int dlus) {
            return Dialog.convertVerticalDLUsToPixels((FontMetrics)this.fFontMetrics, (int)dlus);
        }

        public int convertWidthInCharsToPixels(int chars) {
            return Dialog.convertWidthInCharsToPixels((FontMetrics)this.fFontMetrics, (int)chars);
        }
    }
}

