/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.file.FileAction;
import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.team.core.ConnectionParameters;
import com.perforce.team.core.IProjectSettingsChangeListener;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.PerforceTeamProvider;
import com.perforce.team.core.Tracing;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.builder.P4FileSpecBuilder;
import com.perforce.team.ui.IgnoredFiles;
import com.perforce.team.ui.Messages;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.decorator.PerforceDecorator;
import com.perforce.team.ui.operations.RetryableOperation;
import com.perforce.team.ui.p4java.actions.AddAction;
import com.perforce.team.ui.p4java.actions.RevertEditAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;

public class PerforceMarkerManager
implements IProjectSettingsChangeListener,
IPropertyChangeListener,
IResourceChangeListener,
IResourceDeltaVisitor {
    public static final String ADDITION_MARKER = "com.perforce.team.core.perforceadd";
    private List<IFile> resources = new ArrayList<IFile>();

    public PerforceMarkerManager() {
        PerforceUIPlugin.getPlugin().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        PerforceProviderPlugin.addProjectSettingsChangeListener((IProjectSettingsChangeListener)this);
    }

    public void projectSettingsChanged(IProject project, ConnectionParameters params) {
        if (PerforceTeamProvider.getPerforceProvider((IResource)project) == null) {
            try {
                project.deleteMarkers(ADDITION_MARKER, false, 2);
            }
            catch (CoreException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("pref_show_markers")) {
            boolean show = true;
            Object newVal = event.getNewValue();
            if (newVal instanceof Boolean) {
                show = (Boolean)newVal;
            } else if (newVal instanceof String) {
                try {
                    show = Boolean.parseBoolean((String)newVal);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (!show) {
                IWorkspaceRoot root = PerforceProviderPlugin.getWorkspaceRoot();
                try {
                    root.deleteMarkers(ADDITION_MARKER, false, 2);
                }
                catch (CoreException e) {
                    PerforceProviderPlugin.logError((Throwable)e);
                }
            }
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        int FSTAT_BATCH_SIZE = 1000;
        boolean showMarkers = PerforceUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_show_markers");
        boolean openForAdd = PerforceUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_new_open_add");
        boolean disableMarkerDecoration = PerforceUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_disable_marker_decoration");
        if (disableMarkerDecoration) {
            return;
        }
        IResourceDelta root = event.getDelta();
        IResourceDelta[] projectDeltas = root.getAffectedChildren();
        int i = 0;
        while (i < projectDeltas.length) {
            block23: {
                IResourceDelta delta = projectDeltas[i];
                IResource resource = delta.getResource();
                String resPath = PerforceProviderPlugin.getResourcePath((IResource)resource);
                PerforceTeamProvider provider = PerforceTeamProvider.getPerforceProvider((IResource)resource);
                if (provider != null) {
                    try {
                        PerforceDecorator decorator;
                        this.resources.clear();
                        delta.accept((IResourceDeltaVisitor)this);
                        if (this.resources.size() <= 0) break block23;
                        IFile[] markerResources = this.resources.toArray(new IFile[this.resources.size()]);
                        IP4Connection con = P4ConnectionManager.getManager().getConnection(resource.getProject());
                        if (con == null || con.isOffline()) break block23;
                        IClient client = con.getClient();
                        if (client == null) {
                            return;
                        }
                        String[] statFileNames = new String[this.resources.size()];
                        int j = 0;
                        while (j < statFileNames.length) {
                            statFileNames[j] = markerResources[j].getLocation().toOSString();
                            ++j;
                        }
                        ArrayList<IFile> unmanagedList = new ArrayList<IFile>();
                        ArrayList<IFile> managedList = new ArrayList<IFile>();
                        ArrayList<IFile> managedUndeleteList = new ArrayList<IFile>();
                        List<List<String>> batches = PerforceMarkerManager.getBatches(Arrays.asList(statFileNames), 1000);
                        if (batches != null && batches.size() > 0) {
                            for (List<String> batch : batches) {
                                if (batch == null || batch.size() <= 0) continue;
                                List<IFileSpec> statList = RetryableOperation.fstatWithRetry(con, P4FileSpecBuilder.makeFileSpecList((String[])batch.toArray(new String[batch.size()])));
                                int k = 0;
                                while (k < batch.size()) {
                                    if (k < statList.size() && statList.get(k).getOpStatus() == FileSpecOpStatus.VALID) {
                                        if (statList.get(k).getAction() == FileAction.DELETE) {
                                            managedUndeleteList.add(markerResources[k]);
                                        } else {
                                            managedList.add(markerResources[k]);
                                        }
                                    } else {
                                        unmanagedList.add(markerResources[k]);
                                    }
                                    ++k;
                                }
                            }
                        }
                        IFile[] resourcesToAdd = unmanagedList.toArray(new IFile[unmanagedList.size()]);
                        IFile[] resourcesToRefresh = managedList.toArray(new IFile[managedList.size()]);
                        IFile[] resourcesToUndelete = managedUndeleteList.toArray(new IFile[managedUndeleteList.size()]);
                        if (resourcesToUndelete.length > 0) {
                            Display currentDisplay = PerforceUIPlugin.getDisplay();
                            final IFile[] undeleteResourcesCopy = resourcesToUndelete;
                            currentDisplay.syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    RevertEditAction editDeleteAction = new RevertEditAction();
                                    editDeleteAction.setAsync(false);
                                    editDeleteAction.selectionChanged(null, (ISelection)new StructuredSelection((Object[])undeleteResourcesCopy));
                                    editDeleteAction.run(null);
                                }
                            });
                        }
                        if (resourcesToRefresh.length > 0 && (decorator = PerforceDecorator.getActivePerforceDecorator()) != null) {
                            decorator.resourceStateChanged((IResource[])resourcesToRefresh);
                        }
                        if (resourcesToAdd.length <= 0) break block23;
                        if (showMarkers) {
                            int j2 = 0;
                            while (j2 < resourcesToAdd.length) {
                                try {
                                    IMarker[] existing = resourcesToAdd[j2].findMarkers(ADDITION_MARKER, false, 0);
                                    if (existing == null || existing.length == 0) {
                                        IMarker marker = resourcesToAdd[j2].createMarker(ADDITION_MARKER);
                                        marker.setAttribute("severity", 0);
                                        marker.setAttribute("message", Messages.PerforceMarkerManager_ADDITION);
                                    }
                                }
                                catch (CoreException e) {
                                    PerforceProviderPlugin.logError((Throwable)e);
                                }
                                ++j2;
                            }
                            break block23;
                        }
                        if (openForAdd) {
                            Display currentDisplay = PerforceUIPlugin.getDisplay();
                            final IFile[] unmanagedResourcesCopy = resourcesToAdd;
                            currentDisplay.syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    AddAction addAction = new AddAction();
                                    addAction.setAsync(false);
                                    addAction.setMakeWritable(true);
                                    addAction.selectionChanged(null, (ISelection)new StructuredSelection((Object[])unmanagedResourcesCopy));
                                    addAction.run(null);
                                }
                            });
                        }
                    }
                    catch (CoreException e) {
                        PerforceProviderPlugin.logError((Throwable)e);
                    }
                    catch (Throwable thr) {
                        PerforceUIPlugin.log((IStatus)new Status(4, "com.perforce.team.ui", 4, thr.getMessage(), thr));
                    }
                }
            }
            ++i;
        }
    }

    public boolean visit(IResourceDelta delta) {
        IResource resource = delta.getResource();
        Tracing.printTrace((String)"VISIT DELTA", (String)("deltaType=" + delta.getKind() + ", " + resource.getName()));
        if (!(delta.getKind() != 1 && delta.getKind() != 4 || !(resource instanceof IFile) || PerforceProviderPlugin.isIgnoredHint((IResource)resource) || IgnoredFiles.isIgnored(resource))) {
            this.resources.add((IFile)resource);
        }
        return true;
    }

    private static <T> List<List<T>> getBatches(List<T> list, int len) {
        if (list != null && len > 0) {
            ArrayList<List<T>> parts = new ArrayList<List<T>>();
            int n = list.size();
            int i = 0;
            while (i < n) {
                parts.add(list.subList(i, Math.min(n, i + len)));
                i += len;
            }
            return parts;
        }
        return null;
    }
}

