/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mylyn.search;

import com.perforce.p4java.core.IJobSpec;
import com.perforce.team.core.mylyn.P4MylynUtils;
import com.perforce.team.ui.DatePicker;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.mylyn.PerforceUiMylynPlugin;
import com.perforce.team.ui.mylyn.search.FilterManager;
import com.perforce.team.ui.mylyn.search.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class FilterEntry {
    public static final String[] DATE_OPTIONS = new String[]{Messages.FilterEntry_OnOrBefore, Messages.FilterEntry_Before, Messages.FilterEntry_OnOrAfter, Messages.FilterEntry_After, Messages.FilterEntry_On};
    public static final String[] DATE_OPERATORS = new String[]{"<=", "<", ">=", ">", "="};
    public static final String[] WORD_OPTIONS = new String[]{Messages.FilterEntry_GreaterThan, Messages.FilterEntry_GreaterThanEqual, Messages.FilterEntry_LessThan, Messages.FilterEntry_LessThanEqual};
    public static final String[] WORD_OPERATORS = new String[]{">", ">=", "<", "<="};
    public static final String[] TEXT_OPTIONS = new String[]{Messages.FilterEntry_Equals, Messages.FilterEntry_NotEquals, Messages.FilterEntry_Contains, Messages.FilterEntry_StartsWith, Messages.FilterEntry_EndsWith};
    private Combo field;
    private Combo modifier;
    private Combo value;
    private ToolItem add;
    private ToolItem remove;
    private DatePicker date;
    private IJobSpec spec;
    private IJobSpec.IJobSpecField[] fields;
    private Map<String, String[]> sortedValues;
    private FilterManager manager;
    private ListenerList listeners = new ListenerList();

    public static String escapeValue(String value) {
        return P4MylynUtils.escapeJobQueryValue((String)value);
    }

    public FilterEntry(FilterManager manager, IJobSpec spec) {
        this.manager = manager;
        this.spec = spec;
        List jobFields = this.spec != null ? this.spec.getFields() : new ArrayList();
        this.fields = jobFields.toArray(new IJobSpec.IJobSpecField[jobFields.size()]);
        Arrays.sort(this.fields, new Comparator<IJobSpec.IJobSpecField>(){

            @Override
            public int compare(IJobSpec.IJobSpecField o1, IJobSpec.IJobSpecField o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        this.sortedValues = new HashMap<String, String[]>();
    }

    public void setName(String name) {
        if (name != null) {
            this.field.setText(name);
        }
    }

    public void setOperator(String operator) {
        if (operator != null) {
            this.updateModifiers();
            this.modifier.setText(operator);
        }
    }

    public void setValue(String value) {
        if (value != null) {
            this.updateValues();
            this.value.setText(value);
        }
    }

    private void updateFields() {
        this.field.removeAll();
        IJobSpec.IJobSpecField[] iJobSpecFieldArray = this.fields;
        int n = this.fields.length;
        int n2 = 0;
        while (n2 < n) {
            IJobSpec.IJobSpecField field = iJobSpecFieldArray[n2];
            this.field.add(field.getName());
            ++n2;
        }
    }

    private void updateModifiers() {
        int index = this.field.getSelectionIndex();
        this.modifier.removeAll();
        if (index >= 0) {
            IJobSpec.IJobSpecField selected = this.fields[index];
            String data = selected.getDataType();
            if ("date".equals(data)) {
                this.date.setVisible(true);
                String[] stringArray = DATE_OPTIONS;
                int n = DATE_OPTIONS.length;
                int n2 = 0;
                while (n2 < n) {
                    String option = stringArray[n2];
                    this.modifier.add(option);
                    ++n2;
                }
            } else {
                String option;
                int n;
                int n3;
                String[] stringArray;
                this.date.setVisible(false);
                if ("word".equals(data)) {
                    stringArray = WORD_OPTIONS;
                    n3 = WORD_OPTIONS.length;
                    n = 0;
                    while (n < n3) {
                        option = stringArray[n];
                        this.modifier.add(option);
                        ++n;
                    }
                }
                stringArray = TEXT_OPTIONS;
                n3 = TEXT_OPTIONS.length;
                n = 0;
                while (n < n3) {
                    option = stringArray[n];
                    this.modifier.add(option);
                    ++n;
                }
            }
            this.modifier.setEnabled(true);
        } else {
            this.modifier.add(Messages.FilterEntry_SelectField);
            this.modifier.setEnabled(false);
        }
    }

    private boolean shouldSortValues() {
        return PerforceUiMylynPlugin.getDefault().getPreferenceStore().getBoolean("com.perforce.team.ui.mylyn.preferences.SORT_JOB_VALUES");
    }

    private void updateValues() {
        IJobSpec.IJobSpecField selected;
        String data;
        this.value.removeAll();
        int index = this.field.getSelectionIndex();
        if (index >= 0 && "select".equals(data = (selected = this.fields[index]).getDataType())) {
            String[] sorted = this.sortedValues.get(selected.getName());
            if (sorted == null) {
                List values = this.spec.getFieldValues(selected.getName());
                sorted = values.toArray(new String[values.size()]);
                if (this.shouldSortValues()) {
                    Arrays.sort(sorted, new Comparator<String>(){

                        @Override
                        public int compare(String o1, String o2) {
                            return o1.compareToIgnoreCase(o2);
                        }
                    });
                }
                this.sortedValues.put(selected.getName(), sorted);
            }
            String[] stringArray = sorted;
            int n = sorted.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                this.value.add(value);
                ++n2;
            }
        }
    }

    private void formatText(StringBuilder filter, String name, String value, int modifier) {
        filter.append(name);
        switch (modifier) {
            case 0: {
                filter.append('=');
                filter.append(value);
                break;
            }
            case 1: {
                filter.insert(0, '^');
                filter.append('=');
                filter.append(value);
                break;
            }
            case 2: {
                filter.append('=');
                filter.append('*');
                filter.append(value);
                filter.append('*');
                break;
            }
            case 3: {
                filter.append('=');
                filter.append(value);
                filter.append('*');
                break;
            }
            case 4: {
                filter.append('=');
                filter.append('*');
                filter.append(value);
                break;
            }
        }
    }

    public Filter getFilter() {
        Filter filter = null;
        String name = null;
        String operator = null;
        String value = this.value.getText().trim();
        if (value.length() > 0) {
            int index = this.field.getSelectionIndex();
            int modIndex = this.modifier.getSelectionIndex();
            IJobSpec.IJobSpecField selected = null;
            boolean isText = false;
            if (index >= 0) {
                filter = new Filter();
                filter.rawValue = value;
                value = FilterEntry.escapeValue(value);
                selected = this.fields[index];
                if (selected != null) {
                    name = selected.getName();
                    String data = selected.getDataType();
                    if (modIndex >= 0) {
                        filter.operator = this.modifier.getText();
                        if ("date".equals(data)) {
                            operator = DATE_OPERATORS[modIndex];
                        } else if ("word".equals(data)) {
                            if (modIndex < WORD_OPERATORS.length) {
                                operator = WORD_OPERATORS[modIndex];
                            } else {
                                modIndex -= WORD_OPERATORS.length;
                                isText = true;
                            }
                        } else {
                            isText = true;
                        }
                    }
                    StringBuilder filterQuery = new StringBuilder();
                    if (name != null && value != null) {
                        if (!isText) {
                            if (operator != null) {
                                filterQuery.append(name);
                                filterQuery.append(operator);
                                filterQuery.append(value);
                            }
                        } else {
                            this.formatText(filterQuery, name, value, modIndex);
                        }
                    }
                    filter.name = name;
                    filter.dateType = selected.getDataType();
                    filter.fullQuery = filterQuery.toString();
                    if (filter.fullQuery.startsWith("^")) {
                        filter.negated = true;
                    }
                }
            }
        }
        return filter;
    }

    private void createButtonArea(final Composite parent, final Composite displayArea, final Composite layoutParent) {
        ToolBar buttonArea = new ToolBar(parent, 0x800000);
        GridLayout baLayout = new GridLayout(2, true);
        baLayout.marginHeight = 0;
        baLayout.marginWidth = 0;
        baLayout.horizontalSpacing = 0;
        buttonArea.setLayout((Layout)baLayout);
        this.remove = new ToolItem(buttonArea, 0x800008);
        Image removeImage = PerforceUIPlugin.getDescriptor((String)"normal/delete.png").createImage();
        P4UIUtils.registerDisposal((Widget)this.remove, (Resource)removeImage);
        this.remove.setImage(removeImage);
        this.remove.setToolTipText(Messages.FilterEntry_RemoveFilter);
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                parent.setVisible(false);
                ((GridData)parent.getLayoutData()).exclude = true;
                boolean allInvisible = true;
                Control[] controlArray = displayArea.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control control = controlArray[n2];
                    if (control.getVisible()) {
                        allInvisible = false;
                        break;
                    }
                    ++n2;
                }
                if (allInvisible) {
                    displayArea.setVisible(false);
                    ((GridData)displayArea.getLayoutData()).exclude = true;
                }
                layoutParent.layout(true, true);
                FilterEntry.this.manager.remove(FilterEntry.this);
                FilterEntry.this.notifyListeners();
            }
        });
        this.add = new ToolItem(buttonArea, 0x800008);
        Image addImage = PerforceUIPlugin.getDescriptor((String)"normal/add.png").createImage();
        P4UIUtils.registerDisposal((Widget)this.add, (Resource)addImage);
        this.add.setImage(addImage);
        this.add.setToolTipText(Messages.FilterEntry_AddFilter);
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterEntry entry = new FilterEntry(FilterEntry.this.manager, FilterEntry.this.spec);
                entry.createControl(displayArea, layoutParent, true);
                layoutParent.layout(true, true);
                FilterEntry.this.manager.add(entry);
            }
        });
    }

    public void createControl(Composite parent, Composite layoutParent, boolean useParent) {
        if (!useParent) {
            parent = new Composite(parent, 0);
            GridLayout daLayout = new GridLayout(1, true);
            daLayout.marginHeight = 0;
            daLayout.marginWidth = 0;
            parent.setLayout((Layout)daLayout);
            GridData daData = new GridData(4, 0x1000000, true, false);
            parent.setLayoutData((Object)daData);
        }
        Composite displayArea = parent;
        Composite filter = new Composite(displayArea, 0);
        GridLayout fLayout = new GridLayout(5, false);
        fLayout.marginHeight = 0;
        fLayout.marginWidth = 0;
        filter.setLayout((Layout)fLayout);
        GridData fData = new GridData(4, 0x1000000, true, false);
        filter.setLayoutData((Object)fData);
        this.field = new Combo(filter, 12);
        this.updateFields();
        this.field.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterEntry.this.updateModifiers();
                FilterEntry.this.updateValues();
                int index = FilterEntry.this.field.getSelectionIndex();
                if (index >= 0) {
                    IJobSpec.IJobSpecField selected = FilterEntry.this.fields[index];
                    String data = selected.getDataType();
                    int modIndex = FilterEntry.this.modifier.getSelectionIndex();
                    if (modIndex == -1) {
                        if ("date".equals(data)) {
                            FilterEntry.this.modifier.select(2);
                        } else if ("word".equals(data)) {
                            FilterEntry.this.modifier.select(4);
                        } else {
                            FilterEntry.this.modifier.select(0);
                        }
                    }
                }
                FilterEntry.this.notifyListeners();
            }
        });
        this.modifier = new Combo(filter, 12);
        GridData mData = new GridData(1, 0x1000000, false, false);
        GC gc = new GC((Drawable)this.modifier.getDisplay());
        try {
            Point width = gc.stringExtent(WORD_OPTIONS[1]);
            mData.widthHint = width.x + 50;
        }
        finally {
            gc.dispose();
        }
        this.modifier.setLayoutData((Object)mData);
        this.modifier.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FilterEntry.this.notifyListeners();
            }
        });
        this.updateModifiers();
        this.date = new DatePicker();
        this.date.createControl(filter);
        this.date.setVisible(false);
        this.value = new Combo(filter, 4);
        this.value.setLayoutData((Object)new GridData(4, 4, true, false));
        this.value.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FilterEntry.this.notifyListeners();
            }
        });
        this.date.setCombo(this.value);
        this.createButtonArea(filter, displayArea, layoutParent);
    }

    public void createControl(Composite parent) {
        this.createControl(parent, parent, false);
    }

    public void setRemoveEnabled(boolean enabled) {
        this.remove.setEnabled(enabled);
    }

    private void notifyListeners() {
        Event event = new Event();
        event.data = this;
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((Listener)listener).handleEvent(event);
            ++n2;
        }
    }

    public void addListener(Listener listener) {
        if (listener != null) {
            this.listeners.add((Object)listener);
        }
    }

    public void removeListener(Listener listener) {
        if (listener != null) {
            this.listeners.remove((Object)listener);
        }
    }

    public static class Filter {
        public String name;
        public String operator;
        public String rawValue;
        public String dateType;
        public String fullQuery;
        public boolean negated = false;
    }
}

