/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mylyn.preferences;

import com.perforce.p4java.core.IJobSpec;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.mylyn.editor.JobField;
import com.perforce.team.ui.mylyn.editor.JobFieldGroup;
import com.perforce.team.ui.mylyn.preferences.JobSpecLabelProvider;
import com.perforce.team.ui.mylyn.preferences.Messages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class JobLayoutPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IP4Connection[] connections = null;
    private IP4Connection selected = null;
    private Map<IP4Connection, List<JobFieldGroup>> fields = new HashMap<IP4Connection, List<JobFieldGroup>>();
    private Composite displayArea;
    private TreeViewer specViewer = null;
    private Combo connectionCombo;
    private Object loading = new Object();

    private void setSelection(IP4Connection connection) {
        if (connection != null && P4UIUtils.okToUse((Viewer)this.specViewer)) {
            this.selected = connection;
            this.specViewer.setInput((Object)this.selected);
        }
    }

    private void loadConnection(final IP4Connection connection) {
        this.specViewer.setInput(this.loading);
        P4Runner.schedule((IP4Runnable)new P4Runnable(){

            public void run(IProgressMonitor monitor) {
                if (!JobLayoutPreferencePage.this.fields.containsKey(connection)) {
                    JobFieldGroup corePage = JobFieldGroup.loadPage(connection, "Job");
                    JobFieldGroup advancedPage = JobFieldGroup.loadPage(connection, "Other");
                    if (advancedPage == null) {
                        advancedPage = new JobFieldGroup(connection, "Other");
                    }
                    ArrayList<JobFieldGroup> pages = new ArrayList<JobFieldGroup>();
                    if (corePage != null) {
                        pages.add(corePage);
                    }
                    pages.add(advancedPage);
                    JobLayoutPreferencePage.this.fields.put(connection, pages);
                    if (connection == JobLayoutPreferencePage.this.selected) {
                        PerforceUIPlugin.syncExec((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                JobLayoutPreferencePage.this.setSelection(connection);
                            }
                        });
                    }
                }
            }
        }, (ISchedulingRule)new ConnectionRule(connection));
    }

    private IBaseLabelProvider createLabelProvider() {
        final JobSpecLabelProvider wrapper = new JobSpecLabelProvider(){
            private Image loadingImage = PerforceUIPlugin.getDescriptor((String)"perforce/hourglass.png").createImage();

            public void dispose() {
                super.dispose();
                this.loadingImage.dispose();
            }

            @Override
            public Image getImage(Object element) {
                if (element == JobLayoutPreferencePage.this.loading) {
                    return this.loadingImage;
                }
                return super.getImage(element);
            }

            @Override
            public String getText(Object element) {
                if (element == JobLayoutPreferencePage.this.loading) {
                    return Messages.JobLayoutPreferencePage_Loading;
                }
                return super.getText(element);
            }
        };
        DelegatingStyledCellLabelProvider.IStyledLabelProvider styledProvider = new DelegatingStyledCellLabelProvider.IStyledLabelProvider(){
            private Font boldFont;
            {
                this.boldFont = P4UIUtils.generateBoldFont((Device)JobLayoutPreferencePage.this.specViewer.getTree().getDisplay(), (Font)JobLayoutPreferencePage.this.specViewer.getTree().getFont());
            }

            public Image getImage(Object element) {
                return wrapper.getImage(element);
            }

            public StyledString getStyledText(Object element) {
                if (element instanceof JobField && 105 == ((JobField)element).getField().getCode()) {
                    return new StyledString(wrapper.getText(element), new StyledString.Styler(){

                        public void applyStyles(TextStyle textStyle) {
                            textStyle.font = boldFont;
                        }
                    });
                }
                return new StyledString(wrapper.getText(element));
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
                wrapper.dispose();
                this.boldFont.dispose();
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        };
        ILabelDecorator decorator = new ILabelDecorator(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String decorateText(String text, Object element) {
                if (element instanceof JobField) {
                    IJobSpec.IJobSpecField field = ((JobField)element).getField();
                    return String.valueOf(text) + " : " + field.getDataType();
                }
                return text;
            }

            public Image decorateImage(Image image, Object element) {
                return null;
            }
        };
        return new DecoratingStyledCellLabelProvider(styledProvider, decorator, null);
    }

    private void createSpecViewer(Composite parent, int numColumns) {
        Label viewerLabel = new Label(parent, 64);
        viewerLabel.setText(Messages.JobLayoutPreferencePage_DragAndDropFields);
        GridData vlData = new GridData(4, 4, true, false);
        vlData.horizontalSpan = numColumns;
        viewerLabel.setLayoutData((Object)vlData);
        this.specViewer = new TreeViewer(parent, 2818);
        this.specViewer.setLabelProvider(this.createLabelProvider());
        this.specViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public boolean hasChildren(Object element) {
                return element instanceof IP4Connection || element instanceof JobFieldGroup;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                Object[] children = null;
                if (parentElement instanceof IP4Connection) {
                    children = ((List)JobLayoutPreferencePage.this.fields.get(parentElement)).toArray();
                } else if (parentElement instanceof JobFieldGroup) {
                    children = ((JobFieldGroup)parentElement).getFields();
                } else if (parentElement == JobLayoutPreferencePage.this.loading) {
                    children = new Object[]{parentElement};
                }
                if (children == null) {
                    children = new Object[]{};
                }
                return children;
            }
        });
        GridData svData = new GridData(4, 4, true, true);
        svData.horizontalSpan = numColumns;
        this.specViewer.getTree().setLayoutData((Object)svData);
        this.specViewer.addDragSupport(19, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new DragSourceAdapter(){
            private IStructuredSelection selection = null;

            public void dragFinished(DragSourceEvent event) {
                this.selection = null;
            }

            public void dragStart(DragSourceEvent event) {
                this.selection = (IStructuredSelection)JobLayoutPreferencePage.this.specViewer.getSelection();
                Object[] objectArray = this.selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (element instanceof JobFieldGroup || element instanceof JobField && 105 == ((JobField)element).getField().getCode()) {
                        event.doit = false;
                        this.selection = null;
                        break;
                    }
                    ++n2;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                if (this.selection != null && LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
                    LocalSelectionTransfer.getTransfer().setSelection((ISelection)this.selection);
                    event.data = this.selection;
                }
            }
        });
        this.specViewer.setAutoExpandLevel(-1);
        this.specViewer.addDropSupport(19, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                if (event.item != null && event.data instanceof IStructuredSelection) {
                    JobFieldGroup page = null;
                    int index = 0;
                    if (event.item.getData() instanceof JobField) {
                        JobField field = (JobField)event.item.getData();
                        page = field.getParent();
                        index = page.indexOf(field);
                    } else if (event.item.getData() instanceof JobFieldGroup) {
                        page = (JobFieldGroup)event.item.getData();
                        index = 0;
                    }
                    if (page != null) {
                        Object[] elements = ((IStructuredSelection)event.data).toArray();
                        ArrayList<JobField> fields = new ArrayList<JobField>(elements.length);
                        Object[] objectArray = elements;
                        int n = elements.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object element = objectArray[n2];
                            if (element instanceof JobField) {
                                fields.add((JobField)element);
                            }
                            ++n2;
                        }
                        page.move(fields.toArray(new JobField[fields.size()]), index);
                    }
                    JobLayoutPreferencePage.this.specViewer.refresh();
                }
            }

            public void dragOver(DropTargetEvent event) {
                if (event.item != null) {
                    if (event.item.getData() instanceof JobField) {
                        event.feedback = 26;
                    } else if (event.item.getData() instanceof JobFieldGroup) {
                        event.feedback = 25;
                    }
                }
            }
        });
    }

    protected Control createContents(Composite parent) {
        this.displayArea = new Composite(parent, 0);
        this.displayArea.setLayout((Layout)new GridLayout(2, false));
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        Label connectionsLabel = new Label(this.displayArea, 0);
        connectionsLabel.setText(Messages.JobLayoutPreferencePage_Connections);
        this.connectionCombo = new Combo(this.displayArea, 12);
        IP4Connection[] iP4ConnectionArray = this.connections = P4ConnectionManager.getManager().getConnections();
        int n = this.connections.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Connection connection = iP4ConnectionArray[n2];
            this.connectionCombo.add(connection.toString());
            ++n2;
        }
        this.connectionCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.connectionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = JobLayoutPreferencePage.this.connectionCombo.getSelectionIndex();
                if (index >= 0 && index < JobLayoutPreferencePage.this.connections.length) {
                    JobLayoutPreferencePage.this.selected = JobLayoutPreferencePage.this.connections[index];
                    if (!JobLayoutPreferencePage.this.fields.containsKey(JobLayoutPreferencePage.this.selected)) {
                        JobLayoutPreferencePage.this.specViewer.setInput(JobLayoutPreferencePage.this.loading);
                        JobLayoutPreferencePage.this.loadConnection(JobLayoutPreferencePage.this.selected);
                    } else {
                        JobLayoutPreferencePage.this.setSelection(JobLayoutPreferencePage.this.connections[index]);
                    }
                }
            }
        });
        this.createSpecViewer(this.displayArea, 2);
        return this.displayArea;
    }

    protected void performDefaults() {
        super.performDefaults();
        IP4Connection connection = this.selected;
        if (connection != null && this.fields.containsKey(connection)) {
            JobFieldGroup corePage = JobFieldGroup.loadDefaultPages(connection, "Job");
            JobFieldGroup advancedPage = new JobFieldGroup(connection, "Other");
            ArrayList<JobFieldGroup> pages = new ArrayList<JobFieldGroup>();
            if (corePage != null) {
                corePage.setIndex(pages.size());
                pages.add(corePage);
            }
            advancedPage.setIndex(pages.size());
            pages.add(advancedPage);
            this.fields.put(connection, pages);
            this.setSelection(connection);
        }
    }

    public boolean performOk() {
        boolean ok = super.performOk();
        if (this.selected != null) {
            List<JobFieldGroup> pages = this.fields.get(this.selected);
            JobFieldGroup.savePages(this.selected, pages.toArray(new JobFieldGroup[pages.size()]));
        }
        return ok;
    }

    public void init(IWorkbench workbench) {
    }

    private static class ConnectionRule
    implements ISchedulingRule {
        private IP4Connection connection;

        public ConnectionRule(IP4Connection connection) {
            this.connection = connection;
        }

        public boolean contains(ISchedulingRule rule) {
            if (rule instanceof ConnectionRule) {
                return this.connection.equals(((ConnectionRule)rule).connection);
            }
            return false;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            if (rule instanceof ConnectionRule) {
                return this.connection.equals(((ConnectionRule)rule).connection);
            }
            return false;
        }
    }
}

