/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mylyn.job;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.ui.editor.PageFactoryRegistry;
import com.perforce.team.ui.mylyn.job.BulkJobInput;
import com.perforce.team.ui.mylyn.job.BulkJobPage;
import com.perforce.team.ui.mylyn.job.IJobProxy;
import com.perforce.team.ui.mylyn.job.Messages;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.editor.SharedHeaderFormEditor;
import org.eclipse.ui.forms.widgets.Form;

public class BulkJobEditor
extends SharedHeaderFormEditor {
    public static final String ID = "com.perforce.team.ui.mylyn.job.BulkJobEditor";
    private IP4Connection connection;
    private IJobProxy[] jobs;
    private BulkJobPage jobPage = null;

    protected void addPages() {
        try {
            this.jobPage = new BulkJobPage((FormEditor)this, this.connection, this.jobs);
            this.addPage((IFormPage)this.jobPage);
            IToolBarManager manager = this.getHeaderForm().getForm().getToolBarManager();
            this.jobPage.fillHeaderToolbar(manager);
            manager.update(true);
        }
        catch (PartInitException e) {
            PerforceProviderPlugin.logError((Throwable)e);
        }
        PageFactoryRegistry.getRegistry().addPages((FormEditor)this, ID);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof BulkJobInput)) {
            throw new PartInitException(Messages.BulkJobEditor_InputMustBeBulkJobInput);
        }
        BulkJobInput jobInput = (BulkJobInput)input;
        this.jobs = jobInput.getJobs();
        this.connection = jobInput.getConnection();
        super.init(site, input);
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected void createHeaderContents(IManagedForm headerForm) {
        Form form = headerForm.getForm().getForm();
        form.setText(MessageFormat.format(Messages.BulkJobEditor_EditJobsOn, this.connection.getParameters().getPort()));
        this.getToolkit().decorateFormHeading(form);
    }
}

