/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mylyn.job;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.mylyn.job.BulkJobInput;
import com.perforce.team.ui.mylyn.job.IJobProxy;
import com.perforce.team.ui.mylyn.job.JobProxyContainer;
import com.perforce.team.ui.mylyn.job.Messages;
import com.perforce.team.ui.p4java.actions.P4Action;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class BulkChangeAction
extends P4Action {
    private Map<IP4Connection, Set<IJobProxy>> generateConnectionMap() {
        HashMap<IP4Connection, Set<IJobProxy>> connectionJobs = new HashMap<IP4Connection, Set<IJobProxy>>();
        IStructuredSelection jobSelection = this.getSelection();
        if (jobSelection != null) {
            Object[] objectArray = jobSelection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJobProxy proxy;
                HashSet<IJobProxy> jobs;
                IP4Connection connection;
                Object resource = objectArray[n2];
                if (resource instanceof JobProxyContainer) {
                    JobProxyContainer container = (JobProxyContainer)((Object)resource);
                    connection = container.getConnection();
                    if (connection != null) {
                        if (!connectionJobs.containsKey(connection)) {
                            connectionJobs.put(connection, new HashSet());
                        }
                        jobs = (Set)connectionJobs.get(connection);
                        jobs.addAll(Arrays.asList(container.getJobs()));
                    }
                } else if (resource instanceof IJobProxy && (connection = (proxy = (IJobProxy)resource).getConnection()) != null) {
                    jobs = (HashSet<IJobProxy>)connectionJobs.get(connection);
                    if (jobs == null) {
                        jobs = new HashSet<IJobProxy>();
                        connectionJobs.put(connection, jobs);
                    }
                    jobs.add(proxy);
                }
                ++n2;
            }
        }
        return connectionJobs;
    }

    protected void runAction() {
        if (this.getSelection() == null || this.getSelection().isEmpty()) {
            return;
        }
        Map<IP4Connection, Set<IJobProxy>> connectionJobs = this.generateConnectionMap();
        for (Map.Entry<IP4Connection, Set<IJobProxy>> entry : connectionJobs.entrySet()) {
            final IP4Connection connection = entry.getKey();
            final Set<IJobProxy> jobs = entry.getValue();
            if (connection.getJobSpec() == null || connection.getJobs(1).length != 1) {
                MessageDialog.openWarning(null, (String)Messages.BulkJobChangeAction_Warning, (String)Messages.BulkJobChangeAction_WarningDetail);
                return;
            }
            PerforceUIPlugin.syncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        BulkJobInput input = null;
                        input = jobs == null ? new BulkJobInput(connection) : new BulkJobInput(connection, jobs.toArray(new IJobProxy[jobs.size()]));
                        IDE.openEditor((IWorkbenchPage)PerforceUIPlugin.getActivePage(), (IEditorInput)input, (String)"com.perforce.team.ui.mylyn.job.BulkJobEditor");
                    }
                    catch (PartInitException e) {
                        PerforceProviderPlugin.logError((Throwable)e);
                    }
                }
            });
        }
    }
}

