/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.wizards.mapping.branch;

import com.perforce.team.core.mergequest.model.IBranchGraph;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.ui.IErrorProvider;
import com.perforce.team.ui.mergequest.P4BranchGraphPlugin;
import com.perforce.team.ui.mergequest.wizards.mapping.IMappingArea;
import com.perforce.team.ui.mergequest.wizards.mapping.MappingWizardPage;
import com.perforce.team.ui.mergequest.wizards.mapping.branch.BranchArea;
import com.perforce.team.ui.mergequest.wizards.mapping.branch.Messages;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.widgets.Composite;

public class BranchMappingWizardPage
extends MappingWizardPage {
    private boolean inSession = false;

    public BranchMappingWizardPage(String pageName, IBranchGraph graph) {
        super(pageName, graph);
    }

    @Override
    public void setErrorMessage(String message, IErrorProvider provider) {
        if (this.inSession) {
            this.setPageComplete(false);
            this.setErrorMessage(message);
        } else {
            super.setErrorMessage(message, provider);
        }
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        this.setTitle(Messages.BranchMappingWizardPage_Title);
        this.setMessage(Messages.BranchMappingWizardPage_Description);
        this.setImageDescriptor(P4BranchGraphPlugin.getImageDescriptor("icons/wizard/branch.png"));
        ((BranchArea)this.getMappingArea()).getAssistant().addCompletionListener(new ICompletionListener(){

            public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
            }

            public void assistSessionStarted(ContentAssistEvent event) {
                BranchMappingWizardPage.this.inSession = true;
                BranchMappingWizardPage.this.setPageComplete(false);
            }

            public void assistSessionEnded(ContentAssistEvent event) {
                BranchMappingWizardPage.this.inSession = false;
                BranchMappingWizardPage.this.setPageComplete(BranchMappingWizardPage.this.getErrorMessage() == null);
            }
        });
    }

    @Override
    protected IMappingArea createMappingArea(IBranchGraph graph, IP4Connection connection) {
        return new BranchArea(graph, connection);
    }
}

