/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.wizards.mapping.branch;

import com.perforce.team.core.p4java.IP4Branch;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.editor.BaseContentAssistProcessor;
import com.perforce.team.ui.editor.BaseContentAssistant;
import com.perforce.team.ui.editor.IProposal;
import com.perforce.team.ui.mergequest.parts.SharedResources;
import com.perforce.team.ui.mergequest.wizards.mapping.branch.BranchCompletionProposal;
import com.perforce.team.ui.mergequest.wizards.mapping.branch.BranchProposal;
import com.perforce.team.ui.mergequest.wizards.mapping.branch.LoadingProposal;
import com.perforce.team.ui.mergequest.wizards.mapping.branch.Messages;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Widget;

public class BranchAssistant
extends BaseContentAssistant {
    private Set<String> searches = new HashSet<String>();
    private Set<IProposal> branchProposals = new TreeSet<IProposal>();
    private SharedResources resources;
    private Runnable callback;
    private ITextViewer viewer;
    private ISchedulingRule searchRule = P4Runner.createRule();
    private IP4Connection connection = null;

    public BranchAssistant(SharedResources resources, IP4Connection connection) {
        this.resources = resources;
        this.connection = connection;
    }

    public BranchAssistant(SharedResources resources, IP4Connection connection, Runnable callback) {
        this(resources, connection);
        this.callback = callback;
    }

    public void install(ITextViewer textViewer) {
        this.viewer = textViewer;
        super.install(textViewer);
    }

    private String convertNameContains(String entered) {
        String converted = entered;
        if (converted.length() > 0 && !(converted = converted.replace("*", "...")).endsWith("...")) {
            converted = String.valueOf(converted) + "...";
        }
        return converted;
    }

    private boolean containsSearch(String prefix) {
        while (prefix.length() >= 1) {
            if (this.searches.contains(prefix)) {
                return true;
            }
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        return false;
    }

    private void searchForBranch(final String prefix, final String searchName) {
        P4Runner.schedule((IP4Runnable)new P4Runnable(){

            public String getTitle() {
                return MessageFormat.format(Messages.BranchAssistant_Searching, prefix);
            }

            public void run(IProgressMonitor monitor) {
                final IP4Branch[] branches = BranchAssistant.this.connection.getBranches(null, -1, searchName);
                PerforceUIPlugin.syncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (P4UIUtils.okToUse((Widget)BranchAssistant.this.viewer.getTextWidget())) {
                            BranchAssistant.this.loadProposals(branches);
                            BranchAssistant.this.showPossibleCompletions();
                        }
                    }
                });
            }
        }, (ISchedulingRule)this.searchRule);
    }

    protected ICompletionProposal createProposal(IProposal proposal, int replaceOffset, int replaceLength, int cursorOffset) {
        return new BranchCompletionProposal(((BranchProposal)proposal).getBranch(), replaceOffset, replaceLength, cursorOffset, proposal.getImage(), this.callback);
    }

    public void loadProposals(IP4Branch[] branches) {
        if (branches != null) {
            IP4Branch[] iP4BranchArray = branches;
            int n = branches.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Branch branch = iP4BranchArray[n2];
                this.branchProposals.add((IProposal)new BranchProposal(branch, this.resources));
                this.activatorSet.add(Character.valueOf(branch.getName().charAt(0)));
                ++n2;
            }
        }
        this.updateCharArray();
    }

    public void init() {
        super.init();
        this.enablePrefixCompletion(false);
        this.setRepeatedInvocationMode(true);
        this.setShowEmptyList(true);
        this.enableColoredLabels(true);
    }

    protected IContentAssistProcessor createProcessor() {
        return new BaseContentAssistProcessor(){

            public char[] getCompletionProposalAutoActivationCharacters() {
                return BranchAssistant.this.activators;
            }

            public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
                boolean empty;
                String prefix = this.getPrefix(viewer.getDocument(), offset);
                TreeSet<LoadingProposal> proposals = new TreeSet<LoadingProposal>(BranchAssistant.this.comparator);
                boolean useExisting = false;
                boolean bl = empty = prefix.length() == 0;
                if (!empty && !BranchAssistant.this.containsSearch(prefix)) {
                    String search = BranchAssistant.this.convertNameContains(prefix);
                    BranchAssistant.this.searches.add(prefix);
                    proposals.add(new LoadingProposal(BranchAssistant.this.resources));
                    BranchAssistant.this.searchForBranch(prefix, search);
                } else {
                    useExisting = true;
                }
                if (useExisting) {
                    Point selection = viewer.getSelectedRange();
                    int selectOffset = selection.x;
                    int selectLength = selection.y;
                    BranchAssistant.this.createProposals(prefix, BranchAssistant.this.branchProposals, proposals, offset, selectOffset, selectLength);
                }
                if (!empty && proposals.size() == 0) {
                    BranchAssistant.this.setShowEmptyList(true);
                    BranchAssistant.this.setEmptyMessage(MessageFormat.format(Messages.BranchAssistant_NoBranchesFound, prefix));
                } else {
                    BranchAssistant.this.setShowEmptyList(false);
                }
                return proposals.toArray(new ICompletionProposal[proposals.size()]);
            }
        };
    }
}

