/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.wizards.mapping;

import com.perforce.team.core.mergequest.model.Branch;
import com.perforce.team.core.mergequest.model.IBranchGraph;
import com.perforce.team.core.mergequest.model.Mapping;
import com.perforce.team.ui.mergequest.wizards.branch.BranchDescriptor;
import com.perforce.team.ui.mergequest.wizards.mapping.MappingWizardPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public abstract class NewMappingWizard
extends Wizard
implements INewWizard {
    private IBranchGraph graph = null;
    private MappingWizardPage mappingPage = null;
    private Mapping created = null;
    private BranchDescriptor sourceDescriptor;
    private BranchDescriptor targetDescriptor;
    private Branch source = null;
    private Branch target = null;
    private Mapping mapping = null;

    public NewMappingWizard(IBranchGraph graph) {
        this.graph = graph;
    }

    public void setInitialSource(Branch source) {
        this.source = source;
    }

    public void setInitialTarget(Branch target) {
        this.target = target;
    }

    public void setInitialMapping(Mapping mapping) {
        this.mapping = mapping;
        if (this.mapping != null) {
            this.setInitialSource(this.mapping.getSource());
            this.setInitialTarget(this.mapping.getTarget());
        }
    }

    public Mapping getMapping() {
        return this.created;
    }

    public BranchDescriptor getSourceDescriptor() {
        return this.sourceDescriptor;
    }

    public BranchDescriptor getTargetDescriptor() {
        return this.targetDescriptor;
    }

    public boolean performFinish() {
        this.created = this.mappingPage.createMapping();
        this.sourceDescriptor = this.mappingPage.getSourceDescriptor();
        this.targetDescriptor = this.mappingPage.getTargetDescriptor();
        if (this.source == null) {
            this.source = this.mappingPage.getSourceSelection();
        }
        if (this.target == null) {
            this.target = this.mappingPage.getTargetSelection();
        }
        return true;
    }

    public Branch getSourceSelection() {
        return this.source;
    }

    public Branch getTargetSelection() {
        return this.target;
    }

    protected abstract MappingWizardPage createMappingPage(IBranchGraph var1);

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.mappingPage = this.createMappingPage(this.graph);
        this.mappingPage.setSource(this.source);
        this.mappingPage.setTarget(this.target);
        this.addPage((IWizardPage)this.mappingPage);
    }
}

