/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.tooltip;

import com.perforce.team.core.mergequest.model.Branch;
import com.perforce.team.core.mergequest.model.IBranchGraphElement;
import com.perforce.team.core.mergequest.model.Mapping;
import com.perforce.team.ui.mergequest.P4BranchGraphPlugin;
import com.perforce.team.ui.mergequest.parts.IControlProvider;
import com.perforce.team.ui.mergequest.tooltip.BaseToolTip;
import com.perforce.team.ui.mergequest.tooltip.BranchToolTip;
import com.perforce.team.ui.mergequest.tooltip.IToolTipManager;
import com.perforce.team.ui.mergequest.tooltip.MappingToolTip;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FreeformLayeredPane;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.ScalableFreeformLayeredPane;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.swt.widgets.Control;

public class BranchGraphToolTipManager
implements IToolTipManager,
IPropertyChangeListener {
    private IBranchGraphElement graphElement = null;
    private ToolTip tip = null;
    private IControlProvider provider;
    private boolean enabled = false;

    public BranchGraphToolTipManager(IControlProvider provider) {
        this.provider = provider;
        P4BranchGraphPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.updateEnablement();
    }

    private double getScale(FigureCanvas canvas) {
        Layer layer;
        double scale = 1.0;
        IFigure root = canvas.getContents();
        if (root != null && (layer = ((FreeformLayeredPane)root).getLayer((Object)"Scalable Layers")) instanceof ScalableFreeformLayeredPane) {
            scale = ((ScalableFreeformLayeredPane)layer).getScale();
        }
        return scale;
    }

    private ToolTip createTip(IBranchGraphElement element, MouseEvent event) {
        BaseToolTip newTip = null;
        Control control = this.provider.getCurrentControl();
        if (control != null) {
            if (element instanceof Branch) {
                newTip = new BranchToolTip(control, (Branch)element);
            } else if (element instanceof Mapping) {
                newTip = new MappingToolTip(control, (Mapping)element);
            }
            if (control instanceof FigureCanvas) {
                FigureCanvas canvas = (FigureCanvas)control;
                Point converted = new Point(event.x, event.y);
                converted.scale(this.getScale(canvas));
                converted.translate(canvas.getViewport().getViewLocation().negate());
                event.x = converted.x;
                event.y = converted.y;
            }
        }
        return newTip;
    }

    @Override
    public void showToolTip(IBranchGraphElement element, MouseEvent event) {
        if (this.graphElement == null || !this.graphElement.equals(element)) {
            this.graphElement = element;
            if (this.tip != null) {
                this.tip.hide();
            }
        }
        if (this.enabled && this.graphElement != null) {
            this.tip = this.createTip(this.graphElement, event);
            if (this.tip != null) {
                this.tip.show(new org.eclipse.swt.graphics.Point(event.x + 5, event.y + 5));
            }
        }
    }

    @Override
    public void hideToolTip(IBranchGraphElement element) {
        if (this.graphElement != null && this.graphElement.equals(element) && this.tip != null) {
            this.tip.hide();
        }
    }

    @Override
    public void dispose() {
        P4BranchGraphPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    private void updateEnablement() {
        this.enabled = P4BranchGraphPlugin.getDefault().getPreferenceStore().getBoolean("SHOW_TOOLTIPS");
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("SHOW_TOOLTIPS".equals(event.getProperty())) {
            this.updateEnablement();
        }
    }
}

