/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.policies;

import com.perforce.team.core.mergequest.model.Branch;
import com.perforce.team.core.mergequest.model.IBranchGraph;
import com.perforce.team.core.mergequest.model.registry.BranchType;
import com.perforce.team.ui.mergequest.commands.BranchConstraintCommand;
import com.perforce.team.ui.mergequest.commands.BranchCreateCommand;
import com.perforce.team.ui.mergequest.figures.ColoredResizeHandle;
import com.perforce.team.ui.mergequest.parts.BranchEditPart;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Handle;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.handles.NonResizableHandleKit;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;

public class GraphXYLayoutEditPolicy
extends XYLayoutEditPolicy {
    private IBranchGraph graph;

    public GraphXYLayoutEditPolicy(IBranchGraph graph) {
        this.graph = graph;
    }

    protected Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
        if (child instanceof BranchEditPart && constraint instanceof Rectangle) {
            return new BranchConstraintCommand((Branch)child.getModel(), request, (Rectangle)constraint);
        }
        return super.createChangeConstraintCommand(request, child, constraint);
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        ResizableEditPolicy policy = null;
        if (child instanceof BranchEditPart) {
            policy = new ResizableEditPolicy(){

                protected List<Handle> createSelectionHandles() {
                    ArrayList<Handle> handles = new ArrayList<Handle>();
                    NonResizableHandleKit.addMoveHandle((GraphicalEditPart)this.getHost(), handles);
                    ColoredResizeHandle.addCornerHandles(this.getHost(), handles);
                    for (Object e : handles) {
                        ((IFigure)e).setForegroundColor(ColorConstants.gray);
                    }
                    return handles;
                }
            };
        }
        return policy;
    }

    protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
        return null;
    }

    protected Command getCreateCommand(CreateRequest request) {
        BranchCreateCommand command = null;
        Object newObject = request.getNewObjectType();
        if (newObject instanceof BranchType) {
            Rectangle location = (Rectangle)this.getConstraintFor(request);
            command = new BranchCreateCommand((BranchType)newObject, this.graph, location);
        }
        return command;
    }
}

