/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.parts;

import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.mergequest.model.IBranchGraphElement;
import com.perforce.team.ui.mergequest.tooltip.IToolTipManager;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;

public class ToolTipHelper {
    private AbstractGraphicalEditPart part;
    protected MouseMotionListener mouseListener = new MouseMotionListener(){

        public void mouseMoved(MouseEvent me) {
        }

        public void mouseHover(MouseEvent me) {
            ToolTipHelper.this.showToolTip(me);
        }

        public void mouseExited(MouseEvent me) {
            ToolTipHelper.this.hideToolTip();
        }

        public void mouseEntered(MouseEvent me) {
        }

        public void mouseDragged(MouseEvent me) {
        }
    };

    public ToolTipHelper(AbstractGraphicalEditPart part) {
        this.part = part;
    }

    protected void showToolTip(MouseEvent event) {
        IToolTipManager manager;
        IBranchGraphElement element = (IBranchGraphElement)P4CoreUtils.convert((Object)this.part, IBranchGraphElement.class);
        if (element != null && (manager = (IToolTipManager)P4CoreUtils.convert((Object)this.part.getViewer(), IToolTipManager.class)) != null) {
            manager.showToolTip(element, event);
        }
    }

    protected void hideToolTip() {
        IToolTipManager manager;
        IBranchGraphElement element = (IBranchGraphElement)P4CoreUtils.convert((Object)this.part, IBranchGraphElement.class);
        if (element != null && (manager = (IToolTipManager)P4CoreUtils.convert((Object)this.part.getViewer(), IToolTipManager.class)) != null) {
            manager.hideToolTip(element);
        }
    }

    public void activate() {
        IFigure figure = this.part.getFigure();
        if (figure != null) {
            figure.addMouseMotionListener(this.mouseListener);
        }
    }

    public void deactivate() {
        IFigure figure = this.part.getFigure();
        if (figure != null) {
            figure.removeMouseMotionListener(this.mouseListener);
        }
    }
}

