/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.editor.palette;

import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.mergequest.editor.IBranchGraphEditor;
import com.perforce.team.ui.mergequest.editor.IBranchGraphPage;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.ui.views.palette.PalettePage;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.Page;

public class BranchGraphEditorPalettePage
extends Page
implements PalettePage,
IPage,
IAdaptable {
    private IBranchGraphEditor editor;
    private Composite displayArea;
    private StackLayout daLayout;
    private Map<IBranchGraphPage, PalettePage> pages;
    private IPageChangedListener pageListener = new IPageChangedListener(){

        public void pageChanged(PageChangedEvent event) {
            BranchGraphEditorPalettePage.this.updateActivePage();
        }
    };

    public BranchGraphEditorPalettePage(IBranchGraphEditor editor) {
        this.pages = new HashMap<IBranchGraphPage, PalettePage>();
        this.editor = editor;
    }

    public void createControl(Composite parent) {
        this.displayArea = new Composite(parent, 0);
        this.daLayout = new StackLayout();
        this.displayArea.setLayout((Layout)this.daLayout);
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.editor.addPageChangedListener(this.pageListener);
        this.updateActivePage();
    }

    private PalettePage createPalettePage(IBranchGraphPage page) {
        PalettePage palette = (PalettePage)P4CoreUtils.convert((Object)page, PalettePage.class);
        if (palette != null) {
            palette.createControl(this.displayArea);
            this.pages.put(page, palette);
        }
        return palette;
    }

    private void updateActivePage() {
        IBranchGraphPage active = this.editor.getActiveGraphPage();
        if (active != null) {
            PalettePage palette = this.pages.get(active);
            if (palette == null) {
                palette = this.createPalettePage(active);
            }
            this.daLayout.topControl = palette != null ? palette.getControl() : null;
            this.displayArea.layout(true, true);
        }
    }

    public void dispose() {
        this.editor.removePageChangedListener(this.pageListener);
        this.pages.clear();
        super.dispose();
    }

    public Control getControl() {
        return this.displayArea;
    }

    public void setFocus() {
        this.displayArea.setFocus();
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public boolean isDisposed() {
        return !P4UIUtils.okToUse((Widget)this.displayArea);
    }
}

