/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.editor;

import com.perforce.team.core.ConnectionParameters;
import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.mergequest.builder.IBranchGraphBuilder;
import com.perforce.team.core.mergequest.model.BranchGraph;
import com.perforce.team.core.mergequest.model.BranchGraphContainer;
import com.perforce.team.core.mergequest.model.IBranchGraph;
import com.perforce.team.core.mergequest.model.IBranchGraphContainer;
import com.perforce.team.core.mergequest.processor.InterchangesProcessor;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4ConnectionListener;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.P4Workspace;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.mergequest.P4BranchGraphPlugin;
import com.perforce.team.ui.mergequest.PreferenceBranchGraphBuilder;
import com.perforce.team.ui.mergequest.ReorderGraphDialog;
import com.perforce.team.ui.mergequest.editor.BranchGraphPage;
import com.perforce.team.ui.mergequest.editor.BranchGraphToolkit;
import com.perforce.team.ui.mergequest.editor.IBranchGraphEditor;
import com.perforce.team.ui.mergequest.editor.IBranchGraphPage;
import com.perforce.team.ui.mergequest.editor.Messages;
import com.perforce.team.ui.mergequest.editor.actions.GraphActionRegistry;
import com.perforce.team.ui.mergequest.editor.outline.BranchGraphOutlinePage;
import com.perforce.team.ui.mergequest.editor.palette.BranchGraphEditorPalettePage;
import com.perforce.team.ui.mergequest.wizards.io.ExportBranchGraphWizard;
import com.perforce.team.ui.mergequest.wizards.io.ImportBranchGraphWizard;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.views.palette.PalettePage;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.editor.SharedHeaderFormEditor;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class BranchGraphEditor
extends SharedHeaderFormEditor
implements IBranchGraphEditor,
IP4ConnectionListener {
    public static final String ID = "com.perforce.team.ui.editors.mergequest";
    private static final String[] ZOOM_LEVELS = new String[]{"50%", "66%", "75%", "100%", "125%", "150%"};
    private IP4Connection connection;
    private IBranchGraphContainer graphContainer;
    private IBranchGraphBuilder builder;
    private Action addAction;
    private Action deleteAction;
    private Action renameAction;
    private Action reorderAction;
    private Action importAction;
    private Action exportAction;
    private Action gridAction;
    private Action refreshAction;
    private Action zoomAction;
    private IPropertyChangeListener prefListener;
    private GraphActionRegistry registry;
    private BranchGraphEditorPalettePage palettePage;
    private BranchGraphOutlinePage outlinePage;

    public void dispose() {
        if (this.prefListener != null) {
            P4BranchGraphPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.prefListener);
        }
        P4Workspace.getWorkspace().removeConnectionListener((IP4ConnectionListener)this);
        super.dispose();
    }

    private void importGraphs() {
        ImportBranchGraphWizard wizard = new ImportBranchGraphWizard(this.connection);
        WizardDialog dialog = new WizardDialog(this.getContainer().getShell(), (IWizard)wizard);
        if (dialog.open() == 0) {
            IBranchGraph[] graphs = wizard.getSelected();
            int lastIndex = -1;
            boolean imported = false;
            IBranchGraph[] iBranchGraphArray = graphs;
            int n = graphs.length;
            int n2 = 0;
            while (n2 < n) {
                IBranchGraph graph = iBranchGraphArray[n2];
                if ((graph = this.graphContainer.importGraph(graph)) != null) {
                    graph.setConnection(this.connection);
                    imported = true;
                    lastIndex = this.createGraphPage(graph);
                }
                ++n2;
            }
            if (imported) {
                this.persist();
            }
            if (lastIndex >= 0) {
                this.setActivePage(lastIndex);
            }
        }
    }

    private void exportGraphs() {
        ExportBranchGraphWizard wizard = new ExportBranchGraphWizard(this.graphContainer);
        WizardDialog dialog = new WizardDialog(this.getContainer().getShell(), (IWizard)wizard);
        dialog.open();
    }

    private void addNewPage() {
        InputDialog dialog = new InputDialog(this.getContainer().getShell(), Messages.BranchGraphEditor_EnterGraphName, Messages.BranchGraphEditor_GraphName, null, new IInputValidator(){

            public String isValid(String newText) {
                String message = null;
                if ((newText = newText.trim()).length() == 0) {
                    message = "";
                } else if (BranchGraphEditor.this.graphContainer.getGraphByName(newText) != null) {
                    message = Messages.BranchGraphEditor_GraphWithNameExists;
                }
                return message;
            }
        });
        if (dialog.open() == 0) {
            int index;
            String graphName = dialog.getValue();
            IBranchGraph graph = this.createGraph(graphName);
            if (this.graphContainer.add(graph)) {
                this.persist();
            }
            if ((index = this.createGraphPage(graph)) >= 0) {
                this.setActivePage(index);
            }
            this.updateTitle();
        }
    }

    private IBranchGraph createGraph(String name) {
        IBranchGraph graph = this.graphContainer.createGraph(null);
        graph.setName(name);
        graph.setConnection(this.connection);
        return graph;
    }

    private int createGraphPage(IBranchGraph graph) {
        int index = -1;
        BranchGraphPage page = new BranchGraphPage(this, graph, this.builder);
        try {
            index = this.addPage(page);
        }
        catch (PartInitException e) {
            PerforceProviderPlugin.logError((Throwable)e);
        }
        return index;
    }

    private void deleteCurrentPage() {
        IBranchGraph graph;
        IBranchGraphPage page = this.getActiveGraphPage();
        if (page != null && (graph = page.getGraph()) != null && P4ConnectionManager.getManager().openConfirm(Messages.BranchGraphEditor_RemoveGraphTitle, MessageFormat.format(Messages.BranchGraphEditor_RemoveGraph, graph.getName()))) {
            this.removePage(this.getActivePage());
            this.graphContainer.remove(graph);
            this.persist();
            this.updateTitle();
        }
    }

    @Override
    public IBranchGraphPage getActiveGraphPage() {
        IFormPage page = this.getActivePageInstance();
        if (page instanceof IBranchGraphPage) {
            return (IBranchGraphPage)page;
        }
        return null;
    }

    public IBranchGraph getActiveGraph() {
        IBranchGraphPage page = this.getActiveGraphPage();
        return page != null ? page.getGraph() : null;
    }

    private void updateActionPreferences() {
        this.gridAction.setChecked(P4BranchGraphPlugin.getDefault().getPreferenceStore().getBoolean("SHOW_GRID"));
    }

    private void createActions() {
        this.prefListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("SHOW_GRID".equals(event.getProperty())) {
                    BranchGraphEditor.this.updateActionPreferences();
                }
            }
        };
        this.addAction = new Action(Messages.BranchGraphEditor_AddGraph, P4BranchGraphPlugin.getImageDescriptor("icons/page_add.png")){

            public void run() {
                BranchGraphEditor.this.addNewPage();
            }
        };
        this.deleteAction = new Action(Messages.BranchGraphEditor_DeleteGraph, P4BranchGraphPlugin.getImageDescriptor("icons/page_delete.png")){

            public void run() {
                BranchGraphEditor.this.deleteCurrentPage();
            }
        };
        this.renameAction = new Action(Messages.BranchGraphEditor_RenameGraph){

            public void run() {
                BranchGraphEditor.this.renameCurrentPage();
            }
        };
        this.reorderAction = new Action(Messages.BranchGraphEditor_ReorderPages){

            public void run() {
                BranchGraphEditor.this.reorderPages();
            }
        };
        this.importAction = new Action(Messages.BranchGraphEditor_ImportGraphs, P4BranchGraphPlugin.getImageDescriptor("icons/import.png")){

            public void run() {
                BranchGraphEditor.this.importGraphs();
            }
        };
        this.exportAction = new Action(Messages.BranchGraphEditor_ExportGraphs, P4BranchGraphPlugin.getImageDescriptor("icons/export.png")){

            public void run() {
                BranchGraphEditor.this.exportGraphs();
            }
        };
        this.gridAction = new Action(Messages.BranchGraphEditor_ShowGridLines, 2){

            public void run() {
                P4BranchGraphPlugin.getDefault().getPreferenceStore().setValue("SHOW_GRID", this.isChecked());
            }
        };
        this.gridAction.setImageDescriptor(P4BranchGraphPlugin.getImageDescriptor("icons/grid.png"));
        this.gridAction.setChecked(P4BranchGraphPlugin.getDefault().getPreferenceStore().getBoolean("SHOW_GRID"));
        this.refreshAction = new Action(Messages.BranchGraphEditor_RefreshGraph, PerforceUIPlugin.getDescriptor((String)"normal/refresh.png")){

            public void run() {
                IBranchGraphPage page = BranchGraphEditor.this.getActiveGraphPage();
                if (page != null) {
                    page.refresh();
                }
            }
        };
        this.zoomAction = new Action(Messages.BranchGraphEditor_SetZoomLevel, 4){

            public void runWithEvent(Event event) {
                if (event.widget instanceof ToolItem) {
                    BranchGraphEditor.this.showZoomMenu((ToolItem)event.widget);
                }
            }
        };
        this.zoomAction.setImageDescriptor(P4BranchGraphPlugin.getImageDescriptor("icons/zoom.png"));
        P4BranchGraphPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.prefListener);
    }

    private void showZoomMenu(ToolItem item) {
        Menu menu = new Menu((Control)item.getParent());
        String currentValue = P4BranchGraphPlugin.getDefault().getPreferenceStore().getString("ZOOM_LEVEL");
        String[] stringArray = ZOOM_LEVELS;
        int n = ZOOM_LEVELS.length;
        int n2 = 0;
        while (n2 < n) {
            final String level = stringArray[n2];
            MenuItem menuItem = new MenuItem(menu, 32);
            menuItem.setText(level);
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    P4BranchGraphPlugin.getDefault().getPreferenceStore().setValue("ZOOM_LEVEL", level);
                }
            });
            if (currentValue.equals(level)) {
                menuItem.setSelection(true);
            }
            ++n2;
        }
        Rectangle bounds = item.getBounds();
        Point location = item.getParent().toDisplay(bounds.x, bounds.y + bounds.height);
        menu.setLocation(location);
        menu.setVisible(true);
    }

    private void reorderPages() {
        Object[] newOrder;
        IBranchGraph current = this.getActiveGraph();
        ArrayList<IBranchGraph> currentOrder = new ArrayList<IBranchGraph>();
        for (Object page : this.pages) {
            if (!(page instanceof IBranchGraphPage)) continue;
            currentOrder.add(((IBranchGraphPage)page).getGraph());
        }
        Object[] ordered = currentOrder.toArray(new BranchGraph[currentOrder.size()]);
        ReorderGraphDialog reorder = new ReorderGraphDialog(this.getContainer().getShell(), this.graphContainer.getGraphs());
        if (reorder.open() == 0 && ordered.length == (newOrder = reorder.getOrder()).length && !Arrays.equals(ordered, newOrder)) {
            this.graphContainer.setGraphs((IBranchGraph[])newOrder);
            this.persist();
            while (this.getPageCount() > 0) {
                this.removePage(this.getPageCount() - 1);
            }
            int select = 0;
            Object[] objectArray = newOrder;
            int n = newOrder.length;
            int n2 = 0;
            while (n2 < n) {
                Object graph = objectArray[n2];
                int index = this.createGraphPage((IBranchGraph)graph);
                if (graph.equals((Object)current)) {
                    select = index;
                }
                ++n2;
            }
            this.setActivePage(select);
        }
    }

    private void renameCurrentPage() {
        String newName;
        IBranchGraphPage page = this.getActiveGraphPage();
        if (page == null) {
            return;
        }
        IBranchGraph graph = page.getGraph();
        final String currentName = graph.getName();
        InputDialog dialog = new InputDialog(this.getContainer().getShell(), Messages.BranchGraphEditor_RenameBranchGraph, Messages.BranchGraphEditor_GraphName, currentName, new IInputValidator(){

            public String isValid(String newText) {
                String message = null;
                newText = newText.trim();
                if (message == null && newText.length() == 0) {
                    message = Messages.BranchGraphEditor_EnterName;
                }
                if (message == null && !currentName.equals(newText) && BranchGraphEditor.this.graphContainer.getGraphByName(newText) != null) {
                    message = MessageFormat.format(Messages.BranchGraphEditor_GraphWithNameExists, newText);
                }
                return message;
            }
        });
        if (dialog.open() == 0 && graph.setName(newName = dialog.getValue().trim())) {
            this.setPageText(this.getCurrentPage(), newName);
            this.persist();
        }
    }

    protected void createHeaderContents(IManagedForm headerForm) {
        this.createActions();
        String prefix = Messages.BranchGraphEditor_BranchGraph;
        Image image = P4BranchGraphPlugin.getImageDescriptor("icons/branchgraph_editor.png").createImage();
        Form form = headerForm.getForm().getForm();
        P4UIUtils.registerDisposal((Widget)form, (Resource)image);
        form.setImage(image);
        IToolBarManager manager = form.getToolBarManager();
        manager.add((IAction)this.zoomAction);
        manager.add((IAction)this.refreshAction);
        manager.add((IAction)this.gridAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.addAction);
        manager.add((IAction)this.deleteAction);
        manager.add((IAction)this.importAction);
        manager.add((IAction)this.exportAction);
        manager.update(true);
        form.setText(MessageFormat.format(Messages.BranchGraphEditor_Title, prefix, this.connection.getParameters().getPort()));
        this.getToolkit().decorateFormHeading(form);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.connection = (IP4Connection)P4CoreUtils.convert((Object)input, IP4Connection.class);
        if (this.connection == null) {
            throw new PartInitException(Messages.BranchGraphEditor_InputNotAdapted);
        }
        super.init(site, input);
        this.setPartName(input.getName());
        this.builder = new PreferenceBranchGraphBuilder(P4BranchGraphPlugin.getDefault().getPreferenceStore(), this.connection);
        try {
            this.graphContainer = this.builder.load();
        }
        catch (IOException e) {
            this.graphContainer = new BranchGraphContainer();
            PerforceProviderPlugin.logError((Throwable)e);
        }
        this.registry = new GraphActionRegistry(this);
        this.registry.loadActions();
        P4Workspace.getWorkspace().addConnectionListener((IP4ConnectionListener)this);
    }

    public GraphActionRegistry getRegistry() {
        return this.registry;
    }

    private BranchGraphOutlinePage createOutlinePage() {
        BranchGraphOutlinePage newOutlinePage = new BranchGraphOutlinePage(this.connection, this);
        return newOutlinePage;
    }

    private BranchGraphEditorPalettePage createPalettePage() {
        BranchGraphEditorPalettePage newPalletePage = new BranchGraphEditorPalettePage(this);
        return newPalletePage;
    }

    public Object getAdapter(Class adapter) {
        IBranchGraphPage page;
        if (adapter == IP4Connection.class || adapter == IP4Resource.class) {
            return this.connection;
        }
        if (ActionRegistry.class == adapter) {
            return this.registry.getAdapter(adapter);
        }
        if (adapter == IContentOutlinePage.class) {
            if (this.outlinePage == null || this.outlinePage.isDisposed()) {
                this.outlinePage = this.createOutlinePage();
            }
            return this.outlinePage;
        }
        if (adapter == PalettePage.class) {
            if (this.palettePage == null || this.palettePage.isDisposed()) {
                this.palettePage = this.createPalettePage();
            }
            return this.palettePage;
        }
        Object adapted = super.getAdapter(adapter);
        if (adapted == null && (page = this.getActiveGraphPage()) != null) {
            adapted = page.getAdapter(adapter);
        }
        return adapted;
    }

    private void updateTitle() {
        if (this.getPageCount() > 1) {
            String title = MessageFormat.format(Messages.BranchGraphEditor_Title, this.getEditorInput().getName(), this.getPageCount());
            this.setPartName(title);
        } else {
            this.setPartName(this.getEditorInput().getName());
        }
    }

    public void removePage(int pageIndex) {
        super.removePage(pageIndex);
        this.hookMenu();
    }

    private void hookMenu() {
        Menu menu = this.getContainer().getMenu();
        if (!P4UIUtils.okToUse((Widget)menu)) {
            MenuManager manager = new MenuManager();
            menu = manager.createContextMenu((Control)this.getContainer());
            manager.setRemoveAllWhenShown(true);
            this.getContainer().setMenu(menu);
            manager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    manager.add((IAction)BranchGraphEditor.this.addAction);
                    manager.add((IAction)BranchGraphEditor.this.deleteAction);
                    manager.add((IAction)BranchGraphEditor.this.renameAction);
                    manager.add((IAction)BranchGraphEditor.this.reorderAction);
                    manager.add((IAction)BranchGraphEditor.this.importAction);
                    manager.add((IAction)BranchGraphEditor.this.exportAction);
                    manager.add((IAction)BranchGraphEditor.this.gridAction);
                }
            });
        }
    }

    protected void addPages() {
        IBranchGraph[] graphs = this.graphContainer.getGraphs();
        if (graphs.length > 0) {
            IBranchGraph[] iBranchGraphArray = graphs;
            int n = graphs.length;
            int n2 = 0;
            while (n2 < n) {
                IBranchGraph graph = iBranchGraphArray[n2];
                graph.setConnection(this.connection);
                this.createGraphPage(graph);
                ++n2;
            }
        } else {
            IBranchGraph graph = this.createGraph("Page 1");
            this.graphContainer.add(graph);
            this.createGraphPage(graph);
        }
        this.updateTitle();
        this.hookMenu();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    @Override
    public InterchangesProcessor getProcessor() {
        IBranchGraphPage page = this.getActiveGraphPage();
        if (page != null) {
            return page.getProcessor();
        }
        return null;
    }

    public void persist() {
        try {
            this.builder.persist(this.graphContainer);
        }
        catch (IOException e) {
            PerforceUIPlugin.syncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    String message = MessageFormat.format(Messages.BranchGraphEditor_SaveErrorMessage, e.getClass().getCanonicalName(), e.getLocalizedMessage());
                    P4ConnectionManager.getManager().openError(P4UIUtils.getDialogShell(), Messages.BranchGraphEditor_SaveErrorTitle, message);
                }
            });
        }
    }

    public void connectionAdded(IP4Connection connection) {
    }

    public void connectionChanged(IP4Connection connection, ConnectionParameters previousParams) {
        if (previousParams.equals((Object)this.connection.getParameters())) {
            this.connection = connection;
        }
    }

    public void connectionRemovalRequested(ConnectionParameters params) {
    }

    public void connectionRemoved(IP4Connection connection) {
        if (this.connection.equals(connection)) {
            PerforceUIPlugin.asyncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (P4UIUtils.okToUse((Widget)BranchGraphEditor.this.getContainer())) {
                        BranchGraphEditor.this.close(false);
                    }
                }
            });
        }
    }

    public IP4Connection getConnection() {
        return this.connection;
    }

    protected FormToolkit createToolkit(Display display) {
        return new BranchGraphToolkit(display);
    }
}

