/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.commands;

import com.perforce.team.core.mergequest.model.Branch;
import com.perforce.team.core.mergequest.model.IBranchGraph;
import com.perforce.team.core.mergequest.model.IBranchGraphElement;
import com.perforce.team.core.mergequest.model.registry.BranchType;
import com.perforce.team.ui.mergequest.actions.BranchCreateAction;
import com.perforce.team.ui.mergequest.commands.BranchDeleteCommand;
import com.perforce.team.ui.mergequest.commands.Messages;
import java.text.MessageFormat;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.graphics.Point;

public class BranchCreateCommand
extends Command {
    private BranchType type;
    private IBranchGraph graph;
    private Branch created = null;
    private Rectangle location;

    public BranchCreateCommand(BranchType type, IBranchGraph graph, Rectangle location) {
        this.type = type;
        this.graph = graph;
        this.location = location;
    }

    private void resetDefaultLabel() {
        this.setLabel(Messages.BranchCreateCommand_DefaultLabel);
    }

    public boolean canExecute() {
        return this.type != null && this.graph != null && this.location != null && this.created == null;
    }

    public boolean canUndo() {
        return this.created != null;
    }

    public void redo() {
        if (this.created != null && this.graph != null) {
            this.graph.add((IBranchGraphElement)this.created);
        }
    }

    public void undo() {
        BranchDeleteCommand delete = new BranchDeleteCommand(this.graph, this.created);
        delete.execute();
    }

    public void execute() {
        BranchCreateAction create = new BranchCreateAction(this.graph, this.type, new Point(this.location.x, this.location.y));
        create.run();
        this.created = create.getCreated();
        if (this.created != null) {
            this.setLabel(MessageFormat.format(Messages.BranchCreateCommand_BranchNameLabel, this.created.getName()));
        } else {
            this.resetDefaultLabel();
        }
    }
}

