/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.actions;

import com.perforce.team.core.mergequest.model.Branch;
import com.perforce.team.core.mergequest.model.IBranchGraph;
import com.perforce.team.core.mergequest.model.IBranchGraphElement;
import com.perforce.team.core.mergequest.model.registry.BranchType;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.mergequest.wizards.branch.BranchDescriptor;
import com.perforce.team.ui.mergequest.wizards.branch.NewBranchWizard;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Point;

public class BranchCreateAction
extends Action {
    private IBranchGraph graph;
    private BranchType type;
    private Point location;
    private Branch created;

    public BranchCreateAction(IBranchGraph graph, BranchType type, Point location) {
        this.graph = graph;
        this.type = type;
        this.location = location;
    }

    public Branch getCreated() {
        return this.created;
    }

    public void run() {
        BranchDescriptor descriptor = new BranchDescriptor();
        descriptor.setType(this.type);
        NewBranchWizard wizard = new NewBranchWizard(this.graph, descriptor);
        WizardDialog dialog = new WizardDialog(P4UIUtils.getDialogShell(), (IWizard)wizard);
        if (dialog.open() == 0) {
            Branch branch = this.graph.createBranch(null);
            branch.setType(wizard.getBranchType().getType());
            branch.setName(wizard.getBranchName());
            branch.setLocation(this.location.x, this.location.y);
            if (this.graph.add((IBranchGraphElement)branch)) {
                this.created = branch;
                IAction[] iActionArray = wizard.getPostFinishActions();
                int n = iActionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IAction action = iActionArray[n2];
                    action.run();
                    ++n2;
                }
            }
        }
    }
}

