/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.patch.wizard;

import com.perforce.team.ui.decorator.PerforceDecorator;
import com.perforce.team.ui.patch.P4PatchUiPlugin;
import com.perforce.team.ui.patch.wizard.Messages;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class WorkspaceDialog
extends TitleAreaDialog {
    public static final String DIALOG_SETTINGS = "WorkspaceDialog";
    private TreeViewer viewer;
    private Text nameText;
    private IContainer parent;
    private String name;
    private String initialMessage = null;
    private String initialTitle = null;

    public WorkspaceDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(67696);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings wizardSection = null;
        IDialogSettings settings = P4PatchUiPlugin.getDefault().getDialogSettings();
        if (settings != null && (wizardSection = settings.getSection(DIALOG_SETTINGS)) == null) {
            wizardSection = settings.addNewSection(DIALOG_SETTINGS);
        }
        return wizardSection;
    }

    public void setInitialMessage(String message) {
        this.initialMessage = message;
    }

    public void setInitialTitle(String title) {
        this.initialTitle = title;
    }

    public IFile getFile() {
        if (this.parent != null && this.name != null) {
            return this.parent.getFile((IPath)new Path(this.name));
        }
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        Composite displayArea = new Composite(c, 0);
        displayArea.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        displayArea.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.viewer = new TreeViewer(displayArea, 68356);
        this.viewer.getTree().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        final ArrayList<IProject> projects = new ArrayList<IProject>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isAccessible()) {
                projects.add(project);
            }
            ++n2;
        }
        this.viewer.setContentProvider((IContentProvider)new WorkbenchContentProvider(){

            public Object[] getElements(Object element) {
                return projects.toArray();
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), (ILabelDecorator)new PerforceDecorator(true){

            public String getName() {
                return String.valueOf(WorkspaceDialog.class.getSimpleName()) + ":" + super.getName();
            }
        }));
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selection = ((IStructuredSelection)WorkspaceDialog.this.viewer.getSelection()).getFirstElement();
                if (selection instanceof IFile) {
                    WorkspaceDialog.this.nameText.setText(((IFile)selection).getName());
                }
                WorkspaceDialog.this.validate();
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object selection = ((IStructuredSelection)WorkspaceDialog.this.viewer.getSelection()).getFirstElement();
                if (selection instanceof IFile) {
                    WorkspaceDialog.this.okPressed();
                }
            }
        });
        this.viewer.setComparator((ViewerComparator)new ResourceComparator(1));
        this.viewer.setInput(projects);
        Composite nameArea = new Composite(displayArea, 0);
        nameArea.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).equalWidth(false).create());
        nameArea.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        new Label(nameArea, 0).setText(Messages.WorkspaceDialog_FileName);
        this.nameText = new Text(nameArea, 2052);
        this.nameText.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).create());
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WorkspaceDialog.this.validate();
            }
        });
        this.validate();
        if (this.initialMessage != null) {
            this.setMessage(this.initialMessage);
        }
        if (this.initialTitle != null) {
            this.setTitle(this.initialTitle);
        }
        return c;
    }

    private void validate() {
        Object selection = ((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
        this.parent = selection instanceof IFile ? ((IFile)selection).getParent() : (selection instanceof IContainer ? (IContainer)selection : null);
        this.name = this.nameText.getText();
        String message = null;
        if (message == null && this.name.length() == 0) {
            message = Messages.WorkspaceDialog_MustSpecifyFileName;
        }
        if (message == null && !Path.EMPTY.isValidSegment(this.name)) {
            message = Messages.WorkspaceDialog_FileNameInvalid;
        }
        if (message == null && this.parent == null) {
            message = Messages.WorkspaceDialog_SelectFolder;
        }
    }
}

