/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.patch.wizard;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Folder;
import com.perforce.team.core.p4java.IP4Job;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceContentProvider;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.changelists.ChangelistDecorator;
import com.perforce.team.ui.changelists.ChangelistLabelProvider;
import com.perforce.team.ui.changelists.DecoratedChangelistLabelProvider;
import com.perforce.team.ui.changelists.StyledChangelistLabelProvider;
import com.perforce.team.ui.patch.wizard.Messages;
import com.perforce.team.ui.pending.PendingSorter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;

public class PendingViewer
implements ICheckStateListener {
    private P4Collection collection;
    private CheckboxTreeViewer viewer;

    public PendingViewer(P4Collection collection) {
        this.collection = collection;
    }

    private IP4Connection[] getConnections() {
        return new P4Event(P4Event.EventType.REFRESHED, this.collection).getCommonConnections();
    }

    public void createControl(Composite parent, Runnable callback) {
        this.viewer = new CheckboxTreeViewer(parent, 268503812);
        this.viewer.getTree().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).hint(-1, 80).create());
        this.viewer.setContentProvider((IContentProvider)new PerforceContentProvider((StructuredViewer)this.viewer, true));
        ChangelistDecorator decorator = new ChangelistDecorator(true);
        ChangelistLabelProvider labelProvider = new ChangelistLabelProvider(true);
        StyledChangelistLabelProvider styledLabelProvider = new StyledChangelistLabelProvider((ILabelProvider)labelProvider){

            protected void addCounter(IP4Changelist list, StyledString styled) {
            }
        };
        DecoratedChangelistLabelProvider decorated = new DecoratedChangelistLabelProvider((ILabelProvider)labelProvider, (DelegatingStyledCellLabelProvider.IStyledLabelProvider)styledLabelProvider, (ILabelDecorator)decorator);
        decorated.setAddDecorations(false);
        this.viewer.setLabelProvider((IBaseLabelProvider)decorated);
        this.viewer.setUseHashlookup(true);
        this.viewer.setSorter((ViewerSorter)new PendingSorter());
        this.viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return !(element instanceof IP4Job);
            }
        });
        this.viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IP4File) {
                    return ((IP4File)element).getLocalFileForLocation() != null;
                }
                return true;
            }
        });
        this.viewer.addCheckStateListener((ICheckStateListener)this);
        this.viewer.setAutoExpandLevel(2);
        this.loadChangelists(callback);
    }

    public IFile[] getSelectedResources() {
        ArrayList<IFile> resources = new ArrayList<IFile>();
        Object[] objectArray = this.viewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file;
            Object element = objectArray[n2];
            if (element instanceof IP4File && (file = ((IP4File)element).getLocalFileForLocation()) != null) {
                resources.add(file);
            }
            ++n2;
        }
        return resources.toArray(new IFile[resources.size()]);
    }

    private void processFolder(IP4Folder folder, Map<IFile, IP4File> files, List<IP4File> checked) {
        IPath containerPath = null;
        IPath filePath = null;
        IContainer[] iContainerArray = folder.getLocalContainers();
        int n = iContainerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContainer container = iContainerArray[n2];
            containerPath = container.getLocation();
            if (containerPath != null) {
                for (Map.Entry<IFile, IP4File> entry : files.entrySet()) {
                    IFile file = entry.getKey();
                    filePath = file.getLocation();
                    if (filePath == null || !containerPath.isPrefixOf(filePath)) continue;
                    checked.add(entry.getValue());
                }
            }
            ++n2;
        }
    }

    private void loadChangelists(final Runnable callback) {
        this.viewer.setInput((Object)new PerforceContentProvider.Loading());
        P4Runner.schedule((IP4Runnable)new P4Runnable(){

            public String getTitle() {
                return Messages.PendingViewer_LoadingChangelists;
            }

            public void run(IProgressMonitor monitor) {
                int n;
                IP4Connection[] connections = PendingViewer.this.getConnections();
                HashMap<IFile, IP4File> files = new HashMap<IFile, IP4File>();
                final ArrayList<IP4PendingChangelist> lists = new ArrayList<IP4PendingChangelist>();
                IP4Connection[] iP4ConnectionArray = connections;
                int n2 = connections.length;
                int n3 = 0;
                while (n3 < n2) {
                    IP4Connection connection = iP4ConnectionArray[n3];
                    IP4PendingChangelist[] iP4PendingChangelistArray = connection.getCachedPendingChangelists();
                    n = iP4PendingChangelistArray.length;
                    int n4 = 0;
                    while (n4 < n) {
                        IP4PendingChangelist list = iP4PendingChangelistArray[n4];
                        if (list.needsRefresh()) {
                            list.refresh();
                        }
                        boolean add = false;
                        IP4File[] iP4FileArray = list.getPendingFiles();
                        int n5 = iP4FileArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IP4File file = iP4FileArray[n6];
                            IFile localFile = file.getLocalFileForLocation();
                            if (localFile != null) {
                                add = true;
                                files.put(localFile, file);
                            }
                            ++n6;
                        }
                        if (add) {
                            lists.add(list);
                        }
                        if (monitor.isCanceled()) break;
                        ++n4;
                    }
                    if (monitor.isCanceled()) break;
                    ++n3;
                }
                if (monitor.isCanceled()) {
                    return;
                }
                final ArrayList<IP4File> checkedFiles = new ArrayList<IP4File>();
                IP4Resource[] iP4ResourceArray = PendingViewer.this.collection.members();
                int n7 = iP4ResourceArray.length;
                n2 = 0;
                while (n2 < n7) {
                    IP4Resource resource = iP4ResourceArray[n2];
                    if (monitor.isCanceled()) break;
                    if (resource instanceof IP4File) {
                        checkedFiles.add((IP4File)resource);
                    } else if (resource instanceof IP4PendingChangelist) {
                        IP4File[] iP4FileArray = ((IP4PendingChangelist)resource).getPendingFiles();
                        int n8 = iP4FileArray.length;
                        n = 0;
                        while (n < n8) {
                            IP4File file = iP4FileArray[n];
                            checkedFiles.add(file);
                            ++n;
                        }
                    } else if (resource instanceof IP4Folder) {
                        PendingViewer.this.processFolder((IP4Folder)resource, files, checkedFiles);
                    }
                    ++n2;
                }
                if (monitor.isCanceled()) {
                    return;
                }
                PerforceUIPlugin.asyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!P4UIUtils.okToUse((Viewer)PendingViewer.this.viewer)) {
                            return;
                        }
                        PendingViewer.this.viewer.setInput((Object)lists.toArray());
                        Object[] checked = checkedFiles.toArray();
                        PendingViewer.this.viewer.setCheckedElements(checked);
                        PendingViewer.this.updateCheckState(checked, true);
                        if (callback != null) {
                            callback.run();
                        }
                    }
                });
            }
        });
    }

    public CheckboxTreeViewer getViewer() {
        return this.viewer;
    }

    private void updateCheckState(Object[] elements, boolean state) {
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            this.updateCheckState(element, state);
            ++n2;
        }
    }

    private void updateCheckState(Object element, boolean state) {
        if (element instanceof IP4PendingChangelist) {
            this.viewer.setSubtreeChecked(element, state);
            this.viewer.setGrayed(element, false);
        } else if (element instanceof IP4File) {
            IP4PendingChangelist parent = ((IP4File)element).getChangelist();
            if (parent == null) {
                PerforceProviderPlugin.logError((String)MessageFormat.format("Error: {0} is not in any pending change list.", ((IP4File)element).getName()));
                return;
            }
            boolean checked = false;
            boolean all = true;
            IP4File[] iP4FileArray = parent.getPendingFiles();
            int n = iP4FileArray.length;
            int n2 = 0;
            while (n2 < n) {
                IP4File file = iP4FileArray[n2];
                if (this.viewer.testFindItem((Object)file) != null) {
                    if (this.viewer.getChecked((Object)file)) {
                        checked = true;
                    } else {
                        all = false;
                    }
                }
                ++n2;
            }
            if (all) {
                this.viewer.setChecked((Object)parent, true);
                this.viewer.setGrayed((Object)parent, false);
            } else {
                this.viewer.setGrayChecked((Object)parent, checked);
            }
        }
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        this.updateCheckState(event.getElement(), event.getChecked());
    }
}

