/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.python.timelapse;

import com.perforce.p4java.server.PerforceCharsets;
import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Revision;
import com.perforce.team.ui.python.timelapse.PythonUtils;
import com.perforce.team.ui.text.timelapse.IFilterNodeModel;
import com.perforce.team.ui.text.timelapse.NodeModel;
import com.perforce.team.ui.timelapse.IRevisionInputCache;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.Flags;
import org.eclipse.dltk.core.IBuffer;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.SourceRefElement;
import org.eclipse.dltk.ui.ScriptElementLabels;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;

public class PythonNodeModel
extends NodeModel
implements IFilterNodeModel {
    public static final String PYTHON_SUFFIX = ".py";
    public static final int PYTHON_SUFFIX_LENGTH = ".py".length();
    public static final String PYTHON_PREFIX = "P4_PYTHON_PREFIX";
    public static final String PYTHON_PREFIX_REGEX = "P4_PYTHON_PREFIX\\d+";
    public static final String PUBLIC = "PUBLIC";
    public static final String PROTECTED = "PROTECTED";
    public static final String PRIVATE = "PRIVATE";
    private Map<String, String> methodList = new TreeMap<String, String>();
    private List<IEditorInput> converted = new ArrayList<IEditorInput>();

    public PythonNodeModel(IP4Revision[] revisions, IRevisionInputCache inputCache) {
        super(revisions, inputCache);
    }

    public void clear() {
        super.clear();
        this.converted.clear();
    }

    public String getFilterKey(String filterLabel) {
        return this.methodList.get(filterLabel);
    }

    public Collection<String> getFilterLabels() {
        return this.methodList.keySet();
    }

    public IModelElement getPythonElement(IP4Revision revision, String id) {
        return (IModelElement)this.getElement(revision, id);
    }

    private static String getFileClassHandle(IModelElement element) {
        String handle = element.getHandleIdentifier();
        if (handle != null && element instanceof SourceRefElement) {
            SourceRefElement ref = (SourceRefElement)element;
            if (ref.occurrenceCount > 1) {
                handle = String.valueOf(handle) + "#" + ref.occurrenceCount;
            }
        }
        if (handle != null && handle.indexOf(PYTHON_PREFIX) != -1) {
            handle = handle.replaceAll(PYTHON_PREFIX_REGEX, "");
        }
        return handle;
    }

    public void findNodes(Object nodeInput, IP4Revision revision) {
        this.walkTree((IModelElement)nodeInput, revision);
    }

    private void walkTree(IModelElement node, IP4Revision revision) {
        try {
            IParent parent;
            ISourceReference reference;
            String content;
            String key = null;
            if (node != null) {
                key = PythonNodeModel.getFileClassHandle(node);
            }
            if (node instanceof IMethod) {
                IMethod method = (IMethod)node;
                String display = this.getMethodDisplay(method);
                this.methodList.put(display, key);
            }
            if (node instanceof ISourceReference && (content = (reference = (ISourceReference)node).getSource()) != null) {
                String visibility = "";
                if (node instanceof IMethod) {
                    int flags = ((IMethod)node).getFlags();
                    if (Flags.isPrivate((int)flags)) {
                        visibility = PRIVATE;
                    } else if (Flags.isProtected((int)flags)) {
                        visibility = PROTECTED;
                    } else if (Flags.isPublic((int)flags)) {
                        visibility = PUBLIC;
                    }
                }
                int hash = this.computeHash(String.valueOf(visibility) + content, P4CoreUtils.charsetForName((String)PerforceCharsets.getJavaCharsetName((String)revision.getCharset())));
                String key2 = null;
                if (key != null) {
                    key2 = node.getHandleIdentifier();
                }
                this.addRecord(hash, key, key2, node, revision);
            }
            if (node instanceof IParent && (parent = (IParent)node).hasChildren()) {
                IModelElement[] iModelElementArray = parent.getChildren();
                int n = iModelElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IModelElement child = iModelElementArray[n2];
                    this.walkTree(child, revision);
                    ++n2;
                }
            }
        }
        catch (ModelException e) {
            PerforceProviderPlugin.logError((Throwable)e);
        }
    }

    private String getMethodDisplay(IMethod method) {
        StringBuffer buffer = new StringBuffer();
        ScriptElementLabels.getDefault().getElementLabel((IModelElement)method, 257L, buffer);
        if (method instanceof SourceRefElement) {
            SourceRefElement element = (SourceRefElement)method;
            if (element.occurrenceCount > 1) {
                buffer.append(' ');
                buffer.append('#');
                buffer.append(element.occurrenceCount);
            }
        }
        return buffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object parseInput(IEditorInput input, IP4Revision revision) {
        if (PythonUtils.getProvider().getDocument((Object)input) == null) {
            try {
                PythonUtils.getProvider().connect((Object)input);
            }
            catch (CoreException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
        }
        ISourceModule module = PythonUtils.getWorkingCopy(input);
        if (!(input instanceof IStorageEditorInput) || this.converted.contains(input)) return module;
        BufferedReader reader = null;
        try {
            IStorage storage = ((IStorageEditorInput)input).getStorage();
            reader = new BufferedReader(new InputStreamReader(storage.getContents(), P4CoreUtils.charsetForName((String)PerforceCharsets.getJavaCharsetName((String)revision.getCharset()))));
            char[] buffer = new char[4096];
            StringBuilder content = new StringBuilder();
            int read = reader.read(buffer);
            while (read > 0) {
                content.append(buffer, 0, read);
                read = reader.read(buffer);
            }
            IBuffer moduleBuffer = module.getBuffer();
            if (moduleBuffer != null) {
                moduleBuffer.setContents(content.toString());
            }
            module.makeConsistent((IProgressMonitor)new NullProgressMonitor());
            this.converted.add(input);
        }
        catch (CoreException e) {
            PerforceProviderPlugin.logError((Throwable)e);
            if (reader == null) return module;
            try {
                reader.close();
                return module;
            }
            catch (IOException iOException) {}
            return module;
        }
        catch (IOException e) {
            try {
                PerforceProviderPlugin.logError((Throwable)e);
                if (reader == null) return module;
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                reader.close();
                return module;
            }
            catch (IOException iOException) {}
            return module;
        }
        if (reader == null) return module;
        try {
            reader.close();
            return module;
        }
        catch (IOException iOException) {}
        return module;
    }

    public String getHandle(Object element) {
        return PythonNodeModel.getPythonHandle(element);
    }

    public static String getPythonHandle(Object element) {
        return element instanceof IModelElement ? PythonNodeModel.getFileClassHandle((IModelElement)element) : null;
    }
}

