/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.search.results;

import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.editor.DepotFileEditorInput;
import com.perforce.team.ui.search.P4UiSearchPlugin;
import com.perforce.team.ui.search.results.IDepotMatch;
import com.perforce.team.ui.search.results.Messages;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.model.WorkbenchAdapter;

public class RevisionMatch
extends WorkbenchAdapter
implements IDepotMatch,
IAdaptable {
    private IP4File file;
    private int revision;

    public RevisionMatch(IP4File file, int revision) {
        this.file = file;
        this.revision = revision;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RevisionMatch) {
            RevisionMatch other = (RevisionMatch)obj;
            if (this.revision == other.revision && this.file.equals(other.file)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getDepotPath() {
        return String.valueOf(this.file.getRemotePath()) + "#" + this.revision;
    }

    public boolean isHead() {
        return this.revision == this.file.getHeadRevision();
    }

    public boolean isHave() {
        return this.revision == this.file.getHaveRevision();
    }

    public String getLabel(Object object) {
        return MessageFormat.format(Messages.RevisionMatch_Revision, Integer.toString(this.revision));
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        if (!this.isHave()) {
            return P4UiSearchPlugin.getDescriptor("icons/match_revision.png");
        }
        return P4UiSearchPlugin.getDescriptor("icons/match_revision_have.png");
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.getDepotPath();
    }

    @Override
    public IP4File getFile() {
        return this.file;
    }

    @Override
    public void openInEditor() {
        if (this.file == null) {
            return;
        }
        P4Runner.schedule((IP4Runnable)new P4Runnable(){

            public void run(IProgressMonitor monitor) {
                DepotFileEditorInput input = new DepotFileEditorInput(RevisionMatch.this.file, "#" + RevisionMatch.this.revision);
                P4UIUtils.openEditor((IStorageEditorInput)input, null);
            }
        });
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    public Object getAdapter(Class adapter) {
        IP4File adapted = null;
        if (IP4Resource.class == adapter || IP4File.class == adapter) {
            adapted = this.getFile();
        }
        return adapted;
    }
}

