/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.search.query;

import com.perforce.p4java.core.IFileLineMatch;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.search.query.QueryOptions;
import com.perforce.team.ui.search.query.Messages;
import com.perforce.team.ui.search.results.P4SearchResult;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;

public class P4SearchQuery
extends PlatformObject
implements ISearchQuery {
    private IP4Connection connection;
    private QueryOptions options;
    private P4SearchResult result;

    public P4SearchQuery(IP4Connection connection, QueryOptions options) {
        this.connection = connection;
        this.options = options;
    }

    public String getText() {
        return this.options.getPattern();
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public String getLabel() {
        return MessageFormat.format(Messages.P4SearchQuery_SearchingConnectionForPattern, this.connection.getParameters().getPort(), this.options.getPattern());
    }

    public ISearchResult getSearchResult() {
        if (this.result == null) {
            this.result = new P4SearchResult(this);
        }
        return this.result;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        P4SearchResult p4Result = (P4SearchResult)this.getSearchResult();
        p4Result.removeAll();
        IFileLineMatch[] matches = this.connection.searchDepot(this.options.getPattern(), this.options.createOptions(), this.options.getPaths());
        p4Result.addAll(matches);
        return Status.OK_STATUS;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IP4Connection.class || adapter == IP4Resource.class) {
            return this.connection;
        }
        return super.getAdapter(adapter);
    }
}

