/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.search.query;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.search.query.DepotPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.IDialogSettings;

public class P4SearchPageSettings {
    public static final String SELECTED_PATHS = "SELECTED_PATHS";
    public static final String ALL_PATHS = "ALL_PATHS";
    public static final String SELECTED_PROJECTS = "SELECTED_PROJECTS";
    public static final String SELECTED_TAB = "SELECTED_TAB";
    private IProject[] projects = new IProject[0];
    private IProject[] selectedProjects = new IProject[0];
    private Set<DepotPath> paths = new HashSet<DepotPath>();
    private DepotPath[] selectedPaths = new DepotPath[0];
    private IP4Connection connection;
    private IDialogSettings settings;
    private boolean created = false;
    private int tab = 0;

    public P4SearchPageSettings(IP4Connection connection, IDialogSettings parent) {
        this.connection = connection;
        this.settings = parent.getSection(this.connection.getName());
        if (this.settings == null) {
            this.settings = parent.addNewSection(this.connection.getName());
            this.created = true;
        }
    }

    public boolean isNewSettings() {
        return this.created;
    }

    public void load() {
        try {
            this.tab = this.settings.getInt(SELECTED_TAB);
        }
        catch (NumberFormatException nfe) {
            this.tab = 0;
        }
        this.paths.clear();
        this.addPaths(this.paths, this.settings.getArray(ALL_PATHS));
        HashSet<DepotPath> initialSelected = new HashSet<DepotPath>();
        this.addPaths(initialSelected, this.settings.getArray(SELECTED_PATHS));
        this.selectedPaths = initialSelected.toArray(new DepotPath[initialSelected.size()]);
        String[] projectNames = this.settings.getArray(SELECTED_PROJECTS);
        HashSet<String> selectedNames = new HashSet<String>();
        if (projectNames != null) {
            selectedNames.addAll(Arrays.asList(projectNames));
        }
        ArrayList<IProject> foundProjects = new ArrayList<IProject>();
        ArrayList<IProject> selected = new ArrayList<IProject>();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = root.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isAccessible() && this.connection.equals(P4ConnectionManager.getManager().getConnection(project, false))) {
                foundProjects.add(project);
                if (selectedNames.contains(project.getName())) {
                    selected.add(project);
                }
            }
            ++n2;
        }
        this.projects = foundProjects.toArray(new IProject[foundProjects.size()]);
        this.selectedProjects = selected.toArray(new IProject[selected.size()]);
        if (this.isNewSettings() && this.selectedProjects.length == 0) {
            this.selectedProjects = this.projects;
        }
    }

    private void addPaths(Set<DepotPath> depotPaths, String[] paths) {
        if (paths != null) {
            String[] stringArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                depotPaths.add(new DepotPath(path));
                ++n2;
            }
        }
    }

    private String[] getPaths(Collection<DepotPath> depotPaths) {
        String[] paths = new String[depotPaths.size()];
        int index = 0;
        for (DepotPath path : depotPaths) {
            paths[index] = path.getPath();
            ++index;
        }
        return paths;
    }

    public void save() {
        String[] projectNames = new String[this.selectedProjects.length];
        int i = 0;
        while (i < projectNames.length) {
            projectNames[i] = this.selectedProjects[i].getName();
            ++i;
        }
        this.settings.put(SELECTED_PROJECTS, projectNames);
        this.settings.put(SELECTED_PATHS, this.getPaths(Arrays.asList(this.selectedPaths)));
        this.settings.put(ALL_PATHS, this.getPaths(this.paths));
        this.settings.put(SELECTED_TAB, this.tab);
    }

    public void addPath(DepotPath path) {
        if (path != null) {
            this.paths.add(path);
        }
    }

    public void removePath(DepotPath path) {
        if (path != null) {
            this.paths.remove((Object)path);
        }
    }

    public void setSelectedPaths(DepotPath[] paths) {
        if (paths == null) {
            paths = new DepotPath[]{};
        }
        this.selectedPaths = paths;
    }

    public void setSelectedProjects(IProject[] projects) {
        if (projects == null) {
            projects = new IProject[]{};
        }
        this.selectedProjects = projects;
    }

    public IProject[] getSelectedProjects() {
        return this.selectedProjects;
    }

    public IProject[] getProjects() {
        return this.projects;
    }

    public DepotPath[] getPaths() {
        return this.paths.toArray(new DepotPath[this.paths.size()]);
    }

    public DepotPath[] getSelectedPaths() {
        return this.selectedPaths;
    }

    public int getSelectedTab() {
        return this.tab;
    }

    public void setSelectedTab(int tab) {
        this.tab = tab;
    }
}

