/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.folder.diff.viewer;

import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.folder.IP4DiffFile;
import com.perforce.team.core.p4java.IP4Revision;
import com.perforce.team.ui.DecorationLabel;
import com.perforce.team.ui.P4FormUIUtils;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.changelists.Folder;
import com.perforce.team.ui.folder.PerforceUiFolderPlugin;
import com.perforce.team.ui.folder.diff.editor.FolderDiffFilterArea;
import com.perforce.team.ui.folder.diff.editor.SubmittedChangelistWidget;
import com.perforce.team.ui.folder.diff.editor.input.IDiffConfiguration;
import com.perforce.team.ui.folder.diff.editor.input.IFolderDiffInput;
import com.perforce.team.ui.folder.diff.model.FileDiffContainer;
import com.perforce.team.ui.folder.diff.model.FileDiffElement;
import com.perforce.team.ui.folder.diff.model.GroupedDiffContainer;
import com.perforce.team.ui.folder.diff.viewer.DiffViewer;
import com.perforce.team.ui.folder.diff.viewer.Messages;
import java.text.MessageFormat;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public abstract class DiffArea {
    private Section section;
    private Composite area;
    private FolderDiffFilterArea filterArea;
    private DiffViewer viewer;
    private SubmittedChangelistWidget changelist;
    private CLabel headerLabel;
    private DecorationLabel uniqueCountLabel;
    private DiffArea pair = null;
    private boolean settingSelection = false;
    private int treeOffset = -1;
    private FileDiffContainer container = null;

    protected abstract DiffViewer createViewer();

    protected abstract GridLayout createAreaLayout();

    protected Composite getArea() {
        return this.area;
    }

    public void createControl(Composite parent, FormToolkit toolkit, IFolderDiffInput input, IDiffConfiguration config) {
        this.filterArea = new FolderDiffFilterArea(config.getOptions(), input.getConnection());
        this.filterArea.createControl(parent, toolkit);
        this.section = toolkit.createSection(parent, 8448);
        this.section.titleBarTextMarginWidth = 1;
        this.section.marginWidth = 0;
        this.section.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createHeaderLabel(this.section, toolkit);
        this.updateTitle(config);
        this.area = toolkit.createComposite((Composite)this.section, 2048);
        this.section.setClient((Control)this.area);
        this.area.setLayout((Layout)this.createAreaLayout());
        this.area.setLayoutData((Object)new GridData(4, 4, true, true));
        P4FormUIUtils.registerExpansionSpaceGrabber((Section)this.section, (Composite)parent);
        this.viewer = this.createViewer();
        this.viewer.createControl(this.area, toolkit);
        this.viewer.showContentPairs(this.getPreferenceStore().getBoolean("SHOW_CONTENT"));
        this.viewer.showUniquePairs(this.getPreferenceStore().getBoolean("SHOW_UNIQUE"));
        this.viewer.showIdenticalPairs(this.getPreferenceStore().getBoolean("SHOW_IDENTICAL"));
        this.viewer.getViewer().getTree().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.hookSelection();
        this.createChangelistControl(parent, toolkit);
    }

    public void createChangelistControl(Composite parent, FormToolkit toolkit) {
        this.changelist = this.createChangelistArea(parent, toolkit);
    }

    public DiffViewer getViewer() {
        return this.viewer;
    }

    public FolderDiffFilterArea getFilter() {
        return this.filterArea;
    }

    protected abstract int getUniqueCount(FileDiffContainer var1);

    protected abstract GroupedDiffContainer getGroupContainer(FileDiffContainer var1);

    public void setContainer(FileDiffContainer container) {
        this.container = container;
        int unique = this.getUniqueCount(this.container);
        if (unique == 1) {
            this.uniqueCountLabel.setText(Messages.DiffArea_SingleUniqueFile);
        } else {
            this.uniqueCountLabel.setText(MessageFormat.format(Messages.DiffArea_MultipleUniqueFiles, unique));
        }
        ((GridData)this.uniqueCountLabel.getControl().getLayoutData()).widthHint = this.uniqueCountLabel.getControl().computeSize((int)-1, (int)-1).x;
        GroupedDiffContainer groupContainer = null;
        if (this.container != null) {
            groupContainer = this.getGroupContainer(container);
        }
        this.viewer.setInput(this.container, groupContainer);
        this.section.layout(true);
    }

    public void setPair(DiffArea pair) {
        this.pair = pair;
        if (this.pair != null) {
            this.pair.getFilter().getSection().addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanging(ExpansionEvent e) {
                    DiffArea.this.getFilter().setExpanded(e.getState());
                }
            });
        }
    }

    public void setFilterExpanded(boolean expanded) {
        this.getFilter().setExpanded(expanded);
        this.refreshTreeOffset();
        if (this.pair != null) {
            this.pair.refreshTreeOffset();
        }
    }

    protected void selectPair(IP4DiffFile file) {
        IP4DiffFile pair = null;
        if (file != null) {
            pair = file.getPair();
        }
        this.setPairSelection(pair);
    }

    protected void setPairSelection(Object element) {
        if (element != null) {
            this.pair.getViewer().getViewer().setSelection((ISelection)new StructuredSelection(element), true);
        } else {
            this.pair.getViewer().getViewer().setSelection((ISelection)StructuredSelection.EMPTY, true);
        }
    }

    private void hookSelection() {
        this.viewer.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DiffArea.this.settingSelection = true;
                Object first = DiffArea.this.getFirstElement(DiffArea.this.viewer);
                try {
                    if (DiffArea.this.pair != null && !DiffArea.this.pair.isSettingSelection()) {
                        if (first instanceof IP4DiffFile) {
                            DiffArea.this.selectPair((IP4DiffFile)first);
                        } else if (first instanceof FileDiffElement) {
                            DiffArea.this.setPairSelection(first);
                        } else if (first instanceof Folder) {
                            DiffArea.this.setPairSelection(first);
                        } else {
                            DiffArea.this.selectPair(null);
                        }
                    }
                }
                finally {
                    DiffArea.this.settingSelection = false;
                }
                DiffArea.this.loadChangelist(first, DiffArea.this.changelist);
            }
        });
    }

    protected boolean isSettingSelection() {
        return this.settingSelection;
    }

    protected void loadChangelist(Object element, SubmittedChangelistWidget changelistArea) {
        IP4Revision revision = (IP4Revision)P4CoreUtils.convert((Object)element, IP4Revision.class);
        if (P4UIUtils.okToUse((Widget)this.section)) {
            changelistArea.setRevision(revision);
        }
    }

    private Object getFirstElement(DiffViewer viewer) {
        return ((IStructuredSelection)viewer.getViewer().getSelection()).getFirstElement();
    }

    private Composite createHeaderLabel(Section section, FormToolkit toolkit) {
        Composite header = P4FormUIUtils.createSectionTextClient((FormToolkit)toolkit, (Section)section, (int)2, (int)64);
        this.headerLabel = new CLabel(header, 0);
        this.headerLabel.setFont(section.getFont());
        this.headerLabel.setForeground(section.getTitleBarForeground());
        this.headerLabel.setLayoutData((Object)new GridData(1, 0x1000000, true, true));
        this.uniqueCountLabel = new DecorationLabel(header);
        this.uniqueCountLabel.setForeground(section.getTitleBarForeground());
        this.uniqueCountLabel.getControl().setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        return header;
    }

    private IPreferenceStore getPreferenceStore() {
        return PerforceUiFolderPlugin.getDefault().getPreferenceStore();
    }

    private SubmittedChangelistWidget createChangelistArea(Composite parent, FormToolkit toolkit) {
        Section changelist = toolkit.createSection(parent, 322);
        changelist.setText(Messages.DiffArea_SubmittedChangelistDetails);
        changelist.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite changelistArea = toolkit.createComposite((Composite)changelist, 0);
        changelist.setClient((Control)changelistArea);
        changelistArea.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(0, 0).create());
        changelistArea.setLayoutData((Object)new GridData(4, 4, true, true));
        SubmittedChangelistWidget clWidget = new SubmittedChangelistWidget(changelistArea, toolkit);
        P4FormUIUtils.registerExpansionSpaceGrabber((Section)changelist, (Composite)parent);
        return clWidget;
    }

    public void refreshTreeOffset() {
        int offset = 0;
        Composite base = this.getViewer().getViewer().getTree().getParent();
        while (base != this.section) {
            if (base == null) break;
            offset += base.getBounds().y;
            base = base.getParent();
        }
        this.treeOffset = offset += this.section.getBounds().y;
    }

    public int getTreeOffset() {
        if (this.treeOffset == -1) {
            this.refreshTreeOffset();
        }
        return this.treeOffset;
    }

    public void setType(Folder.Type type) {
        this.viewer.setType(type);
    }

    public void updateTitle(IDiffConfiguration config) {
        this.headerLabel.setText(config.getLabel(config));
        ImageDescriptor descriptor = config.getImageDescriptor(config);
        if (descriptor != null) {
            Image image = descriptor.createImage();
            P4UIUtils.registerDisposal((Widget)this.headerLabel, (Resource)image);
            this.headerLabel.setImage(image);
        } else {
            this.headerLabel.setImage(null);
        }
        this.section.layout(true, true);
    }
}

