/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.folder.diff.model;

import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.folder.IP4DiffFile;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Revision;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchAdapter;

public class FileDiffElement
extends WorkbenchAdapter
implements IAdaptable {
    private IWorkbenchAdapter workbenchAdapter;
    private IDiffElement element;
    private IP4DiffFile parent;
    private Object[] children = null;

    public FileDiffElement(IDiffElement element, IP4DiffFile parent) {
        Object platformAdapter;
        Assert.isNotNull((Object)element, (String)"Element cannot be null");
        Assert.isNotNull((Object)parent, (String)"Parent cannot be null");
        this.element = element;
        this.parent = parent;
        this.workbenchAdapter = (IWorkbenchAdapter)P4CoreUtils.convert((Object)this.element, IWorkbenchAdapter.class);
        if (this.workbenchAdapter == null && (platformAdapter = Platform.getAdapterManager().getAdapter((Object)this.element, IWorkbenchAdapter.class)) instanceof IWorkbenchAdapter) {
            this.workbenchAdapter = (IWorkbenchAdapter)platformAdapter;
        }
    }

    public IDiffElement getElement() {
        return this.element;
    }

    private void loadChildren() {
        if (this.workbenchAdapter != null) {
            this.children = this.workbenchAdapter.getChildren((Object)this.element);
            if (this.children.length > 0) {
                Object[] converted = new Object[this.children.length];
                int index = 0;
                Object[] objectArray = this.children;
                int n = this.children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    if (child instanceof IDiffElement) {
                        child = new FileDiffElement((IDiffElement)child, this.parent);
                    }
                    converted[index] = child;
                    ++index;
                    ++n2;
                }
                this.children = converted;
            }
        } else {
            this.children = NO_CHILDREN;
        }
    }

    public Object[] getChildren(Object object) {
        if (this.children == null) {
            this.loadChildren();
        }
        return this.children;
    }

    public String getLabel(Object object) {
        return this.workbenchAdapter != null ? this.workbenchAdapter.getLabel((Object)this.element) : super.getLabel((Object)this.element);
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return this.workbenchAdapter != null ? this.workbenchAdapter.getImageDescriptor((Object)this.element) : null;
    }

    public Object getParent(Object object) {
        return this.parent;
    }

    public Object getAdapter(Class adapter) {
        if (IDiffElement.class == adapter) {
            return this.element;
        }
        if (IP4DiffFile.class == adapter || IP4Resource.class == adapter) {
            return this.parent;
        }
        if (ICompareInput.class == adapter && this.element instanceof ICompareInput) {
            return this.element;
        }
        if (DiffNode.class == adapter && this.element instanceof DiffNode) {
            return this.element;
        }
        if (IP4Revision.class == adapter) {
            return this.parent.getAdapter(IP4Revision.class);
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FileDiffElement) {
            FileDiffElement other = (FileDiffElement)((Object)obj);
            return this.parent.equals(other.parent) && this.element.equals(other.element);
        }
        return false;
    }

    public int hashCode() {
        return this.element.hashCode();
    }
}

