/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.folder.diff.editor.input;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.ui.folder.diff.editor.input.ContainerDiffInput;
import com.perforce.team.ui.folder.diff.editor.input.FolderDiffInputFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IMemento;

public class ContainerDiffInputFactory
extends FolderDiffInputFactory {
    public static final String ID = "com.perforce.team.ui.folder.diff.editor.ContainerDiffInputFactory";

    @Override
    protected IAdaptable createElement(IP4Connection connection, IMemento memento) {
        ContainerDiffInput input = null;
        String left = memento.getString("left");
        String right = memento.getString("right");
        if (left != null && right != null) {
            IResource rightResource;
            IPath leftPath = Path.fromPortableString((String)left);
            IPath rightPath = Path.fromPortableString((String)right);
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IResource leftResource = root.findMember(leftPath);
            if (leftResource instanceof IContainer && leftResource.getProject().isAccessible() && (rightResource = root.findMember(rightPath)) != null && rightResource.getProject().isAccessible()) {
                input = new ContainerDiffInput(connection);
                input.setLeftContainer((IContainer)leftResource);
                input.setRightContainer((IContainer)rightResource);
                input.getLeftConfiguration().getOptions().load(memento.getChild("leftOptions"));
                input.getRightConfiguration().getOptions().load(memento.getChild("rightOptions"));
            }
        }
        return input;
    }
}

