/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.folder.diff.editor.input;

import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.folder.PerforceUiFolderPlugin;
import com.perforce.team.ui.folder.diff.editor.input.FolderDiffInput;
import com.perforce.team.ui.folder.diff.editor.input.IDiffConfiguration;
import com.perforce.team.ui.folder.diff.model.FileDiffContainer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.PlatformUI;

public class ContainerDiffInput
extends FolderDiffInput {
    private IContainer leftContainer;
    private IContainer rightContainer;

    public ContainerDiffInput(IP4Connection connection) {
        super(connection);
    }

    public ContainerDiffInput(IP4Connection connection, IDiffConfiguration left, IDiffConfiguration right, IDiffConfiguration header) {
        super(connection, left, right, header);
    }

    protected ImageDescriptor getProjectDescriptor() {
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_PROJECT");
    }

    public void setLeftContainer(IContainer container) {
        this.leftContainer = container;
        if (this.leftContainer != null) {
            if (this.leftContainer instanceof IProject) {
                this.getLeftConfiguration().setImageDescriptor(this.getProjectDescriptor());
                this.getLeftConfiguration().setLabel(this.leftContainer.getName());
            } else {
                this.getLeftConfiguration().setLabel(this.leftContainer.getFullPath().makeRelative().toPortableString());
                this.getLeftConfiguration().setImageDescriptor(PerforceUIPlugin.getDescriptor((String)"perforce/depot_folder.png"));
            }
        }
    }

    public void setRightContainer(IContainer container) {
        this.rightContainer = container;
        if (this.rightContainer != null) {
            if (this.rightContainer instanceof IProject) {
                this.getRightConfiguration().setImageDescriptor(this.getProjectDescriptor());
                this.getRightConfiguration().setLabel(this.rightContainer.getName());
            } else {
                this.getRightConfiguration().setLabel(this.rightContainer.getFullPath().makeRelative().toPortableString());
                this.getRightConfiguration().setImageDescriptor(PerforceUIPlugin.getDescriptor((String)"perforce/depot_folder.png"));
            }
        }
    }

    @Override
    protected void addPaths(final String leftFilter, final String rightFilter, final FileDiffContainer container) {
        String leftAction = P4CoreUtils.getResourceActionPath((IResource)this.leftContainer);
        String rightAtion = P4CoreUtils.getResourceActionPath((IResource)this.rightContainer);
        if (leftAction != null && rightAtion != null) {
            container.addMapping(leftAction, rightAtion);
            container.add(this.connection.getDiffs(String.valueOf(leftAction) + leftFilter, String.valueOf(rightAtion) + rightFilter), this.connection);
        }
        if (PerforceUiFolderPlugin.getDefault().getPreferenceStore().getBoolean("DIFF_LINKED_RESOURCES") && this.leftContainer != null && this.leftContainer.equals((Object)this.rightContainer)) {
            try {
                this.leftContainer.accept(new IResourceProxyVisitor(){

                    public boolean visit(IResourceProxy proxy) throws CoreException {
                        String linkedPath;
                        if (proxy.isLinked() && (linkedPath = P4CoreUtils.getResourceActionPath((IResource)proxy.requestResource())) != null) {
                            container.addMapping(linkedPath, linkedPath);
                            container.add(ContainerDiffInput.this.connection.getDiffs(String.valueOf(linkedPath) + leftFilter, String.valueOf(linkedPath) + rightFilter), ContainerDiffInput.this.connection);
                        }
                        return true;
                    }
                }, 2);
            }
            catch (CoreException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
        }
    }

    @Override
    public boolean exists() {
        return this.isValid() ? super.exists() : false;
    }

    @Override
    public IPersistableElement getPersistable() {
        return this.isValid() ? super.getPersistable() : null;
    }

    protected boolean isValid() {
        if (this.leftContainer == null) {
            return false;
        }
        if (this.rightContainer == null) {
            return false;
        }
        IProject project = this.leftContainer.getProject();
        if (project == null || !project.isAccessible()) {
            return false;
        }
        project = this.rightContainer.getProject();
        return project != null && project.isAccessible();
    }

    @Override
    protected void savePaths(IMemento memento) {
        IPath path;
        if (this.leftContainer != null && (path = this.leftContainer.getFullPath()) != null) {
            memento.putString("left", path.toPortableString());
        }
        if (this.rightContainer != null && (path = this.rightContainer.getFullPath()) != null) {
            memento.putString("right", path.toPortableString());
        }
    }

    @Override
    public String getFactoryId() {
        return "com.perforce.team.ui.folder.diff.editor.ContainerDiffInputFactory";
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof ContainerDiffInput && super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

