/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.text.timelapse;

import com.perforce.team.ui.text.TextUtils;
import com.perforce.team.ui.text.timelapse.IColorPainter;
import java.util.Arrays;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public abstract class TextRuler
implements IVerticalRulerColumn {
    private IColorPainter painter;
    protected int maxNumber = -1;
    private ITextViewer viewer;
    private StyledText text;
    private Canvas displayArea;
    private int fScrollPos;
    private Image buffer;
    private InternalListener fInternalListener = new InternalListener();
    private Font font;
    protected int[] fIndentation;
    private boolean fSensitiveToTextChanges = false;
    private Color foreground;
    private Color background;
    protected int fCachedNumberOfDigits = -1;
    private boolean fRelayoutRequired = false;
    private Object fRunnableLock = new Object();
    private boolean fIsRunnablePosted = false;
    private Runnable fRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = TextRuler.this.fRunnableLock;
            synchronized (object) {
                TextRuler.this.fIsRunnablePosted = false;
            }
            TextRuler.this.redraw();
        }
    };
    private boolean listenToDocument = false;

    protected abstract int computeMaxNumber();

    public void updateSize() {
        this.maxNumber = this.computeMaxNumber();
        this.updateNumberOfDigits();
        this.computeIndentations();
        this.redraw();
    }

    public void setPainter(IColorPainter painter) {
        this.painter = painter;
    }

    public TextRuler() {
        this.listenToDocument = true;
    }

    public TextRuler(boolean listenToDocument) {
        this.listenToDocument = listenToDocument;
    }

    protected ITextViewer getViewer() {
        return this.viewer;
    }

    protected StyledText getTextWidget() {
        return this.text;
    }

    public void setForeground(Color foreground) {
        this.foreground = foreground;
    }

    public void setBackground(Color background) {
        this.background = background;
        if (this.displayArea != null && !this.displayArea.isDisposed()) {
            this.displayArea.setBackground(this.getBackground(this.displayArea.getDisplay()));
        }
    }

    protected Color getBackground(Display display) {
        if (this.background == null) {
            return display.getSystemColor(25);
        }
        return this.background;
    }

    public Control getControl() {
        return this.displayArea;
    }

    public int getWidth() {
        return this.fIndentation[0] + 5;
    }

    protected boolean updateNumberOfDigits() {
        if (this.viewer == null) {
            return false;
        }
        int digits = Math.max(1, this.maxNumber);
        if (this.fCachedNumberOfDigits != digits) {
            this.fCachedNumberOfDigits = digits;
            return true;
        }
        return false;
    }

    protected int computeNumberOfDigits(int maxNumber) {
        int digits = 2;
        while ((double)maxNumber > Math.pow(10.0, digits) - 1.0) {
            ++digits;
        }
        return digits;
    }

    protected void layout(boolean redraw) {
        ITextViewerExtension extension;
        Control control;
        if (!redraw) {
            this.fRelayoutRequired = true;
            return;
        }
        this.fRelayoutRequired = false;
        if (this.viewer instanceof ITextViewerExtension && (control = (extension = (ITextViewerExtension)this.viewer).getControl()) instanceof Composite && !control.isDisposed()) {
            Composite composite = (Composite)control;
            composite.layout(true);
        }
    }

    protected void computeIndentations() {
        if (this.displayArea == null || this.displayArea.isDisposed()) {
            return;
        }
        GC gc = new GC((Drawable)this.displayArea);
        try {
            gc.setFont(this.displayArea.getFont());
            this.fIndentation = new int[this.fCachedNumberOfDigits + 1];
            char[] nines = new char[this.fCachedNumberOfDigits];
            Arrays.fill(nines, '9');
            String nineString = new String(nines);
            Point p = gc.stringExtent(nineString);
            this.fIndentation[0] = p.x;
            int i = 1;
            while (i <= this.fCachedNumberOfDigits) {
                p = gc.stringExtent(nineString.substring(0, i));
                this.fIndentation[i] = this.fIndentation[0] - p.x;
                ++i;
            }
        }
        finally {
            gc.dispose();
        }
    }

    public Control createControl(CompositeRuler parentRuler, Composite parentControl) {
        this.viewer = parentRuler.getTextViewer();
        if (this.viewer != null) {
            this.text = this.viewer.getTextWidget();
        }
        this.displayArea = new Canvas(parentControl, 0x20080000);
        this.displayArea.setBackground(this.getBackground(this.displayArea.getDisplay()));
        this.displayArea.setForeground(this.foreground);
        this.displayArea.setLayoutData((Object)new GridData(4, 4, false, true));
        this.displayArea.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (TextRuler.this.viewer != null) {
                    TextRuler.this.doubleBufferPaint(event.gc);
                }
            }
        });
        this.displayArea.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TextRuler.this.handleDispose();
                TextRuler.this.viewer = null;
                TextRuler.this.text = null;
            }
        });
        if (this.viewer != null) {
            this.viewer.addViewportListener((IViewportListener)this.fInternalListener);
            if (this.listenToDocument) {
                this.viewer.addTextListener((ITextListener)this.fInternalListener);
            }
            if (this.font == null && this.text != null && !this.text.isDisposed()) {
                this.font = this.text.getFont();
            }
        }
        if (this.font != null) {
            this.displayArea.setFont(this.font);
        }
        this.updateNumberOfDigits();
        this.computeIndentations();
        return this.displayArea;
    }

    protected void handleDispose() {
        if (this.viewer != null) {
            this.viewer.removeViewportListener((IViewportListener)this.fInternalListener);
            if (this.listenToDocument) {
                this.viewer.removeTextListener((ITextListener)this.fInternalListener);
            }
        }
        if (this.buffer != null) {
            this.buffer.dispose();
            this.buffer = null;
        }
    }

    private void doubleBufferPaint(GC dest) {
        Point size = this.displayArea.getSize();
        if (size.x <= 0 || size.y <= 0) {
            return;
        }
        if (this.buffer != null) {
            Rectangle r = this.buffer.getBounds();
            if (r.width != size.x || r.height != size.y) {
                this.buffer.dispose();
                this.buffer = null;
            }
        }
        if (this.buffer == null) {
            this.buffer = new Image((Device)this.displayArea.getDisplay(), size.x, size.y);
        }
        GC gc = new GC((Drawable)this.buffer);
        gc.setFont(this.displayArea.getFont());
        if (this.foreground != null) {
            gc.setForeground(this.foreground);
        }
        try {
            gc.setBackground(this.getBackground(this.displayArea.getDisplay()));
            gc.fillRectangle(0, 0, size.x, size.y);
            ILineRange visibleLines = TextUtils.getVisibleModelLines(this.viewer);
            if (visibleLines == null) {
                return;
            }
            this.fScrollPos = this.text.getTopPixel();
            this.doPaint(gc, visibleLines);
        }
        finally {
            gc.dispose();
        }
        dest.drawImage(this.buffer, 0, 0);
    }

    protected final boolean isViewerCompletelyShown() {
        return TextUtils.isShowingEntireContents(this.text);
    }

    protected void paintLines(int startLine, int endLine, int width, int y, GC gc, Display display) {
        int line = startLine;
        while (line < endLine) {
            int widgetLine = TextUtils.modelLineToWidgetLine(this.viewer, line);
            if (widgetLine != -1) {
                int lineHeight = this.text.getLineHeight(this.text.getOffsetAtLine(widgetLine));
                this.paintBackground(line, gc, y, width, lineHeight);
                this.paintLine(line, y, lineHeight, gc, display);
                y += lineHeight;
            }
            ++line;
        }
    }

    protected void paintBackground(int line, GC gc, int y, int width, int height) {
        if (this.painter != null) {
            Color color = this.painter.getColor(line);
            if (color != null) {
                gc.setBackground(color);
                gc.fillRectangle(0, y, width, height);
            } else {
                gc.setBackground(this.getBackground(this.displayArea.getDisplay()));
            }
        }
    }

    protected void doPaint(GC gc, ILineRange visibleLines) {
        Display display = this.text.getDisplay();
        int y = -TextUtils.getHiddenTopLinePixels(this.text);
        int lastLine = TextRuler.end(visibleLines);
        int width = this.displayArea.getSize().x;
        this.paintLines(visibleLines.getStartLine(), lastLine, width, y, gc, display);
    }

    private static int end(ILineRange range) {
        return range.getStartLine() + range.getNumberOfLines();
    }

    private int getBaselineBias(GC gc, int widgetLine) {
        int offset = this.text.getOffsetAtLine(widgetLine);
        int widgetBaseline = this.text.getBaseline(offset);
        FontMetrics fm = gc.getFontMetrics();
        int fontBaseline = fm.getAscent() + fm.getLeading();
        int baselineBias = widgetBaseline - fontBaseline;
        return Math.max(0, baselineBias);
    }

    protected void paintLine(int line, int y, int lineheight, GC gc, Display display) {
        int widgetLine = TextUtils.modelLineToWidgetLine(this.viewer, line);
        String s = this.getLineText(line);
        if (s != null && s.length() < this.fIndentation.length) {
            int indentation = this.fIndentation[s.length()];
            int baselineBias = this.getBaselineBias(gc, widgetLine);
            gc.drawString(s, indentation, y + baselineBias, true);
        }
    }

    protected abstract String getLineText(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void postRedraw() {
        Display d;
        if (this.displayArea != null && !this.displayArea.isDisposed() && (d = this.displayArea.getDisplay()) != null) {
            Object object = this.fRunnableLock;
            synchronized (object) {
                if (this.fIsRunnablePosted) {
                    return;
                }
                this.fIsRunnablePosted = true;
            }
            d.asyncExec(this.fRunnable);
        }
    }

    public void markForRedraw() {
        if (this.displayArea != null && !this.displayArea.isDisposed()) {
            this.displayArea.redraw();
        }
    }

    public void redraw() {
        if (this.viewer != null) {
            if (this.fRelayoutRequired) {
                this.layout(true);
                return;
            }
            if (this.displayArea != null && !this.displayArea.isDisposed()) {
                GC gc = new GC((Drawable)this.displayArea);
                this.doubleBufferPaint(gc);
                gc.dispose();
            }
        }
    }

    public void setModel(IAnnotationModel model) {
    }

    public void setFont(Font font) {
        this.font = font;
        if (this.displayArea != null && !this.displayArea.isDisposed()) {
            this.displayArea.setFont(this.font);
            this.updateNumberOfDigits();
            this.computeIndentations();
        }
    }

    public void setVisible(boolean visible) {
        ((GridData)this.displayArea.getLayoutData()).exclude = !visible;
        this.displayArea.setVisible(visible);
    }

    class InternalListener
    implements IViewportListener,
    ITextListener {
        private boolean fCachedRedrawState = true;

        InternalListener() {
        }

        public void viewportChanged(int verticalPosition) {
            if (this.fCachedRedrawState && verticalPosition != TextRuler.this.fScrollPos) {
                TextRuler.this.redraw();
            }
        }

        public void textChanged(TextEvent event) {
            this.fCachedRedrawState = event.getViewerRedrawState();
            if (!this.fCachedRedrawState) {
                return;
            }
            if (TextRuler.this.updateNumberOfDigits()) {
                TextRuler.this.computeIndentations();
                TextRuler.this.layout(event.getViewerRedrawState());
                return;
            }
            boolean viewerCompletelyShown = TextRuler.this.isViewerCompletelyShown();
            if (viewerCompletelyShown || TextRuler.this.fSensitiveToTextChanges || event.getDocumentEvent() == null) {
                TextRuler.this.postRedraw();
            }
            TextRuler.this.fSensitiveToTextChanges = viewerCompletelyShown;
        }
    }
}

