/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.text.timelapse;

import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.ui.preferences.IPreferenceHandler;
import com.perforce.team.ui.text.PerforceUiTextPlugin;
import com.perforce.team.ui.text.timelapse.Messages;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class TextPreferenceHandler
implements IPreferenceHandler {
    private BooleanFieldEditor foldingEditor;
    private BooleanFieldEditor rangeEditor;
    private BooleanFieldEditor authorEditor;
    private BooleanFieldEditor agingEditor;
    private ColorFieldEditor mostRecentEditor;
    private ColorFieldEditor leastRecentEditor;
    private ColorFieldEditor tickColorEditor;
    private BooleanFieldEditor linkEditor;
    private BooleanFieldEditor buildEditor;
    private BooleanFieldEditor filterEditor;
    private ComboFieldEditor whitespaceEditor;

    public void addControls(Composite parent) {
        IPreferenceStore store = PerforceUiTextPlugin.getDefault().getPreferenceStore();
        this.authorEditor = new BooleanFieldEditor("com.perforce.team.ui.text.timelapse.SHOW_AUTHORS", Messages.TextPreferenceHandler_DisplayAuthorInfo, parent);
        this.authorEditor.setPreferenceStore(store);
        this.authorEditor.load();
        this.rangeEditor = new BooleanFieldEditor("com.perforce.team.ui.text.timelapse.SHOW_RANGES", Messages.TextPreferenceHandler_DisplayRevisionInfo, parent);
        this.rangeEditor.setPreferenceStore(store);
        this.rangeEditor.load();
        this.agingEditor = new BooleanFieldEditor("com.perforce.team.ui.text.timelapse.SHOW_AGING", Messages.TextPreferenceHandler_DisplayTextAging, parent);
        this.agingEditor.setPreferenceStore(store);
        this.agingEditor.load();
        Composite whitespaceArea = new Composite(parent, 0);
        GridLayout waLayout = new GridLayout(1, true);
        waLayout.marginWidth = 0;
        waLayout.marginHeight = 0;
        whitespaceArea.setLayout((Layout)waLayout);
        whitespaceArea.setLayoutData((Object)new GridData(4, 4, true, false));
        this.whitespaceEditor = new ComboFieldEditor("com.perforce.team.ui.text.timelapse.WHITESPACE_TYPE", Messages.TextPreferenceHandler_WhitespaceOptions, (String[][])new String[][]{{Messages.TextPreferenceHandler_IgnoreLineEndingAndAllWS, IP4File.WhitespaceIgnoreType.ALL.toString()}, {Messages.TextPreferenceHandler_RecognizeLineEndingAndWS, ""}, {Messages.TextPreferenceHandler_IgnoreLineEndingAndWS, IP4File.WhitespaceIgnoreType.WHITESPACE.toString()}, {Messages.TextPreferenceHandler_IgnoreLineEnding, IP4File.WhitespaceIgnoreType.LINE_ENDINGS.toString()}}, whitespaceArea);
        this.whitespaceEditor.setPreferenceStore(store);
        this.whitespaceEditor.load();
        Composite colorArea = new Composite(parent, 0);
        GridLayout caLayout = new GridLayout(1, true);
        caLayout.marginWidth = 0;
        caLayout.marginHeight = 0;
        colorArea.setLayout((Layout)caLayout);
        colorArea.setLayoutData((Object)new GridData(4, 4, true, false));
        this.leastRecentEditor = new ColorFieldEditor("com.perforce.team.ui.text.timelapse.LEAST_RECENT_COLOR", Messages.TextPreferenceHandler_LeastRecentTextBGColor, colorArea);
        this.leastRecentEditor.setPreferenceStore(store);
        this.leastRecentEditor.load();
        this.mostRecentEditor = new ColorFieldEditor("com.perforce.team.ui.text.timelapse.MOST_RECENT_COLOR", Messages.TextPreferenceHandler_10, colorArea);
        this.mostRecentEditor.setPreferenceStore(store);
        this.mostRecentEditor.load();
        this.tickColorEditor = new ColorFieldEditor("com.perforce.team.ui.text.timelapse.TICK_CHANGE_COLOR", Messages.TextPreferenceHandler_NodeChangeFGColor, colorArea);
        this.tickColorEditor.setPreferenceStore(store);
        this.tickColorEditor.load();
        this.linkEditor = new BooleanFieldEditor("com.perforce.team.ui.text.timelapse.LINK_EDITOR", Messages.TextPreferenceHandler_LinkEditorWithOutlineViewSelection, parent);
        this.linkEditor.setPreferenceStore(store);
        this.linkEditor.load();
        this.foldingEditor = new BooleanFieldEditor("com.perforce.team.ui.text.timelapse.SHOW_FOLDING", Messages.TextPreferenceHandler_DisplayCodeFolding, parent);
        this.foldingEditor.setPreferenceStore(store);
        this.foldingEditor.load();
        this.buildEditor = new BooleanFieldEditor("com.perforce.team.ui.text.timelapse.BUILD", Messages.TextPreferenceHandler_GenerateMethodHistory, parent);
        this.buildEditor.setPreferenceStore(store);
        this.buildEditor.load();
        this.filterEditor = new BooleanFieldEditor("com.perforce.team.ui.text.timelapse.FILTER", Messages.TextPreferenceHandler_OnlyShowRevsWhereSelectedNodeChanges, parent);
        this.filterEditor.setPreferenceStore(store);
        this.filterEditor.load();
    }

    public void defaults() {
        this.authorEditor.loadDefault();
        this.rangeEditor.loadDefault();
        this.agingEditor.loadDefault();
        this.leastRecentEditor.loadDefault();
        this.mostRecentEditor.loadDefault();
        this.tickColorEditor.loadDefault();
        this.foldingEditor.loadDefault();
        this.buildEditor.loadDefault();
        this.filterEditor.loadDefault();
        this.linkEditor.loadDefault();
        this.whitespaceEditor.loadDefault();
    }

    public void save() {
        this.authorEditor.store();
        this.rangeEditor.store();
        this.agingEditor.store();
        this.leastRecentEditor.store();
        this.mostRecentEditor.store();
        this.tickColorEditor.store();
        this.foldingEditor.store();
        this.buildEditor.store();
        this.filterEditor.store();
        this.linkEditor.store();
        this.whitespaceEditor.store();
    }
}

