/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.text.timelapse;

import com.perforce.team.core.p4java.IP4Revision;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.text.timelapse.INodeModel;
import com.perforce.team.ui.text.timelapse.Messages;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public abstract class NodeOutlinePage
extends Page
implements IContentOutlinePage {
    protected static final Object[] EMPTY = new Object[0];
    protected static final int REFRESH_INTERVAL = 200;
    private ListenerList listeners;
    protected Object root;
    protected INodeModel model;
    protected IP4Revision revision;
    private Composite displayArea;
    private TreeViewer viewer;
    private ITreeContentProvider contentProvider = null;
    private boolean isLoading = false;
    private ISelection nextSelection;
    private Job loadingJob = new Job(Messages.NodeOutlinePage_LoadingTimelapseOutline){

        protected IStatus run(IProgressMonitor monitor) {
            final Object loadRoot = NodeOutlinePage.this.root;
            if (loadRoot != null) {
                Object[] elements;
                final ArrayList<Object> expand = new ArrayList<Object>();
                Object[] objectArray = elements = NodeOutlinePage.this.contentProvider.getElements(loadRoot);
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object[] children;
                    Object element = objectArray[n2];
                    if (NodeOutlinePage.this.expand(element)) {
                        expand.add(element);
                    }
                    Object[] objectArray2 = children = NodeOutlinePage.this.contentProvider.getChildren(element);
                    int n3 = children.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Object child = objectArray2[n4];
                        if (NodeOutlinePage.this.expand(child)) {
                            expand.add(child);
                        }
                        ++n4;
                    }
                    ++n2;
                }
                PerforceUIPlugin.syncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (loadRoot == (this).NodeOutlinePage.this.root && NodeOutlinePage.this.okToUse()) {
                            NodeOutlinePage.this.viewer.setInput((this).NodeOutlinePage.this.root);
                            NodeOutlinePage.this.viewer.setExpandedElements(expand.toArray(new Object[expand.size()]));
                            if (NodeOutlinePage.this.nextSelection != null) {
                                NodeOutlinePage.this.viewer.setSelection(NodeOutlinePage.this.nextSelection);
                            }
                            NodeOutlinePage.this.isLoading = false;
                        }
                    }
                });
            }
            return Status.OK_STATUS;
        }
    };

    public NodeOutlinePage() {
        this.listeners = new ListenerList();
    }

    public NodeOutlinePage(Object root) {
        this();
        this.setRoot(root);
    }

    public NodeOutlinePage(Object root, INodeModel model) {
        this();
        this.setRoot(root);
        this.setModel(model);
    }

    public boolean isDisposed() {
        return !this.okToUse();
    }

    private boolean okToUse() {
        return this.viewer != null && this.viewer.getTree() != null && !this.viewer.getTree().isDisposed();
    }

    public void setRoot(Object root) {
        this.root = root;
        this.setInput();
    }

    public void setModel(INodeModel model) {
        this.model = model;
    }

    public void setRevision(IP4Revision revision) {
        this.revision = revision;
    }

    public boolean isLoading() {
        return this.isLoading;
    }

    private void setInput() {
        if (this.okToUse()) {
            if (this.root != null) {
                this.isLoading = true;
                this.loadingJob.schedule(200L);
            } else {
                this.loadingJob.cancel();
                this.viewer.setInput((Object)EMPTY);
            }
        }
    }

    protected abstract boolean expand(Object var1);

    protected abstract ITreeContentProvider getContentProvider();

    protected abstract IBaseLabelProvider getLabelProvider();

    protected abstract void configureViewer(TreeViewer var1);

    public void createControl(Composite parent) {
        this.displayArea = new Composite(parent, 0);
        GridLayout daLayout = new GridLayout(1, true);
        daLayout.marginWidth = 0;
        daLayout.marginHeight = 0;
        this.displayArea.setLayout((Layout)daLayout);
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer = new TreeViewer(this.displayArea, 772);
        this.viewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            this.viewer.addSelectionChangedListener((ISelectionChangedListener)listener);
            ++n2;
        }
        this.listeners.clear();
        this.configureViewer(this.viewer);
        this.contentProvider = this.getContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setLabelProvider(this.getLabelProvider());
        this.setInput();
        Action clearAction = new Action(){

            public void run() {
                NodeOutlinePage.this.nextSelection = null;
                NodeOutlinePage.this.viewer.setSelection((ISelection)StructuredSelection.EMPTY);
            }
        };
        clearAction.setToolTipText(Messages.NodeOutlinePage_ClearSelection);
        clearAction.setImageDescriptor(PerforceUIPlugin.getDescriptor((String)"normal/clear.png"));
        this.getSite().getActionBars().getToolBarManager().add((IAction)clearAction);
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public Control getControl() {
        return this.displayArea;
    }

    public void setFocus() {
        this.displayArea.setFocus();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.viewer != null) {
            this.viewer.addSelectionChangedListener(listener);
        } else {
            this.listeners.add((Object)listener);
        }
    }

    protected String decorateRevisions(String label, Object element) {
        String id;
        if (element != null && this.model != null && this.revision != null && this.model.isComplete() && (id = this.model.getHandle(element)) != null) {
            int have = this.model.getRelativeChangeCount(this.revision, id);
            int head = this.model.getTotalChangeCount(this.revision, id);
            if (have > 0 && head > 0) {
                StringBuilder builder = new StringBuilder(label);
                builder.append(" #");
                builder.append(have);
                builder.append('/');
                builder.append(head);
                label = builder.toString();
            }
        }
        return label;
    }

    public ISelection getSelection() {
        return this.viewer.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.viewer != null) {
            this.viewer.removeSelectionChangedListener(listener);
        }
    }

    public void setSelection(ISelection selection) {
        if (this.okToUse()) {
            if (!this.isLoading) {
                this.nextSelection = null;
                this.viewer.setSelection(selection);
            } else {
                this.nextSelection = selection;
            }
        }
    }
}

