/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.text.timelapse;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.ui.text.TextUtils;
import com.perforce.team.ui.text.timelapse.TextTimeLapseEditor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;

public class GenericTextTimeLapseEditor
extends TextTimeLapseEditor {
    public static final String ID = "com.perforce.team.ui.text.timelapse.GenericTextTimeLapseEditor";
    private TextFileDocumentProvider provider;
    private SourceViewer viewer;

    @Override
    protected ITextViewer getViewer() {
        return this.viewer;
    }

    @Override
    protected void refresh(IEditorInput input) {
        try {
            this.provider.connect((Object)input);
        }
        catch (CoreException e) {
            PerforceProviderPlugin.logError((Throwable)e);
        }
        this.viewer.setRedraw(false);
        IDocument currDoc = this.viewer.getDocument();
        if (currDoc != null) {
            currDoc.set(this.provider.getDocument((Object)input).get());
        } else {
            currDoc = new Document(this.provider.getDocument((Object)input).get());
            this.viewer.setDocument(currDoc);
        }
        this.viewer.setRedraw(true);
    }

    protected void dispose(IEditorInput input) {
        super.dispose(input);
        this.provider.disconnect((Object)input);
    }

    protected void createViewer(Composite parent) {
        CompositeRuler ruler = this.configureRulers(true);
        this.viewer = new SourceViewer(parent, (IVerticalRuler)ruler, 0x2000300);
        this.viewer.getTextWidget().setBackground(this.getEditorColor("AbstractTextEditor.Color.Background"));
        this.viewer.getTextWidget().setForeground(this.getEditorColor("AbstractTextEditor.Color.Foreground"));
        this.provider = new TextFileDocumentProvider();
        if (!TextUtils.getEditorStore().getBoolean("AbstractTextEditor.Color.SelectionBackground.SystemDefault")) {
            this.viewer.getTextWidget().setSelectionBackground(this.getEditorColor("AbstractTextEditor.Color.SelectionBackground"));
        }
        if (!TextUtils.getEditorStore().getBoolean("AbstractTextEditor.Color.SelectionForeground.SystemDefault")) {
            this.viewer.getTextWidget().setSelectionForeground(this.getEditorColor("AbstractTextEditor.Color.SelectionForeground"));
        }
        this.configureViewer("org.eclipse.jface.textfont");
    }
}

