/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.text.timelapse;

import com.perforce.team.core.p4java.IP4Revision;
import com.perforce.team.ui.text.PerforceUiTextPlugin;
import com.perforce.team.ui.text.timelapse.ColorPainter;
import com.perforce.team.ui.text.timelapse.ITextAnnotateModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;

public class AgingPainter
extends ColorPainter {
    public static final RGB DEFAULT_MOST_RECENT = new RGB(88, 164, 80);
    public static final RGB DEFAULT_LEAST_RECENT = new RGB(220, 255, 220);
    private Map<RGB, Color> agingCache = new HashMap<RGB, Color>();
    private RGB mostRecent = DEFAULT_MOST_RECENT;
    private RGB leastRecent = DEFAULT_LEAST_RECENT;
    private ITextAnnotateModel model;
    private ITextViewer viewer;

    public AgingPainter(ITextAnnotateModel model, ITextViewer viewer) {
        IPreferenceStore store = PerforceUiTextPlugin.getDefault().getPreferenceStore();
        this.leastRecent = PreferenceConverter.getColor((IPreferenceStore)store, (String)"com.perforce.team.ui.text.timelapse.LEAST_RECENT_COLOR");
        this.mostRecent = PreferenceConverter.getColor((IPreferenceStore)store, (String)"com.perforce.team.ui.text.timelapse.MOST_RECENT_COLOR");
        this.model = model;
        this.viewer = viewer;
    }

    public void setMostRecent(RGB mostRecent) {
        this.mostRecent = mostRecent;
    }

    public void setLeastRecent(RGB leastRecent) {
        this.leastRecent = leastRecent;
    }

    private RGB getRGB(int start, int end) {
        int red = start * this.leastRecent.red / end + (end - start) * this.mostRecent.red / end;
        int green = start * this.leastRecent.green / end + (end - start) * this.mostRecent.green / end;
        int blue = start * this.leastRecent.blue / end + (end - start) * this.mostRecent.blue / end;
        return new RGB(red, green, blue);
    }

    private Color getAgingColor(int endPos, ILineRange range, IP4Revision revision) {
        int startPos = this.model.getPositionTo(range.getStartLine(), revision) + 1;
        RGB rgb = this.getRGB(startPos, endPos);
        Color aged = this.agingCache.get(rgb);
        if (aged == null) {
            aged = new Color((Device)this.viewer.getTextWidget().getDisplay(), rgb);
            this.agingCache.put(rgb, aged);
        }
        return aged;
    }

    @Override
    public void dispose() {
        super.dispose();
        for (Color aged : this.agingCache.values()) {
            aged.dispose();
        }
    }

    @Override
    protected Color[] internalLoadColors(Object data) {
        if (data instanceof IP4Revision) {
            ILineRange[] chunks;
            IP4Revision revision = (IP4Revision)data;
            ArrayList<Color> agedList = new ArrayList<Color>();
            int endPos = this.model.getRevisionCount() + 1;
            ILineRange[] iLineRangeArray = chunks = this.model.getLineRanges(revision);
            int n = chunks.length;
            int n2 = 0;
            while (n2 < n) {
                ILineRange chunk = iLineRangeArray[n2];
                Color aged = this.getAgingColor(endPos, chunk, revision);
                int i = 0;
                while (i < chunk.getNumberOfLines()) {
                    agedList.add(aged);
                    ++i;
                }
                ++n2;
            }
            return agedList.toArray(new Color[agedList.size()]);
        }
        return null;
    }
}

