/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.folder;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.IFileDiff;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.impl.generic.core.file.FilePath;
import com.perforce.p4java.impl.generic.core.file.FileSpec;
import com.perforce.team.core.folder.IP4DiffFile;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Container;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Revision;
import com.perforce.team.core.p4java.P4File;
import com.perforce.team.core.p4java.P4Resource;
import java.io.InputStream;
import org.eclipse.core.runtime.Assert;
import org.eclipse.team.core.history.IFileRevision;

public class P4DiffFile
extends P4Resource
implements IP4DiffFile {
    private boolean file1 = false;
    private int hashCode = 0;
    private IFileDiff diff;
    private IP4File file;
    private IP4Revision revision;
    private IP4DiffFile pair;

    public P4DiffFile(IP4Container parent, IFileDiff diff, boolean file1) {
        Assert.isNotNull((Object)parent, (String)"Parent cannot be null");
        Assert.isNotNull((Object)diff, (String)"Diff cannot be null");
        this.diff = diff;
        this.file1 = file1;
        String path = null;
        String type = null;
        int fileRevision = -1;
        if (file1) {
            path = this.diff.getDepotFile1();
            type = this.diff.getFileType1();
            fileRevision = this.diff.getRevision1();
        } else {
            path = this.diff.getDepotFile2();
            type = this.diff.getFileType2();
            fileRevision = this.diff.getRevision2();
        }
        if (path != null) {
            FileSpec spec = new FileSpec(new FilePath(FilePath.PathType.DEPOT, path));
            spec.setFileType(type);
            spec.setEndRevision(fileRevision);
            this.file = new DiffFile((IFileSpec)spec, parent);
            this.hashCode = path.hashCode();
        }
    }

    public void setRevision(IP4Revision revision) {
        this.revision = revision;
    }

    public void setPair(IP4DiffFile pair) {
        this.pair = pair;
    }

    @Override
    public int getRevision() {
        return this.getRevision(this.isFile1());
    }

    private int getRevision(boolean source) {
        return source ? this.diff.getRevision1() : this.diff.getRevision2();
    }

    public IP4Connection getConnection() {
        return this.file.getConnection();
    }

    public String getActionPath() {
        return this.file.getActionPath();
    }

    public String getActionPath(IP4Resource.Type preferredType) {
        return this.file.getActionPath(preferredType);
    }

    public IClient getClient() {
        return this.file.getClient();
    }

    public String getClientPath() {
        return this.file.getClientPath();
    }

    public String getLocalPath() {
        return this.file.getLocalPath();
    }

    public String getName() {
        return this.file.getName();
    }

    public IP4Container getParent() {
        return this.file.getParent();
    }

    public String getRemotePath() {
        return this.file.getRemotePath();
    }

    public boolean isContainer() {
        return false;
    }

    public void refresh(int depth) {
    }

    public void refresh() {
    }

    public boolean isFile() {
        return true;
    }

    public Object getAdapter(Class adapter) {
        if (IP4File.class == adapter) {
            return this.file;
        }
        if (IP4Revision.class == adapter || IFileRevision.class == adapter) {
            return this.revision;
        }
        return super.getAdapter(adapter);
    }

    @Override
    public IFileDiff.Status getStatus() {
        return this.diff.getStatus();
    }

    @Override
    public IP4File getFile() {
        return this.file;
    }

    @Override
    public IFileDiff getDiff() {
        return this.diff;
    }

    private InputStream getFileContents(String path, int revision) {
        InputStream stream = null;
        if (path != null && revision > 0) {
            DiffFile file = new DiffFile((IFileSpec)new FileSpec(new FilePath(FilePath.PathType.DEPOT, path)), this.getParent());
            stream = file.getRemoteContents(revision);
        }
        return stream;
    }

    @Override
    public InputStream getFile1Contents() {
        return this.getFileContents(this.diff.getDepotFile1(), this.diff.getRevision1());
    }

    @Override
    public InputStream getFile2Contents() {
        return this.getFileContents(this.diff.getDepotFile2(), this.diff.getRevision2());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof IP4DiffFile) {
            IP4DiffFile other = (IP4DiffFile)obj;
            return this.getRevision() == other.getRevision() && this.isFile1() == other.isFile1() && super.equals(obj);
        }
        return false;
    }

    @Override
    public IP4DiffFile getPair() {
        return this.pair;
    }

    public int hashCode() {
        if (this.hashCode > 0) {
            return this.hashCode;
        }
        return super.hashCode();
    }

    @Override
    public boolean isFile1() {
        return this.file1;
    }

    public String toString() {
        return this.file.toString();
    }

    private static class DiffFile
    extends P4File {
        public DiffFile(IFileSpec fileSpec, IP4Container parent) {
            super(fileSpec, parent, false);
        }

        public void refresh() {
        }

        public void setFileSpec(IFileSpec spec) {
        }
    }
}

