/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.java.timelapse;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.ui.java.timelapse.JavaFoldingProvider;
import com.perforce.team.ui.java.timelapse.JavaNodeModel;
import com.perforce.team.ui.java.timelapse.JavaOutlinePage;
import com.perforce.team.ui.java.timelapse.JavaTickDecorator;
import com.perforce.team.ui.java.timelapse.JavaUtils;
import com.perforce.team.ui.java.timelapse.Messages;
import com.perforce.team.ui.text.timelapse.IFilterNodeModel;
import com.perforce.team.ui.text.timelapse.INodeModel;
import com.perforce.team.ui.text.timelapse.NodeModelTimeLapseEditor;
import com.perforce.team.ui.text.timelapse.NodeOutlinePage;
import com.perforce.team.ui.text.timelapse.NodeTickDecorator;
import com.perforce.team.ui.text.timelapse.NodeTimeLapseEditor;
import com.perforce.team.ui.timelapse.IRevisionInputCache;
import java.util.Iterator;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;

public class JavaTimeLapseEditor
extends NodeModelTimeLapseEditor {
    public static final String ID = "com.perforce.team.ui.java.JavaTimeLapseEditor";
    private JavaSourceViewer viewer;
    private JavaFoldingProvider provider;

    protected NodeTickDecorator createNodeDecorator() {
        return new JavaTickDecorator((INodeModel)this.getModel());
    }

    protected IFilterNodeModel createNodeModel() {
        return new JavaNodeModel(this.getRevisions(), (IRevisionInputCache)this);
    }

    protected void enableProjection() {
        super.enableProjection();
        IVerticalRulerColumn column = null;
        CompositeRuler ruler = this.getRuler();
        if (ruler != null) {
            Iterator columnIterator = ruler.getDecoratorIterator();
            while (columnIterator.hasNext()) {
                column = (IVerticalRulerColumn)columnIterator.next();
            }
            if (column != null && column instanceof AnnotationRulerColumn) {
                column.getControl().setBackground(column.getControl().getDisplay().getSystemColor(1));
                column.getControl().redraw();
            }
        }
    }

    protected void fillToolbar(ToolBar toolbar) {
        super.fillToolbar(toolbar);
        this.configureLinking(toolbar, Messages.JavaTimeLapseEditor_LinkWithOutlineViewSelection);
    }

    protected void disableFolding() {
        if (this.provider != null) {
            this.provider.clearModel();
        }
        super.disableFolding();
    }

    public void showNode(Object node) {
        super.showNode(node);
        if (node != null && !(node instanceof IJavaElement)) {
            return;
        }
        if (node instanceof IMethod) {
            String id = this.getModel().getHandle(node);
            this.getFormatter().setFilter(id);
            this.getDecorator().setNodeId(id);
        } else {
            this.getFormatter().setFilter(null);
            this.getDecorator().setNodeId(null);
        }
        if (node instanceof ISourceReference) {
            try {
                ISourceRange sourceRange = ((ISourceReference)node).getSourceRange();
                if (sourceRange != null) {
                    this.showRange(new NodeTimeLapseEditor.Range(sourceRange.getOffset(), sourceRange.getLength()));
                }
                int offset = -1;
                int length = 0;
                if (node instanceof IMember) {
                    sourceRange = ((IMember)node).getNameRange();
                    if (sourceRange != null) {
                        offset = sourceRange.getOffset();
                        length = sourceRange.getLength();
                    }
                } else if (node instanceof ITypeParameter) {
                    sourceRange = ((ITypeParameter)node).getNameRange();
                    if (sourceRange != null) {
                        offset = sourceRange.getOffset();
                        length = sourceRange.getLength();
                    }
                } else if (node instanceof ILocalVariable) {
                    sourceRange = ((ILocalVariable)node).getNameRange();
                    if (sourceRange != null) {
                        offset = sourceRange.getOffset();
                        length = sourceRange.getLength();
                    }
                } else if (node instanceof IAnnotation && (sourceRange = ((IAnnotation)node).getNameRange()) != null) {
                    offset = sourceRange.getOffset();
                    length = sourceRange.getLength();
                }
                if (offset > -1 && length > 0) {
                    this.selectRange(new NodeTimeLapseEditor.Range(offset, length));
                }
            }
            catch (JavaModelException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
        }
    }

    protected void updateVisibleRange() {
        JavaNodeModel javaModel;
        IJavaElement element;
        if (this.isLinking() && !this.isFiltering() && this.selected != null && (element = (javaModel = (JavaNodeModel)this.getModel()).getJavaElement(this.getRevision(), javaModel.getHandle(this.selected))) != null) {
            if (this.outlinePage != null) {
                if (!this.outlinePage.isDisposed()) {
                    this.outlinePage.setSelection((ISelection)new StructuredSelection((Object)element));
                } else {
                    this.outlinePage = null;
                }
            }
            this.showNode(element);
            return;
        }
        super.updateVisibleRange();
    }

    protected void createViewer(Composite parent) {
        CompositeRuler ruler = this.configureRulers(true);
        IPreferenceStore store = JavaUtils.getPreferences();
        this.viewer = new JavaSourceViewer(parent, (IVerticalRuler)ruler, null, false, 0x2000300, store){

            public void setTopIndex(int index) {
                if (!JavaTimeLapseEditor.this.updatingDoc) {
                    super.setTopIndex(index);
                }
            }

            public void setSelectedRange(int selectionOffset, int selectionLength) {
                if (!JavaTimeLapseEditor.this.updatingDoc) {
                    super.setSelectedRange(selectionOffset, selectionLength);
                }
            }
        };
        ProjectionSupport support = new ProjectionSupport((ProjectionViewer)this.viewer, (IAnnotationAccess)new DefaultMarkerAnnotationAccess(), this.getSharedTextColors());
        support.install();
        this.provider = new JavaFoldingProvider((ProjectionViewer)this.viewer, support);
        JavaTextTools tools = JavaUtils.getTools();
        if (tools != null) {
            this.viewer.configure((SourceViewerConfiguration)new JavaSourceViewerConfiguration(tools.getColorManager(), store, null, "___java_partitioning"));
        }
        this.configureViewer("org.eclipse.jdt.ui.editors.textfont");
    }

    protected void dispose(IEditorInput input) {
        super.dispose(input);
        JavaUtils.getProvider().disconnect((Object)input);
    }

    protected ITextViewer getViewer() {
        return this.viewer;
    }

    protected String getFilterLabel() {
        return Messages.JavaTimeLapseEditor_Methods;
    }

    protected String getNodeLabel() {
        return "method";
    }

    protected NodeTimeLapseEditor.Range getRange(String filterKey) {
        NodeTimeLapseEditor.Range range = null;
        IJavaElement method = ((JavaNodeModel)this.getModel()).getJavaElement(this.getRevision(), filterKey);
        if (method instanceof ISourceReference) {
            try {
                ISourceRange sourceRange = ((ISourceReference)method).getSourceRange();
                if (sourceRange != null) {
                    range = new NodeTimeLapseEditor.Range(sourceRange.getOffset(), sourceRange.getLength());
                }
            }
            catch (JavaModelException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
        }
        return range;
    }

    protected void buildDocument(IEditorInput input) {
        this.provider.install((IJavaElement)this.root);
        super.buildDocument(input);
    }

    protected NodeOutlinePage createOutlinePage() {
        return new JavaOutlinePage((IJavaElement)this.getRoot(), (INodeModel)this.getModel());
    }

    protected IDocument getDocument(IEditorInput input) {
        return JavaUtils.getProvider().getDocument((Object)input);
    }

    protected void installPartitioner(IDocument document) {
        JavaTextTools tools = JavaUtils.getTools();
        if (tools != null) {
            tools.setupJavaDocumentPartitioner(document, "___java_partitioning");
        }
    }
}

