/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.java.timelapse;

import com.perforce.p4java.server.PerforceCharsets;
import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Revision;
import com.perforce.team.ui.java.timelapse.JavaUtils;
import com.perforce.team.ui.text.timelapse.IFilterNodeModel;
import com.perforce.team.ui.text.timelapse.NodeModel;
import com.perforce.team.ui.timelapse.IRevisionInputCache;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.ui.IEditorInput;

public class JavaNodeModel
extends NodeModel
implements IFilterNodeModel {
    public static final String JAVA_SUFFIX = ".java";
    public static final int JAVA_SUFFIX_LENGTH = ".java".length();
    private Map<String, String> methodList = new TreeMap<String, String>();

    public JavaNodeModel(IP4Revision[] revisions, IRevisionInputCache inputCache) {
        super(revisions, inputCache);
    }

    public String getFilterKey(String filterLabel) {
        return this.methodList.get(filterLabel);
    }

    public Collection<String> getFilterLabels() {
        return this.methodList.keySet();
    }

    public IJavaElement getJavaElement(IP4Revision revision, String id) {
        return (IJavaElement)this.getElement(revision, id);
    }

    private String getMethodDisplay(IMethod method) {
        IMember member;
        StringBuffer buffer = new StringBuffer();
        JavaElementLabels.getElementLabel((IJavaElement)method, (long)257L, (StringBuffer)buffer);
        if (method.getParent() instanceof IMember && ((member = (IMember)method.getParent()).getElementName() == null || member.getElementName().length() == 0)) {
            buffer.append('$');
            buffer.append(member.getOccurrenceCount());
        }
        return buffer.toString();
    }

    private String getFileClassHandle(IJavaElement element) {
        String fileName;
        ICompilationUnit unit;
        String handle = element.getHandleIdentifier();
        if (element instanceof IMethod && (unit = ((IMethod)element).getCompilationUnit()) != null && (fileName = unit.getElementName()).endsWith(JAVA_SUFFIX)) {
            String className = fileName.substring(0, fileName.length() - JAVA_SUFFIX_LENGTH);
            String fileClassMatch = String.valueOf(fileName) + '[' + className;
            if (handle.contains(fileClassMatch)) {
                handle = handle.replace(fileClassMatch, "");
            }
        }
        return handle;
    }

    public void findNodes(Object nodeInput, IP4Revision revision) {
        this.walkTree((IJavaElement)nodeInput, revision);
    }

    private void walkTree(IJavaElement node, IP4Revision revision) {
        try {
            IParent parent;
            ISourceReference reference;
            String content;
            String key = null;
            if (node instanceof IMethod) {
                IMethod method = (IMethod)node;
                key = this.getFileClassHandle((IJavaElement)method);
                String display = this.getMethodDisplay(method);
                this.methodList.put(display, key);
            }
            if (node instanceof ISourceReference && (content = (reference = (ISourceReference)node).getSource()) != null) {
                int hash = this.computeHash(content, P4CoreUtils.charsetForName((String)PerforceCharsets.getJavaCharsetName((String)revision.getCharset())));
                String key2 = null;
                if (key == null) {
                    key = node.getHandleIdentifier();
                } else {
                    key2 = node.getHandleIdentifier();
                }
                this.addRecord(hash, key, key2, node, revision);
            }
            if (node instanceof IParent && (parent = (IParent)node).hasChildren()) {
                IJavaElement[] iJavaElementArray = parent.getChildren();
                int n = iJavaElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElement child = iJavaElementArray[n2];
                    this.walkTree(child, revision);
                    ++n2;
                }
            }
        }
        catch (JavaModelException e) {
            PerforceProviderPlugin.logError((Throwable)e);
        }
    }

    public Object parseInput(IEditorInput input, IP4Revision revision) {
        if (JavaUtils.getProvider().getDocument((Object)input) == null) {
            try {
                JavaUtils.getProvider().connect((Object)input);
            }
            catch (CoreException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
        }
        return JavaUtils.getWorkingCopy(input);
    }

    public String getHandle(Object element) {
        return element instanceof IJavaElement ? this.getFileClassHandle((IJavaElement)element) : null;
    }
}

