/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.wizards.mapping;

import com.perforce.team.core.mergequest.model.Branch;
import com.perforce.team.core.mergequest.model.IBranchGraph;
import com.perforce.team.core.mergequest.model.Mapping;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.ui.IErrorDisplay;
import com.perforce.team.ui.IErrorProvider;
import com.perforce.team.ui.mergequest.wizards.branch.BranchAssistant;
import com.perforce.team.ui.mergequest.wizards.branch.BranchDescriptor;
import com.perforce.team.ui.mergequest.wizards.branch.BranchNameArea;
import com.perforce.team.ui.mergequest.wizards.mapping.IMappingArea;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class MappingWizardPage
extends WizardPage
implements IErrorDisplay {
    private Branch initialSource;
    private Branch initialTarget;
    private Composite displayArea;
    private IMappingArea mappingArea;
    private IBranchGraph graph;
    private boolean inSession = false;
    private Mapping existing = null;

    public MappingWizardPage(String pageName, IBranchGraph graph) {
        super(pageName);
        this.graph = graph;
    }

    public void setExistingMapping(Mapping mapping) {
        this.existing = mapping;
    }

    public IMappingArea getMappingArea() {
        return this.mappingArea;
    }

    protected abstract IMappingArea createMappingArea(IBranchGraph var1, IP4Connection var2);

    protected void hookCompletionListener(BranchNameArea area) {
        BranchAssistant assistant;
        if (area != null && (assistant = area.getAssistant()) != null) {
            assistant.addCompletionListener(new ICompletionListener(){

                public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
                }

                public void assistSessionStarted(ContentAssistEvent event) {
                    MappingWizardPage.this.inSession = true;
                    MappingWizardPage.this.setPageComplete(false);
                }

                public void assistSessionEnded(ContentAssistEvent event) {
                    MappingWizardPage.this.inSession = false;
                    MappingWizardPage.this.setPageComplete(MappingWizardPage.this.getErrorMessage() == null);
                }
            });
        }
    }

    public void createControl(Composite parent) {
        this.displayArea = new Composite(parent, 0);
        this.displayArea.setLayout((Layout)new GridLayout(1, true));
        GridData daData = new GridData(4, 4, true, true);
        this.displayArea.setLayoutData((Object)daData);
        this.mappingArea = this.createMappingArea(this.graph, this.graph.getConnection());
        this.mappingArea.setExistingMapping(this.existing);
        this.mappingArea.setSource(this.initialSource);
        this.mappingArea.setTarget(this.initialTarget);
        this.mappingArea.createControl(this.displayArea, this.getContainer());
        this.mappingArea.setErrorDisplay(this);
        this.mappingArea.validate();
        this.setPageComplete(this.getErrorMessage() == null);
        this.setErrorMessage(null);
        this.hookCompletionListener(this.mappingArea.getSourceArea());
        this.hookCompletionListener(this.mappingArea.getTargetArea());
        this.setControl((Control)this.displayArea);
    }

    public Mapping createMapping() {
        return this.mappingArea.createMapping();
    }

    public void setSource(Branch source) {
        this.initialSource = source;
    }

    public void setTarget(Branch target) {
        this.initialTarget = target;
    }

    public void setErrorMessage(String message, IErrorProvider provider) {
        if (this.inSession) {
            this.setPageComplete(false);
        } else {
            this.setPageComplete(message == null);
        }
        this.setErrorMessage(message);
    }

    public BranchDescriptor getSourceDescriptor() {
        return this.mappingArea.getSourceDescriptor();
    }

    public BranchDescriptor getTargetDescriptor() {
        return this.mappingArea.getTargetDescriptor();
    }

    public Branch getSourceSelection() {
        return this.mappingArea.getSourceSelection();
    }

    public Branch getTargetSelection() {
        return this.mappingArea.getTargetSelection();
    }
}

