/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.wizards.io;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.mergequest.builder.IBranchGraphBuilder;
import com.perforce.team.core.mergequest.model.BranchGraph;
import com.perforce.team.core.mergequest.model.IBranchGraph;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.mergequest.wizards.io.CheckboxBranchGraphViewer;
import com.perforce.team.ui.mergequest.wizards.io.ImportBranchGraphWizard;
import com.perforce.team.ui.mergequest.wizards.io.Messages;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ImportSelectionPage
extends WizardPage {
    private CheckboxBranchGraphViewer viewer;
    private IBranchGraph[] selected = new IBranchGraph[0];
    private IBranchGraph[] graphs = new IBranchGraph[0];

    public ImportSelectionPage() {
        super("importSelection");
        this.setTitle(Messages.ImportSelectionPage_Title);
        this.setDescription(Messages.ImportSelectionPage_Description);
    }

    public IBranchGraph[] getGraphs() {
        return this.selected;
    }

    private void validate() {
        String message = null;
        if (message == null && this.selected.length == 0) {
            message = Messages.ImportSelectionPage_Description;
        }
        this.setPageComplete(message == null);
        this.setErrorMessage(message);
    }

    private void showLoadError(Throwable e) {
        if (e.getCause() != null) {
            e = e.getCause();
        }
        final String message = MessageFormat.format(Messages.ImportSelectionPage_LoadErrorMessage, e.getClass().getCanonicalName(), e.getLocalizedMessage());
        PerforceUIPlugin.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                P4ConnectionManager.getManager().openError(P4UIUtils.getDialogShell(), Messages.ImportSelectionPage_ErrorLoadingPages, message);
            }
        });
    }

    public void setVisible(boolean visible) {
        if (visible) {
            final IBranchGraphBuilder builder = ((ImportBranchGraphWizard)this.getWizard()).getBuilder();
            try {
                this.getContainer().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(Messages.ImportSelectionPage_LoadingGraphs, 1);
                        if (builder != null) {
                            try {
                                ImportSelectionPage.this.graphs = builder.load().getGraphs();
                            }
                            catch (IOException e) {
                                ImportSelectionPage.this.graphs = new IBranchGraph[0];
                                ImportSelectionPage.this.showLoadError(e);
                            }
                        }
                        monitor.worked(1);
                        monitor.done();
                    }
                });
            }
            catch (InvocationTargetException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
            catch (InterruptedException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
            this.viewer.getViewer().setInput((Object)this.graphs);
            this.viewer.getViewer().setAllChecked(true);
            this.updateChecked();
        } else {
            this.setPageComplete(false);
        }
        super.setVisible(visible);
    }

    private void updateChecked() {
        ArrayList<BranchGraph> graphSelections = new ArrayList<BranchGraph>();
        Object[] objectArray = this.viewer.getViewer().getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object selected = objectArray[n2];
            if (selected instanceof BranchGraph) {
                graphSelections.add((BranchGraph)selected);
            }
            ++n2;
        }
        this.selected = (IBranchGraph[])graphSelections.toArray(new BranchGraph[graphSelections.size()]);
        this.validate();
    }

    public void createControl(Composite parent) {
        Composite displayArea = new Composite(parent, 0);
        GridLayout daLayout = new GridLayout(1, true);
        displayArea.setLayout((Layout)daLayout);
        GridData daData = new GridData(4, 4, true, true);
        displayArea.setLayoutData((Object)daData);
        new Label(displayArea, 0).setText(Messages.ImportSelectionPage_AvailableGraphs);
        this.viewer = new CheckboxBranchGraphViewer(this.graphs);
        this.viewer.createControl(displayArea);
        this.viewer.getViewer().addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ImportSelectionPage.this.updateChecked();
            }
        });
        this.setControl((Control)displayArea);
        this.setPageComplete(false);
    }
}

