/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.properties;

import com.perforce.team.core.mergequest.model.Branch;
import com.perforce.team.core.mergequest.model.Mapping;
import com.perforce.team.ui.mergequest.properties.Messages;
import java.util.ArrayList;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class MappingPropertySource
implements IPropertySource {
    public static final String SOURCE_NAME = "SOURCE_NAME";
    public static final String TARGET_NAME = "TARGET_NAME";
    public static final String ID = "id";
    private IPropertyDescriptor[] descriptors = null;
    private Mapping mapping;

    public MappingPropertySource(Mapping mapping) {
        this.mapping = mapping;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.descriptors == null) {
            ArrayList<PropertyDescriptor> descriptorList = new ArrayList<PropertyDescriptor>();
            descriptorList.add(new PropertyDescriptor((Object)"name", Messages.MappingPropertySource_Name));
            descriptorList.add(new PropertyDescriptor((Object)SOURCE_NAME, Messages.MappingPropertySource_SourceName));
            descriptorList.add(new PropertyDescriptor((Object)TARGET_NAME, Messages.MappingPropertySource_TargetName));
            descriptorList.add(new PropertyDescriptor((Object)"latestSourceChange", Messages.MappingPropertySource_LatestSource));
            descriptorList.add(new PropertyDescriptor((Object)"latestTargetChange", Messages.MappingPropertySource_LatestTarget));
            descriptorList.add(new PropertyDescriptor((Object)"sourceChangeCount", Messages.MappingPropertySource_SourceCount));
            descriptorList.add(new PropertyDescriptor((Object)"targetChangeCount", Messages.MappingPropertySource_TargetCount));
            descriptorList.add(new PropertyDescriptor((Object)"direction", Messages.MappingPropertySource_Direction));
            descriptorList.add(new PropertyDescriptor((Object)ID, Messages.MappingPropertySource_Id));
            this.descriptors = descriptorList.toArray(new IPropertyDescriptor[descriptorList.size()]);
        }
        return this.descriptors;
    }

    public Object getPropertyValue(Object id) {
        Object value = null;
        if ("name".equals(id)) {
            value = this.mapping.getName();
        } else if ("latestSourceChange".equals(id)) {
            value = this.mapping.getLatestSource();
        } else if ("latestTargetChange".equals(id)) {
            value = this.mapping.getLatestTarget();
        } else if ("sourceChangeCount".equals(id)) {
            value = this.mapping.getTargetToSourceCount();
        } else if ("targetChangeCount".equals(id)) {
            value = this.mapping.getSourceToTargetCount();
        } else if ("direction".equals(id)) {
            value = this.mapping.getDirection().toString();
        } else if (SOURCE_NAME.equals(id)) {
            Branch branch = this.mapping.getSource();
            if (branch != null) {
                value = branch.getName();
            }
        } else if (TARGET_NAME.equals(id)) {
            Branch branch = this.mapping.getTarget();
            if (branch != null) {
                value = branch.getName();
            }
        } else if (ID.equals(id)) {
            value = this.mapping.getId();
        }
        return value;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

