/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.properties;

import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.mergequest.model.Branch;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.mergequest.commands.BranchConstraintCommand;
import com.perforce.team.ui.mergequest.properties.Messages;
import java.util.ArrayList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class BranchPropertySource
implements IPropertySource {
    public static final String NAME = "name";
    public static final String X = "x";
    public static final String Y = "y";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String TYPE = "type";
    public static final String ID = "id";
    private Branch branch = null;
    private IPropertyDescriptor[] descriptors = null;

    public BranchPropertySource(Branch branch) {
        this.branch = branch;
    }

    public Object getEditableValue() {
        return this.branch;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.descriptors == null) {
            ArrayList<Object> descriptorList = new ArrayList<Object>();
            descriptorList.add(new PropertyDescriptor((Object)NAME, Messages.BranchPropertySource_Name));
            descriptorList.add(new TextPropertyDescriptor((Object)X, Messages.BranchPropertySource_X));
            descriptorList.add(new TextPropertyDescriptor((Object)Y, Messages.BranchPropertySource_Y));
            descriptorList.add(new TextPropertyDescriptor((Object)WIDTH, Messages.BranchPropertySource_Width));
            descriptorList.add(new TextPropertyDescriptor((Object)HEIGHT, Messages.BranchPropertySource_Height));
            descriptorList.add(new PropertyDescriptor((Object)TYPE, Messages.BranchPropertySource_Type));
            descriptorList.add(new PropertyDescriptor((Object)ID, Messages.BranchPropertySource_Id));
            this.descriptors = descriptorList.toArray(new IPropertyDescriptor[descriptorList.size()]);
        }
        return this.descriptors;
    }

    public Object getPropertyValue(Object id) {
        Object value = null;
        if (NAME.equals(id)) {
            value = this.branch.getName();
        } else if (X.equals(id)) {
            value = this.branch.getX();
        } else if (Y.equals(id)) {
            value = this.branch.getY();
        } else if (WIDTH.equals(id)) {
            value = this.branch.getWidth();
        } else if (HEIGHT.equals(id)) {
            value = this.branch.getHeight();
        } else if (TYPE.equals(id)) {
            value = this.branch.getType();
        } else if (ID.equals(id)) {
            value = this.branch.getId();
        }
        if (value != null) {
            value = value.toString();
        }
        return value;
    }

    public boolean isPropertySet(Object id) {
        return true;
    }

    public void resetPropertyValue(Object id) {
    }

    private Integer getInteger(Object value) {
        Integer integer = null;
        if (value != null) {
            try {
                integer = Integer.valueOf(value.toString());
            }
            catch (NumberFormatException numberFormatException) {
                integer = null;
            }
        }
        return integer;
    }

    private void updateSize(int width, int height) {
        this.changeConstraints("resize", this.branch.getX(), this.branch.getY(), width, height);
    }

    private void updateLocation(int x, int y) {
        this.changeConstraints("move", x, y, this.branch.getWidth(), this.branch.getHeight());
    }

    private void changeConstraints(String type, int x, int y, int width, int height) {
        Rectangle rectangle = new Rectangle(x, y, width, height);
        BranchConstraintCommand command = new BranchConstraintCommand(this.branch, new ChangeBoundsRequest((Object)type), rectangle);
        CommandStack stack = (CommandStack)P4CoreUtils.convert((Object)PerforceUIPlugin.getActivePage().getActiveEditor(), CommandStack.class);
        if (stack != null) {
            stack.execute((Command)command);
        } else {
            command.execute();
        }
    }

    public void setPropertyValue(Object id, Object value) {
        Integer intValue;
        if (X.equals(id)) {
            Integer intValue2 = this.getInteger(value);
            if (intValue2 != null) {
                this.updateLocation(intValue2, this.branch.getY());
            }
        } else if (Y.equals(id)) {
            Integer intValue3 = this.getInteger(value);
            if (intValue3 != null) {
                this.updateLocation(this.branch.getX(), intValue3);
            }
        } else if (WIDTH.equals(id)) {
            Integer intValue4 = this.getInteger(value);
            if (intValue4 != null) {
                this.updateSize(intValue4, this.branch.getHeight());
            }
        } else if (HEIGHT.equals(id) && (intValue = this.getInteger(value)) != null) {
            this.updateSize(this.branch.getWidth(), intValue);
        }
    }
}

