/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.editor.palette;

import com.perforce.team.core.mergequest.P4BranchGraphCorePlugin;
import com.perforce.team.core.mergequest.model.registry.BranchType;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.mergequest.BranchWorkbenchAdapter;
import com.perforce.team.ui.mergequest.P4BranchGraphPlugin;
import com.perforce.team.ui.mergequest.descriptors.DescriptorRegistry;
import com.perforce.team.ui.mergequest.descriptors.ElementDescriptor;
import com.perforce.team.ui.mergequest.editor.palette.Messages;
import com.perforce.team.ui.mergequest.requests.BranchCreationFactory;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PanningSelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.resource.ImageDescriptor;

public class BranchGraphPaletteRoot
extends PaletteRoot {
    public BranchGraphPaletteRoot() {
        this.add((PaletteEntry)this.getBranchesDrawer());
        this.add((PaletteEntry)this.getMappingsDrawer());
        this.add((PaletteEntry)this.getToolsContainer());
    }

    private PaletteContainer getMappingsDrawer() {
        PaletteDrawer tools = new PaletteDrawer(Messages.BranchGraphPaletteRoot_BranchMappingsDrawer, P4BranchGraphPlugin.getImageDescriptor("icons/connectors_drawer.png"));
        ImageDescriptor mappingToolDescriptor = PerforceUIPlugin.getDescriptor((String)"normal/branch.png");
        ConnectionCreationToolEntry mappingTool = new ConnectionCreationToolEntry(Messages.BranchGraphPaletteRoot_BranchSpecTool, Messages.BranchGraphPaletteRoot_BranchSpecToolDescription, new CreationFactory(){

            public Object getNewObject() {
                return null;
            }

            public Object getObjectType() {
                return "branchSpec";
            }
        }, mappingToolDescriptor, mappingToolDescriptor);
        tools.add((PaletteEntry)mappingTool);
        ImageDescriptor depotPathMappingToolDescriptor = P4BranchGraphPlugin.getImageDescriptor("icons/depotPath.png");
        ConnectionCreationToolEntry depotPathMappingTool = new ConnectionCreationToolEntry(Messages.BranchGraphPaletteRoot_DepotPathTool, Messages.BranchGraphPaletteRoot_DepotPathToolDescription, new CreationFactory(){

            public Object getNewObject() {
                return null;
            }

            public Object getObjectType() {
                return "depotPath";
            }
        }, depotPathMappingToolDescriptor, depotPathMappingToolDescriptor);
        tools.add((PaletteEntry)depotPathMappingTool);
        return tools;
    }

    private PaletteContainer getToolsContainer() {
        PaletteDrawer tools = new PaletteDrawer(Messages.BranchGraphPaletteRoot_ToolsDrawer);
        PanningSelectionToolEntry selectionTool = new PanningSelectionToolEntry(Messages.BranchGraphPaletteRoot_SelectTool, Messages.BranchGraphPaletteRoot_SelectToolDescription);
        tools.add((PaletteEntry)selectionTool);
        this.setDefaultEntry((ToolEntry)selectionTool);
        MarqueeToolEntry marqueeTool = new MarqueeToolEntry(Messages.BranchGraphPaletteRoot_MarqueTool, Messages.BranchGraphPaletteRoot_MarqueToolDescription);
        tools.add((PaletteEntry)marqueeTool);
        return tools;
    }

    private PaletteContainer getBranchesDrawer() {
        PaletteDrawer drawer = new PaletteDrawer(Messages.BranchGraphPaletteRoot_BranchesDrawer, P4BranchGraphPlugin.getImageDescriptor("icons/codeline_drawer.png"));
        DescriptorRegistry descriptors = BranchWorkbenchAdapter.getDescriptorRegistry();
        BranchType[] types = P4BranchGraphCorePlugin.getDefault().getBranchRegistry().getTypes();
        Arrays.sort(types, new Comparator<BranchType>(){

            @Override
            public int compare(BranchType o1, BranchType o2) {
                return o1.getLabel().compareToIgnoreCase(o2.getLabel());
            }
        });
        BranchType[] branchTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            BranchType type = branchTypeArray[n2];
            ElementDescriptor descriptor = descriptors.getDescriptor(type.getType());
            String branchLabel = type.getLabel();
            ImageDescriptor icon = null;
            String details = "";
            if (descriptor != null) {
                icon = descriptor.getIcon();
                details = descriptor.getDescription();
            }
            BranchCreationFactory creationFactory = new BranchCreationFactory(type);
            CombinedTemplateCreationEntry stagingComponent = new CombinedTemplateCreationEntry(branchLabel, details, (Object)creationFactory, (CreationFactory)creationFactory, icon, icon);
            drawer.add((PaletteEntry)stagingComponent);
            ++n2;
        }
        return drawer;
    }
}

