/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.editor.outline;

import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.mergequest.model.IBranchGraphElement;
import com.perforce.team.core.mergequest.model.Mapping;
import com.perforce.team.ui.mergequest.editor.IBranchGraphPage;
import com.perforce.team.ui.mergequest.editor.outline.MappingProxy;
import java.util.ArrayList;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;

public class SelectionSynchronizer
implements ISelectionChangedListener {
    private StructuredViewer base;
    private EditPartViewer extension;
    private boolean inUpdate = false;

    public SelectionSynchronizer(StructuredViewer base) {
        this.base = base;
        this.base.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void dispose() {
        this.base.removeSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void register(IBranchGraphPage page) {
        if (this.extension != null) {
            this.extension.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.extension = (EditPartViewer)P4CoreUtils.convert((Object)page, EditPartViewer.class);
        if (this.extension != null) {
            this.extension.addSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    private Object[] convertToParts(Object[] selection) {
        ArrayList<EditPart> converted = new ArrayList<EditPart>();
        Object[] objectArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            EditPart part;
            Object selected = objectArray[n2];
            IBranchGraphElement element = (IBranchGraphElement)P4CoreUtils.convert((Object)selected, IBranchGraphElement.class);
            if (element != null && (part = (EditPart)this.extension.getEditPartRegistry().get(element)) != null) {
                converted.add(part);
            }
            ++n2;
        }
        return converted.toArray();
    }

    private Object[] convertToElements(Object[] selection) {
        ArrayList<Object> converted = new ArrayList<Object>();
        Object[] objectArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            Object selected = objectArray[n2];
            IBranchGraphElement element = (IBranchGraphElement)P4CoreUtils.convert((Object)selected, IBranchGraphElement.class);
            if (element != null) {
                if (element instanceof Mapping) {
                    MappingProxy.addProxies((Mapping)element, converted);
                } else {
                    converted.add(element);
                }
            }
            ++n2;
        }
        return converted.toArray();
    }

    private void sync(ISelectionProvider provider, IStructuredSelection newSelection) {
        this.inUpdate = true;
        try {
            if (provider == this.base) {
                StructuredSelection converted = new StructuredSelection(this.convertToParts(newSelection.toArray()));
                this.extension.setSelection((ISelection)converted);
            } else if (provider == this.extension) {
                StructuredSelection converted = new StructuredSelection(this.convertToElements(newSelection.toArray()));
                this.base.setSelection((ISelection)converted, true);
            }
        }
        finally {
            this.inUpdate = false;
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.inUpdate || this.extension == null) {
            return;
        }
        this.sync(event.getSelectionProvider(), (IStructuredSelection)event.getSelection());
    }
}

