/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.editor.outline;

import com.perforce.team.core.mergequest.model.Branch;
import com.perforce.team.core.mergequest.model.Mapping;
import com.perforce.team.ui.LabelDecoratorAdapter;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.StyledLabelProvider;
import com.perforce.team.ui.mergequest.BranchWorkbenchAdapter;
import com.perforce.team.ui.mergequest.MappingWorkbenchAdapter;
import com.perforce.team.ui.mergequest.editor.outline.MappingProxy;
import com.perforce.team.ui.mergequest.editor.outline.Messages;
import java.text.MessageFormat;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class BranchMappingLabelProvider {
    private TreeViewer viewer;
    private WorkbenchLabelProvider wrapper;
    private Font bold;
    private DelegatingStyledCellLabelProvider.IStyledLabelProvider styledLabelProvider;
    private ILabelDecorator decorator = new LabelDecoratorAdapter(){

        public String decorateText(String text, Object element) {
            if (element instanceof MappingProxy) {
                Mapping mapping = ((MappingProxy)((Object)element)).getMapping();
                return MessageFormat.format(Messages.BranchMappingLabelProvider_MappingDetails, text, mapping.getName());
            }
            return text;
        }
    };

    public BranchMappingLabelProvider(TreeViewer viewer) {
        this.viewer = viewer;
        this.wrapper = new WorkbenchLabelProvider();
        this.styledLabelProvider = new StyledLabelProvider((ILabelProvider)this.wrapper){
            StyledString.Styler boldStyler;
            {
                this.boldStyler = new StyledString.Styler(){

                    public void applyStyles(TextStyle textStyle) {
                        textStyle.font = BranchMappingLabelProvider.this.bold;
                    }
                };
            }

            public StyledString getStyledText(Object element) {
                StyledString styled = new StyledString();
                if (element instanceof Branch) {
                    Branch branch = (Branch)element;
                    String text = BranchMappingLabelProvider.this.wrapper.getText(element);
                    if (BranchWorkbenchAdapter.isImportant(branch.getType())) {
                        styled.append(text, this.boldStyler);
                    } else {
                        styled.append(text);
                    }
                    styled.append(MessageFormat.format(Messages.BranchMappingLabelProvider_Count, branch.getMappingCount()), StyledString.COUNTER_STYLER);
                } else if (element instanceof MappingWorkbenchAdapter.DepotPath) {
                    MappingWorkbenchAdapter.DepotPath path = (MappingWorkbenchAdapter.DepotPath)((Object)element);
                    styled.append(path.getName());
                    styled.append(" : ", StyledString.QUALIFIER_STYLER);
                    styled.append(this.getText(element), StyledString.QUALIFIER_STYLER);
                } else {
                    styled.append(super.getStyledText(element));
                }
                return styled;
            }

            public void dispose() {
                super.dispose();
                BranchMappingLabelProvider.this.bold.dispose();
            }
        };
        this.bold = P4UIUtils.generateBoldFont((Device)viewer.getTree().getDisplay(), (Font)viewer.getTree().getFont());
        DecoratingStyledCellLabelProvider labelProvider = new DecoratingStyledCellLabelProvider(this.styledLabelProvider, this.decorator, null);
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
    }
}

