/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.editor;

import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.mergequest.builder.IBranchGraphBuilder;
import com.perforce.team.core.mergequest.model.BranchSpecMapping;
import com.perforce.team.core.mergequest.model.IBranchGraph;
import com.perforce.team.core.mergequest.model.Mapping;
import com.perforce.team.core.mergequest.processor.InterchangesProcessor;
import com.perforce.team.core.p4java.IP4ConnectionProvider;
import com.perforce.team.ui.mergequest.P4BranchGraphPlugin;
import com.perforce.team.ui.mergequest.editor.BranchGraphEditor;
import com.perforce.team.ui.mergequest.editor.GraphContextMenuProvider;
import com.perforce.team.ui.mergequest.editor.IBranchGraphPage;
import com.perforce.team.ui.mergequest.editor.palette.BranchGraphPalettePage;
import com.perforce.team.ui.mergequest.editor.palette.BranchGraphPaletteRoot;
import com.perforce.team.ui.mergequest.editor.palette.BranchGraphPaletteViewerProvider;
import com.perforce.team.ui.mergequest.editor.palette.IFlyoutPaletteProvider;
import com.perforce.team.ui.mergequest.figures.theme.FigureThemeHelper;
import com.perforce.team.ui.mergequest.parts.BranchGraphEditPartFactory;
import com.perforce.team.ui.mergequest.parts.BranchGraphViewer;
import com.perforce.team.ui.mergequest.parts.SharedResources;
import java.beans.PropertyChangeListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.dnd.TemplateTransferDropTargetListener;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.views.palette.PalettePage;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;

public class BranchGraphPage
extends FormPage
implements IBranchGraphPage,
IPropertyChangeListener,
IFlyoutPaletteProvider {
    private IBranchGraphBuilder builder;
    private IBranchGraph graph;
    private InterchangesProcessor processor;
    private Composite displayArea;
    private BranchGraphViewer graphViewer;
    private BranchGraphEditor editor;
    private ScalableFreeformRootEditPart rootEditPart;
    private EditDomain domain;
    private PaletteRoot root;
    private PaletteViewerProvider provider;
    private FlyoutPaletteComposite splitter;
    private BranchGraphPalettePage page;
    private SharedResources sharedResources = new SharedResources();
    private PropertyChangeListener builderListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(java.beans.PropertyChangeEvent evt) {
            String property = evt.getPropertyName();
            if ("sourceMappings".equals(property)) {
                boolean newMapping = false;
                Mapping mapping = (Mapping)evt.getNewValue();
                if (mapping == null) {
                    mapping = (Mapping)evt.getOldValue();
                } else {
                    newMapping = true;
                }
                if (newMapping) {
                    BranchGraphPage.this.refreshStatus(mapping);
                }
            } else if ("direction".equals(property)) {
                Mapping mapping = (Mapping)evt.getSource();
                BranchGraphPage.this.refreshStatus(mapping);
            } else if ("name".equals(property) && evt.getSource() instanceof BranchSpecMapping) {
                BranchGraphPage.this.refreshStatus((Mapping)evt.getSource());
            }
            BranchGraphPage.this.editor.persist();
        }
    };

    public BranchGraphPage(BranchGraphEditor editor, IBranchGraph graph, IBranchGraphBuilder builder) {
        super((FormEditor)editor, "branchGraphPage" + graph.getName(), graph.getName());
        this.editor = editor;
        this.graph = graph;
        this.builder = builder;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    private void refreshStatus() {
        this.refreshStatus(this.graph.getMappings());
    }

    private void refreshStatus(Mapping mapping) {
        if (mapping != null) {
            this.refreshStatus(new Mapping[]{mapping});
        }
    }

    private void refreshStatus(Mapping[] mappings) {
        this.processor.refresh(mappings);
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.processor = new InterchangesProcessor((IP4ConnectionProvider)this.editor, this.graph);
    }

    @Override
    public Composite getControl() {
        return this.displayArea;
    }

    @Override
    public void setSelection(ISelection selection) {
    }

    protected void createFormContent(IManagedForm managedForm) {
        Composite parent = managedForm.getForm().getBody();
        GridLayout pLayout = new GridLayout(1, true);
        pLayout.marginHeight = 0;
        pLayout.marginWidth = 0;
        parent.setLayout((Layout)pLayout);
        this.displayArea = new Composite(parent, 0);
        this.displayArea.setBackground(this.displayArea.getDisplay().getSystemColor(1));
        this.displayArea.setBackgroundMode(1);
        GridLayout daLayout = new GridLayout(1, true);
        daLayout.marginHeight = 0;
        daLayout.marginWidth = 0;
        this.displayArea.setLayout((Layout)daLayout);
        GridData daData = new GridData(4, 4, true, true);
        this.displayArea.setLayoutData((Object)daData);
        this.displayArea.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                BranchGraphPage.this.sharedResources.dispose();
            }
        });
        this.createGraphicalViewer(this.displayArea);
        this.graph.addPropertyListener(this.builderListener);
        P4BranchGraphPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.refreshStatus();
    }

    private EditDomain getEditDomain() {
        if (this.domain == null) {
            this.domain = new DefaultEditDomain((IEditorPart)this);
        }
        return this.domain;
    }

    private PaletteViewerProvider getPaletteViewerProvider() {
        if (this.provider == null) {
            this.provider = new BranchGraphPaletteViewerProvider(this.getEditDomain());
        }
        return this.provider;
    }

    private PaletteRoot getPaletteRoot() {
        if (this.root == null) {
            this.root = new BranchGraphPaletteRoot();
        }
        return this.root;
    }

    private void createGraphicalViewer(Composite parent) {
        this.splitter = new FlyoutPaletteComposite(parent, 0, this.getSite().getPage(), this.getPaletteViewerProvider(), BranchGraphPaletteViewerProvider.getPalettePreferences());
        this.splitter.setLayoutData((Object)new GridData(4, 4, true, true));
        this.graphViewer = new BranchGraphViewer();
        this.graphViewer.setProperty("SnapToGrid.GridSpacing", new Dimension(10, 10));
        this.graphViewer.createControl((Composite)this.splitter);
        EditDomain domain = this.getEditDomain();
        domain.setPaletteRoot(this.getPaletteRoot());
        domain.getCommandStack().addCommandStackListener((CommandStackListener)this.editor.getRegistry());
        this.graphViewer.addSelectionChangedListener(this.editor.getRegistry());
        domain.addViewer((EditPartViewer)this.graphViewer);
        this.graphViewer.getControl().setBackground(parent.getBackground());
        this.graphViewer.setEditPartFactory(new BranchGraphEditPartFactory(this.graph, this.sharedResources));
        this.rootEditPart = new ScalableFreeformRootEditPart();
        this.graphViewer.setRootEditPart((RootEditPart)this.rootEditPart);
        FigureThemeHelper bgHelper = new FigureThemeHelper();
        IFigure rootFigure = this.rootEditPart.getFigure();
        rootFigure.setOpaque(true);
        bgHelper.setFigure(rootFigure);
        bgHelper.setBackgroundKey("com.perforce.team.ui.mergequest.background.graph");
        bgHelper.activate();
        FigureThemeHelper gridHelper = new FigureThemeHelper();
        gridHelper.setFigure(this.rootEditPart.getLayer((Object)"Grid Layer"));
        gridHelper.setForegroundKey("com.perforce.team.ui.mergequest.foreground.grid");
        gridHelper.activate();
        this.graphViewer.setKeyHandler((KeyHandler)new GraphicalViewerKeyHandler((GraphicalViewer)this.graphViewer));
        ActionRegistry registry = (ActionRegistry)P4CoreUtils.convert((Object)this.editor, ActionRegistry.class);
        GraphContextMenuProvider cmProvider = new GraphContextMenuProvider(this.graph, this.sharedResources, (EditPartViewer)this.graphViewer, registry);
        this.graphViewer.setContextMenu((MenuManager)cmProvider);
        this.getSite().registerContextMenu((MenuManager)cmProvider, (ISelectionProvider)this.graphViewer);
        this.graphViewer.setContents(this.graph);
        this.graphViewer.addDropTargetListener((TransferDropTargetListener)new TemplateTransferDropTargetListener((EditPartViewer)this.graphViewer));
        this.splitter.setGraphicalControl(this.graphViewer.getControl());
        if (this.page != null) {
            this.splitter.setExternalViewer(this.page.getPaletteViewer());
            this.page = null;
        }
        this.updateGrid();
        this.updateZoom();
        this.getSite().setSelectionProvider((ISelectionProvider)this.graphViewer);
    }

    public void dispose() {
        if (this.graphViewer != null) {
            this.graphViewer.dispose();
        }
        this.graph.removePropertyListener(this.builderListener);
        this.processor.dispose();
        P4BranchGraphPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        CommandStack stack = this.getEditDomain().getCommandStack();
        if (stack != null) {
            stack.removeCommandStackListener((CommandStackListener)this.editor.getRegistry());
        }
        super.dispose();
    }

    public void setFocus() {
        this.displayArea.setFocus();
    }

    @Override
    public InterchangesProcessor getProcessor() {
        return this.processor;
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return this.graphViewer;
    }

    @Override
    public IBranchGraph getGraph() {
        return this.graph;
    }

    @Override
    public IBranchGraphBuilder getBuilder() {
        return this.builder;
    }

    private void updateGrid() {
        boolean selected = P4BranchGraphPlugin.getDefault().getPreferenceStore().getBoolean("SHOW_GRID");
        this.graphViewer.setProperty("SnapToGrid.isEnabled", selected);
        this.graphViewer.setProperty("SnapToGrid.isVisible", selected);
    }

    private void updateZoom() {
        String level = P4BranchGraphPlugin.getDefault().getPreferenceStore().getString("ZOOM_LEVEL");
        if (level.length() == 0) {
            level = "100%";
        }
        this.rootEditPart.getZoomManager().setZoomAsText(level);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("SHOW_GRID".equals(event.getProperty())) {
            this.updateGrid();
        } else if ("ZOOM_LEVEL".equals(event.getProperty())) {
            this.updateZoom();
        }
    }

    private BranchGraphPalettePage createPalettePage() {
        return new BranchGraphPalettePage(this.getPaletteViewerProvider(), this);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == CommandStack.class) {
            return this.getEditDomain().getCommandStack();
        }
        if (adapter == PalettePage.class) {
            if (this.splitter == null) {
                this.page = this.createPalettePage();
                return this.page;
            }
            return this.createPalettePage();
        }
        if (adapter == EditPartViewer.class || adapter == GraphicalViewer.class) {
            return this.graphViewer;
        }
        return super.getAdapter(adapter);
    }

    @Override
    public ISelectionProvider getGraphSelectionProvider() {
        return this.graphViewer;
    }

    @Override
    public FlyoutPaletteComposite getFlyout() {
        return this.splitter;
    }

    @Override
    public void refresh() {
        this.refreshStatus();
    }
}

